-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkNotebook objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_notebook_writer.e,v 1.7 2000/08/31 14:02:17 elphick Exp $"

class GTK_NOTEBOOK_WRITER

inherit

	GTK_COMPOSED_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation
		end

	CHILD

creation

	make

feature

	type: STRING is "GTK_NOTEBOOK"
	
	children: ARRAY[TAG_TREE]
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			show_tabs := widget_tree.get_boolean_string_from_field("show_tabs")
			show_border := widget_tree.get_boolean_string_from_field("show_border")
			tab_pos := widget_tree.get_string_from_field("tab_pos")
			scrollable := widget_tree.get_boolean_string_from_field("scrollable")
			tab_hborder := widget_tree.get_integer_string_from_field("tab_hborder")
			tab_vborder := widget_tree.get_integer_string_from_field("tab_vborder")
			popup_enable := widget_tree.get_boolean_string_from_field("popup_enable")

			children := widget_tree.find_children("widget")
			if children /= Void and then children.count.odd then
				print("A notebook must have an even number of children%N")
				print("One label for each page%N")
				die_with_code(exit_failure_code)
			end
			create_child_class_array(children, 1)
		end

	show_tabs: STRING
	show_border: STRING
	tab_pos: STRING
	scrollable: STRING
	tab_hborder: STRING
	tab_vborder: STRING
	popup_enable: STRING
			
	append_parent_creation(code: ARRAY[STRING]) is
		local
			i: INTEGER
		do
			code.add_last("!!" + name + ".make")
			code.add_last(name + ".set_tab_pos("+ tab_pos + ")")
			code.add_last(name + ".show_tabs(" + show_tabs + ")")
			code.add_last(name + ".show_border(" + show_border + ")")
			code.add_last(name + ".set_scrollable_tabs(" + scrollable + ")")
			add_widget_code(code)
			from
				i := 0
			until
				i >= widgets.count
			loop
				(widgets @ i).append_parent_creation(code);-- added because se
						-- warns that it needs to add a ; ? Why?
				(widgets @ (i+1)).append_parent_creation(code)
				-- assume the widgets are stored in pairs
				-- page followed by label. Note eGTK says pages are Containers?
				code.add_last(name + ".append_page(" + (widgets @ i).name +
					", " + (widgets @ (i+1)).name + ")")
				i := i + 2
			end
		end

end
