-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkPacker objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_packer_writer.e,v 1.6 2000/08/31 14:02:17 elphick Exp $"

class GTK_PACKER_WRITER

inherit

	GTK_COMPOSED_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, append_add_widget_code, parent_inherit
		end

	CHILD

creation

	make

feature

	type: STRING is "GTK_PACKER"
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			default_border_width := widget_tree.get_integer_string_from_field("default_border_width")
			default_pad_x := widget_tree.get_integer_string_from_field("default_pad_x")
			default_pad_y := widget_tree.get_integer_string_from_field("default_pad_y")
			default_ipad_x := widget_tree.get_integer_string_from_field("default_ipad_x")
			default_ipad_y := widget_tree.get_integer_string_from_field("default_ipad_y")
			create_child_class_array(widget_tree.find_children("widget"), 1)
		end
			
	default_border_width: STRING
	default_pad_x: STRING
	default_pad_y: STRING
	default_ipad_x: STRING
	default_ipad_y: STRING
	use_defaults: BOOLEAN

	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make")
			code.add_last(name + ".set_default_border_width(" + default_border_width + ")")
			code.add_last(name + ".set_default_pad(" + default_pad_x + ", " + default_pad_y + ")")
			code.add_last(name + ".set_default_ipad(" + default_ipad_x + ", " + default_ipad_y + ")")
			add_widget_code(code)
			precursor(code)
		end

	append_add_widget_code(code: ARRAY[STRING]; widget: CAN_BE_CREATED) is
		local
			temp_child: CHILD
		do
			temp_child ?= widget
			if temp_child.flag("use_default", True) then
				code.add_last(name + ".add_defaults(" + widget.name +
					", " + temp_child.property("side") +
					", " + temp_child.property("anchor") +
					", " + options(temp_child) + ")")
			else
				code.add_last(name + ".add(" + widget.name +
					", " + temp_child.property("side") +
					", " + temp_child.property("anchor") +
					", " + options(temp_child) +
					", " + temp_child.property("border_width") +
					", " + temp_child.property("xpad") + 
					", " + temp_child.property("ypad") + 
					", " + temp_child.property("xipad") + 
					", " + temp_child.property("yipad") + ")")
			end
		end

	options(child: CHILD): STRING is
		do
			!!Result.make(10)
			if child.flag("expand", False) then
				Result.append("Gtk_pack_expand")
			end
			if child.flag("xfill", False) then
				if not Result.is_empty then
					Result.append(" + ")
				end
				Result.append("Gtk_fill_x")
			end
			if child.flag("yfill", False) then
				if not Result.is_empty then
					Result.append(" + ")
				end
				Result.append("Gtk_fill_y")
			end
			if Result.is_empty then
				Result.copy("0")
			end
		end

	parent_inherit: INHERIT_LIST is
		local
			temp: KLASS
		do
			!!temp.make_with_name("GTK_PACKER_EXTERNALS")
			temp.add_undefine_clause("is_equal, copy")
			!!Result.make
			Result.add(temp)
		end

end
