-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkTree objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_tree_writer.e,v 1.9 2000/07/10 11:31:12 elphick Exp $"

class GTK_TREE_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, parent_inherit
		end

	CHILD

creation

	make

feature

	type:STRING is "GTK_TREE"
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			selection_mode := widget_tree.get_string_from_field("selection_mode")
			view_mode := widget_tree.get_string_from_field("view_mode")
			view_line := widget_tree.get_boolean_string_from_field("homogeneous")
		end
			
	selection_mode: STRING
	view_mode: STRING
	view_line: STRING

	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make")
			code.add_last(name + ".set_selection_mode(" + selection_mode + ")")
			code.add_last(name + ".set_view_mode(" + view_mode + ")")
			add_widget_code(code)
			-- How do you make it show lines??
		end

	parent_inherit: INHERIT_LIST is
		local
			temp: KLASS
		do
			!!Result.make
			!!temp.make_with_name("GTK_CONSTANTS")
			temp.add_undefine_clause("is_equal, copy")
			Result.add(temp)
			!!temp.make_with_name("GTK_SELECTIONMODE_ENUM")
			temp.add_undefine_clause("is_equal, copy")
			Result.add(temp)
		end

end
