#ifndef PTABS_H
#define PTABS_H

/* generated constants */


#define BASE		1

#define PAEOF		1

#define STPROD		45



/* generated tables which are not */
/* changable by optimization      */


static unsigned char conncode[]  =  {

  10,  11,  12,  13,  14,  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,
  26,  27,  28,  29,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,
  42,  43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,   0 
};



static unsigned char lhs [] =  {

      0,     1,     1,     2,     2,     2,     3,     3,     3,     4,     4
,     4,     7,     7,     7,     7,     7,     7,     7,     7,     5,     5
,     5,     8,     8,     8,     8,     8,     8,     9,     9,     9,     9
,     9,     9,     9,     9,     9,     9,     9,    10,    10,    10,     6
,     6,    11
};



static unsigned char len [] =  {

      1,     2,     0,     1,     1,     1,     2,     3,     3,     3,     2
,     2,     1,     1,     1,     1,     1,     1,     1,     1,     2,     2
,     2,     2,     2,     2,     3,     2,     2,     1,     2,     1,     3
,     3,     3,     2,     2,     4,     3,     2,     2,     1,     1,     1
,     1,     2
};



static unsigned char cont[]  =  {

   1,  34,  27,  17,  17,   2,   6,   4,  41,   1,   1,  41,  21,  41,  41,  41,
  25,  41,  41,  21,  21,  41,  41,  38,  41,  32,  32,  28,  41,  32,  21,  32,
  41,  41,  21,  41 
};



static char terminf[]  =  {

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
};



/* macro for accessing the terminal-table */
/* the Row Displacement Scheme is performed for the terminal-table */

#define SIGMAP(row , col) (sigmap[row][col >> 3] >> (col & 0x0007)) & 0x01

#define GET_TTABENTRY( RorS, Act, term ) \
	{\
	  register    U_SHORT j;\
	  j = conv[ term ]; \
	  if( SIGMAP( sigrowind[RorS], sigcolind[j] ) )  { \
	    j = ttab[ trowptr[RorS] + j ]; \
	    Act  = j & ACTIONMASK; \
	    RorS = j & OPERANDMASK; \
	  }\
	  else \
	    Act  = 0; \
	}

static unsigned char conv [] =  {

      0,     0,     1,     2,     3,     4,     5,     6,     7,     8,     9
,    10,    11,    12,    13,    14,    15,    16,    17,    18,    19,    20
,    21,    22,    23,    24,    25,    26,    27,    28,    29,    30,    31
,    32,    33,    34,    35,    36,    37,    38,    39,    40
};



static unsigned char sigrowind [] =  {

      0,     1,     2,     3,     3,     4,     5,     6,     7,     0,     8
,     7,     9,     7,     7,     7,    10,     7,     7,     9,     9,     7
,     7,    11,     7,    12,    13,    14,     7,    12,     9,    12,     7
,     7,     9,     7
};



static unsigned char sigcolind [] =  {

      0,     1,     2,     3,     2,     4,     2,     2,     2,     5,     5
,     5,     5,     5,     5,     5,     5,     2,     2,     6,     7,     8
,     9,     8,    10,     8,     8,    11,    12,    13,    12,    14,    12
,    12,    12,    15,    12,    16,    12,    17,    17
};



static unsigned char sigmap[][3] =  {

 0x07,0x00,0x00,0x00,0x3a,0x00,0x40,0x03,0x00,0x20,0x00,0x00,0x02,0x00,0x00,0x50
,0x28,0x00,0x08,0x00,0x00,0x00,0x00,0x02,0x01,0x00,0x00,0x80,0x00,0x00,0x00,0x04
,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00,0xc0,0x00,0x00,0x08,0x00
};



static unsigned char trowptr[] = {

     0,     0,    18,     0,     0,     2,    26,     2,     7,     0,    19,
     7,     0,     7,     7,     7,     0,     7,     7,     1,     3,     7,
     7,     5,     7,     4,    17,    22,     7,    19,     5,    20,     7,
     7,     6,     7 
};



static unsigned short ttab [] =  {

 0x2002,0x1008,0x1007,0x100e,0x1006,0x100b,0x1005,0x1004,0x1003,0x400c,0x400d
,0x400e,0x400f,0x4010,0x4011,0x4012,0x4013,0x1002,0x1001,0x8000,0x4028,0x4017
,0x101c,0x401c,0x1015,0x4022,0x4021,0x401d,0x101b,0x401f,0x101a,0x100d,0x1019
,0x101d,0x1018,0x1022,0x1017,0x1013,0x1016,0x1012,0x1011,0x1010,0x1023,0x100f
,0x1014,0x100c,0x402b,0x402c,0x1020,0x401e,0x101e,0x1021,0x101f,0x4029,0x0000
,0x402a
};



/* macro for accessing the nonterminal-table */
/* the Row Displacement Scheme is performed for the nonterminal-table */

#define GET_NTABENTRY(RorS, Act, State, lhsnt) \
	{\
	  register      U_SHORT j;\
	  j = ntab[ nrowptr[State] + lhsnt ]; \
	  Act = j & ACTIONMASK; \
	  RorS = j & OPERANDMASK; \
	}

static unsigned char nrowptr[] = {

     0,     0,     0,     0,     3,     0,     1,     0,     0,    11,     0,
    11,     0,    12,    13,    14,     0,    15,    16,     0,     0,    17,
    18,     0,    19,     0,     0,     0,    20,     0,     0,     0,    21,
    22,     0,    23 
};



static unsigned short ntab [] =  {

 0x600a,0x9000,0x6009,0x9003,0x9004,0x9005,0x9006,0x900b,0x9014,0x9015,0x900a
,0x9016,0x9001,0x6009,0x9003,0x9004,0x9005,0x9007,0x9008,0x9009,0x901b,0x9019
,0x9018,0x901a,0x9027,0x9023,0x9024,0x9020,0x9025,0x9026
};





#endif

static	char *state2terms[] = {
	(char *)NULL,	/* state 1 */
	(char *)NULL,	/* state 2 */
	(char *)NULL,	/* state 3 */
	(char *)NULL,	/* state 4 */
	(char *)NULL,	/* state 5 */
	"\"INFO\"",	/* state 6 */
	"\"AUTOMATIC\", \"SWITCH\", \"SIZE\" or \"IF\"",	/* state 7 */
	"\"POS\"",	/* state 8 */
	"\"OFF\" or \"ON\"",	/* state 9 */
	(char *)NULL,	/* state 10 */
	"\"EOF\"",	/* state 11 */
	"\"OFF\" or \"ON\"",	/* state 12 */
	"\"integer\"",	/* state 13 */
	"\"OFF\" or \"ON\"",	/* state 14 */
	"\"OFF\" or \"ON\"",	/* state 15 */
	"\"OFF\" or \"ON\"",	/* state 16 */
	"\"PUSH\"",	/* state 17 */
	"\"OFF\" or \"ON\"",	/* state 18 */
	"\"OFF\" or \"ON\"",	/* state 19 */
	"\"integer\"",	/* state 20 */
	"\"integer\"",	/* state 21 */
	"\"OFF\" or \"ON\"",	/* state 22 */
	"\"OFF\" or \"ON\"",	/* state 23 */
	"\"REDUCE\"",	/* state 24 */
	"\"OFF\" or \"ON\"",	/* state 25 */
	"\"ROWS\"",	/* state 26 */
	"\"ROWS\" or \"NT\"",	/* state 27 */
	"\"IF\"",	/* state 28 */
	"\"OFF\" or \"ON\"",	/* state 29 */
	"\"ROWS\"",	/* state 30 */
	"\"integer\"",	/* state 31 */
	"\"ROWS\"",	/* state 32 */
	"\"OFF\" or \"ON\"",	/* state 33 */
	"\"OFF\" or \"ON\"",	/* state 34 */
	"\"integer\"",	/* state 35 */
	"\"OFF\" or \"ON\"",	/* state 36 */
	(char *)NULL
}; /* of array state2terms[] */
