C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      SUBROUTINE JINTEND
C
C---->
C**** JINTEND
C
C     PURPOSE
C     _______
C
C     This routine deallocates heap memory (if any) allocated
C     by JINTLL, JINTGG and/or INTF.
C
C     INTERFACE
C     _________
C
C     CALL JINTEND( )
C
C
C     Input parameters
C     ________________
C
C     None.
C
C
C     Output parameters
C     ________________
C
C     None.
C
C
C     Common block usage
C     __________________
C
C     None.
C
C
C     Method
C     ______
C
C     None.
C
C
C     Externals
C     _________
C
C     None.
C
C
C     Reference
C     _________
C
C     None.
C
C
C     Comments
C     ________
C
C     None.
C
C
C     AUTHOR
C     ______
C
C     J.D.Chambers      *ECMWF*      May 1994
C
C
C     MODIFICATIONS
C     _____________
C
C     None.
C
C----<
C     _______________________________________________________
C
C*    Section 0. Definition of variables.
C     _______________________________________________________
C
      IMPLICIT NONE
C
C     Local variables
C
#ifdef POINTER_64
      INTEGER*8 IZERO
#else
      INTEGER IZERO
#endif
      INTEGER IRET
      DATA IZERO/0/
C
C     _______________________________________________________
C
C*    Section 1.    Deallocate heap memory.
C     _______________________________________________________
C
  100 CONTINUE
C
C     Lat/long (JINTLL)
C
      CALL JMEMHAN( 1, IZERO, 0, 0, IRET )
C
C     Gaussian (JINTGG)
C
      CALL JMEMHAN( 2, IZERO, 0, 0, IRET )
C
C     Scratch (INTF)
C
      CALL JMEMHAN( 3, IZERO, 0, 0, IRET )
      CALL JMEMHAN( 4, IZERO, 0, 0, IRET )
      CALL JMEMHAN( 5, IZERO, 0, 0, IRET )
C
C     _______________________________________________________
C
C*    Section 9. Return to calling routine.
C     _______________________________________________________
C
 900  CONTINUE
C
      RETURN
C
      END
