Name: encfs
Summary: Encrypted pass-thru filesystem for Linux
Version: 1.7.2
Release: @RELEASE@
License: GPL
Group: System/Filesystems
Source: %{name}-%{version}-%{release}.tgz
BuildRoot: %{_tmppath}/build-root-%{name}
Packager: Valient Gough <vgough at pobox dot com>
#Distribution: Suse 9.1
Prefix: /usr
Url: http://pobox.com/~vgough/encfs
Provides: encfs
Provides: encfsctl
Provides: libencfs.1

Requires: rlog >= 1.3
Requires: openssl
Requires: fuse >= 2.2

%description
EncFS implements an encrypted filesystem in userspace using FUSE.  FUSE
provides a Linux kernel module which allows virtual filesystems to be written
in userspace.  EncFS encrypts all data and filenames in the filesystem and
passes access through to the underlying filesystem.  Similar to CFS except that
it does not use NFS. 

%changelog
* Fri Nov 11 2005 Valient Gough <vgough@pobox.com>
- Release 1.2.5
- Fix race condition when using newer versions of GCC.  Fixes problem reported
  by Chris at x.nu.
- add encfssh script, thanks to David Rosenstrauch
* Fri Aug 26 2005 Valient Gough <vgough@pobox.com>
- Release 1.2.4
- fix segfault if small invalid filenames were encountered in the encrypted
  directory, reported by paulgfx.
- try and detect if user tries to mount the filesystem over the top of the
  encrypted directory, problem reported by paulgfx.
- environment variable ENCFS5_CONFIG can be used to override the location of
  the .encfs5 configuration file.
- add encfsctl 'export' command, patch from Janne Hellsten
  
* Tue Apr 19 2005 Valient Gough <vgough@pobox.com>
- Release 1.2.1
- add --public mount option
- add --stdinpass option to read password from stdin for scripting
- import latest rosetta translation updates

* Thu Feb 10 2005 Valient Gough <vgough@pobox.com>
- Release 1.2.0
- Fix bug with MAC headers and files > 2GB, reported by Damian Frank
- Fix bug with external password interface which could result in problems
  communicating with external password program.  Found by Olivier Dournaux.
- Switch to FUSE 2.2 API -- support for FUSE 1.x has been dropped.
- Add support for inode numbering pass-thru (when used 'use_ino' option to
  fuse).  This allows encoded filesystem to use the same inode numbers as the
  underlying filesystem.

* Wed Jan 12 2005 Valient Gough <vgough@pobox.com>
- Release 1.1.11
- add internationalization support.  Thanks to lots of contributors, there are
  translations for serveral languages.
- added workaround for libfuse mount failure with FUSE 1.4
- fix compile failure with FUSE 1.4

* Mon Nov 8 2004 Valient Gough <vgough@pobox.com>
- Release 1.1.10
- fix problems with recursive rename
- fix incorrect error codes from xattr functions

* Tue Aug 15 2004 Valient Gough <vgough@pobox.com>
- Release 1.1.9
- fix another rename bug (affected filesystems with 'paranoia' configuration)

* Mon Aug 14 2004 Valient Gough <vgough@pobox.com>
- Release 1.1.8
- Improve MAC block header processing.

* Sat Aug 12 2004 Valient Gough <vgough@pobox.com>
- Release 1.1.7
- fix bug in truncate() for unopened files.

* Mon Aug 9 2004 Valient Gough <vgough@pobox.com>
- Release 1.1.6
- fix header IV creation when truncate() used to create files.
- add support for IV chaining to old 0.x filesystem support code (useful for
  systems with old OpenSSL, like RedHat 7.x).

* Tue Jul 22 2004 Valient Gough <vgough@pobox.com>
- Release 1.1.5

* Sat Jul 10 2004 Valient Gough <vgough@pobox.com>
- Release 1.1.4
- add external password prompt support.

* Thu Jun 24 2004 Valient Gough <vgough@pobox.com>
- Release 1.1.3

* Fri May 28 2004 Valient Gough <vgough@pobox.com>
- Release 1.1.2
- Fix bug affecting filesystems with small empty directories (like XFS)
- Updates to recursive rename code to undo all changes on failure.
- Fix OpenSSL dependency path inclusion in build.

* Wed May 19 2004 Valient Gough <vgough@pobox.com>
- Release 1.1.1
- Fix MAC header memory size allocation error.
- Add file rename-while-open support needed for Evolution.

* Thu May 13 2004 Valient Gough <vgough@pobox.com>
- Second release candidate for version 1.1
- Add support for block mode filename encryption.
- Add support for per-file initialization vectors.
- Add support for directory IV chaining for per-directory initialization
  vectors.
- Add support for per-block MAC headers for file contents.
- Backward compatibility support dropped for filesystems created by version
  0.x.  Maintains backward compatible support for versions 1.0.x.

* Sun Apr 4 2004 Valient Gough <vgough@pobox.com>
- Release 1.0.5
- Allow truncate call to extend file (only shrinking was supported)

* Fri Mar 26 2004 Valient Gough <vgough@pobox.com>
- Release 1.0.4
- Large speed improvement.
- Add support for FUSE major version 2 API.

* Thu Mar 18 2004 Valient Gough <vgough@pobox.com>
- Release 1.0.3
- Fix bugs in truncation and padding code.

* Sat Mar 13 2004 Valient Gough <vgough@pobox.com>
- Release 1.0.2
- Use pkg-config to check for OpenSSL and RLog build settings
- Add support for '--' argument to encfs to pass arbitrary options to FUSE /
  fusermount.
- Add man pages.

* Tue Mar 2 2004 Valient Gough <vgough@pobox.com>
- Release 1.0.1
- Fix problem with using OpenSSL's EVP_BytesToKey function with variable
  key length ciphers like Blowfish, as it would only generate 128 bit keys.
- Some configure script changes to make it possible to use --with-extra-include
  configure option to pick up any necessary directories for OpenSSL.

* Fri Feb 27 2004 Valient Gough <vgough@pobox.com>
- Release 1.0
- Added some pre-defined configuration options at startup to make filesystem
  creation a bit more user friendly.

* Mon Feb 23 2004 Valient Gough <vgough@pobox.com>
- Merge development branch to mainline.  Source modularized to make it easier
  to support different algorithms.
- Added encfsctl program which can show information about an encrypted
  directory and can change the user password used to store the volume key.
- Added support for AES and BlowFish with user specified keys and block sizes
  (when building with OpenSSL >= 0.9.7).
- Backward compatible with old format, but new filesystems store configuration
  information in a new format which is not readable by old encfs versions.

* Sat Feb 7 2004 Valient Gough <vgough@pobox.com>
- Improved performance by fixing cache bug which caused cached data to not be
  used as often as it could have been.  Random seek performance improved by
  600% according to Bonnie++ benchmark.
- Fixed bugs preventing files larger then 2GB.  Limit should now be around
  128GB (untested - I don't have that much drive space).  > 2GB also requires
  recent version of FUSE module (from Feb 6 or later) and an underlying
  filesystem which supports large files.
- Release 0.6

%prep
rm -rf $RPM_BUILD_ROOT 
mkdir $RPM_BUILD_ROOT

%setup -q

%build
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" \
./configure --enable-debug=no --prefix=%{prefix} --mandir=%{_mandir}
make SED=/usr/bin/sed -j 2

%install
make DESTDIR=$RPM_BUILD_ROOT install-strip

cd $RPM_BUILD_ROOT

find . -type d -fprint $RPM_BUILD_DIR/file.list.%{name}.dirs
find . -type f -fprint $RPM_BUILD_DIR/file.list.%{name}.files.tmp
sed '/\/man\//s/$/.gz/g' $RPM_BUILD_DIR/file.list.%{name}.files.tmp > $RPM_BUILD_DIR/file.list.%{name}.files
find . -type l -fprint $RPM_BUILD_DIR/file.list.%{name}.libs
sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' $RPM_BUILD_DIR/file.list.%{name}.dirs > $RPM_BUILD_DIR/file.list.%{name}
sed 's,^\.,\%attr(-\,root\,root) ,' $RPM_BUILD_DIR/file.list.%{name}.files >> $RPM_BUILD_DIR/file.list.%{name}
sed 's,^\.,\%attr(-\,root\,root) ,' $RPM_BUILD_DIR/file.list.%{name}.libs >> $RPM_BUILD_DIR/file.list.%{name}

%clean
case "$RPM_BUILD_ROOT" in build-root-*) rm -rf $RPM_BUILD_ROOT ;; esac
rm -f $RPM_BUILD_DIR/file.list.%{name}
rm -f $RPM_BUILD_DIR/file.list.%{name}.libs
rm -f $RPM_BUILD_DIR/file.list.%{name}.files
rm -f $RPM_BUILD_DIR/file.list.%{name}.files.tmp
rm -f $RPM_BUILD_DIR/file.list.%{name}.dirs

%files -f ../file.list.%{name}

%defattr(-,root,root,0755)
