#ifndef EDV_OPEN_CB_H
#define EDV_OPEN_CB_H

#include <glib.h>
#include "edv_types.h"


typedef struct _edv_open_cb_data_struct	edv_open_cb_data_struct;
#define EDV_OPEN_CB_DATA(p)		((edv_open_cb_data_struct *)(p))


/*
 *	Open Callback Data:
 */
struct _edv_open_cb_data_struct {

	edv_core_struct	*core;
	gchar		*command_name;

	GList		*(*paths_list_get_cb)(
		gpointer		/* Data */
	);
	gpointer	paths_list_get_data;

	void		(*goto_directory_cb)(
		gpointer,		/* Data */
		const gchar *		/* Path */
	);
	gpointer	goto_directory_data;

        GtkWidget	*toplevel;
	gboolean	verbose;

};


extern edv_open_cb_data_struct *EDVOpenCBDataNew(void);
extern void EDVOpenCBDataDelete(edv_open_cb_data_struct *d);

extern void EDVOpenCB(GtkWidget *widget, gpointer data);


#endif	/* EDV_OPEN_CB_H */
