/*
                                 Run Dialog
 */

#ifndef RUN_DLG_H
#define RUN_DLG_H

#include <gtk/gtk.h>
#include "edv_types.h"


typedef struct _edv_run_dlg_struct		edv_run_dlg_struct;
#define EDV_RUN_DLG(p)	((edv_run_dlg_struct *)(p))


/*
 *	Run Dialog:
 */
struct _edv_run_dlg_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gboolean	processing;
	gint		busy_count,
			freeze_count;
	edv_core_struct	*core;

	GtkWidget	*main_vbox,
			*run_combo, *browse_btn, *clear_btn,
			*working_dir_entry, *working_dir_browse_btn,
				*working_dir_clear_btn,
				*working_dir_get_from_cmd_btn,
			*run_in_terminal_check, *keep_dialog_check,
			*options_btn,
			*run_btn,
			*close_btn;

};


/* In rundlg.c */
extern void EDVRunDlgSetCommand(
	edv_run_dlg_struct *d, const char *command
);
extern void EDVRunDlgSetWorkingDir(
	edv_run_dlg_struct *d, const char *working_dir
);
extern void EDVRunDlgFetchValues(edv_run_dlg_struct *d);

extern edv_run_dlg_struct *EDVRunDlgNew(edv_core_struct *core);
extern void EDVRunDlgSetBusy(edv_run_dlg_struct *d, gboolean is_busy);
extern gboolean EDVRunDlgIsMapped(edv_run_dlg_struct *d);
extern void EDVRunDlgMap(edv_run_dlg_struct *d);
extern void EDVRunDlgUnmap(edv_run_dlg_struct *d);
extern void EDVRunDlgDelete(edv_run_dlg_struct *d);


#endif	/* RUN_DLG_H */
