# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing an icon provider for QFileDialog.
"""

from PyQt4.QtCore import pyqtSignature, QFileInfo
from PyQt4.QtGui import QFileIconProvider

import UI.PixmapCache

class E4IconProvider(QFileIconProvider):
    """
    Class providing icons to KQFileDialog.

    The icons provided are for Python (*.py, *.pyw, *.pyx, *.ptl), Ruby (*.rb)
    Qt-Designer (*.ui), QT-Linguist (*.ts, *.qm), Qt-Resource (*.qrc), IDL (*.idl),
    graphics, eric3 keyboard shortcuts (*.e3k, *.e3kz), eric4 keyboard 
    shortcuts (*.e4k, *.e4kz), eric3 project (*.e3p, *.e3pz) and eric4 project 
    (*.e4p, *.e4pz) files.
    """
    def __init__(self):
        """
        Constructor
        """
        QFileIconProvider.__init__(self)

    def icon(self, finfoOrType):
        """
        Method to retrieve the icon for a file.
        
        @param finfoOrType file info object (QFileInfo) 
            or icon type (QFileIconProvider.IconType)
        @return icon for the file (QIcon)
        """
        if isinstance(finfoOrType, QFileInfo):
            if finfoOrType.isRoot():
                return UI.PixmapCache.getIcon("devHarddisk.png")
            elif finfoOrType.isFile():
                ext = unicode(finfoOrType.suffix())
                if ext in ['py']:
                    iconName = "filePython"
                elif ext in ['pyw', 'pyx', 'ptl']:
                    iconName = "filePython2"
                elif ext == 'rb':
                    iconName = "fileRuby"
                elif ext == 'ui':
                    iconName = "fileDesigner"
                elif ext in ['ts']:
                    iconName = "fileLinguist"
                elif ext in ['qm']:
                    iconName = "fileLinguist2"
                elif ext in ['qrc']:
                    iconName = "fileResource"
                elif ext in ['e3p', 'e3pz', 'e4p', 'e4pz']:
                    iconName = "fileProject"
                elif ext == 'idl':
                    iconName = "fileIDL"
                elif ext in ['png', 'jpg', 'jpeg', 'xpm', 'bmp', 'xbm', 
                             'pnm', 'pbm', 'pgm', 'ppm', 'gif', 'mng']:
                    iconName = "filePixmap"
                elif ext in ['e3k', 'e3kz', 'e4k', 'e4kz']:
                    iconName = "fileShortcuts"
                else:
                    iconName = "fileMisc"
                if finfoOrType.isSymLink():
                    link = "Link"
                else:
                    link = ""
                return UI.PixmapCache.getIcon("%s%s.png" % (iconName, link))
            elif finfoOrType.isDir():
                if finfoOrType.isSymLink():
                    return UI.PixmapCache.getIcon("dirClosedLink.png")
                else:
                    return UI.PixmapCache.getIcon("dirClosed.png")
            else:
                print "default path"
                return QFileIconProvider.icon(self, finfoOrType)
        else:
            if finfoOrType == QFileIconProvider.Computer:
                return UI.PixmapCache.getIcon("devSystem.png")
            elif finfoOrType == QFileIconProvider.Desktop:
                return UI.PixmapCache.getIcon("devDesktop.png")
            elif finfoOrType == QFileIconProvider.Trashcan:
                return UI.PixmapCache.getIcon("devTrashcan.png")
            elif finfoOrType == QFileIconProvider.Network:
                return UI.PixmapCache.getIcon("devNetwork.png")
            elif finfoOrType == QFileIconProvider.Drive:
                return UI.PixmapCache.getIcon("devHarddisk.png")
            elif finfoOrType == QFileIconProvider.Folder:
                return UI.PixmapCache.getIcon("dirClosed.png")
            elif finfoOrType == QFileIconProvider.File:
                return UI.PixmapCache.getIcon("fileMisc.png")
            else:
                return QIcon()
