# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Package implementing compatibility modules for using KDE dialogs instead og Qt dialogs.

The different modules try to import the KDE dialogs and implement interfaces, that are
compatible with the standard Qt dialog APIs. If the import fails, the modules fall back
to the standard Qt dialogs.

In order for this package to work PyKDE must be installed (see 
<a href="http://www.riverbankcomputing.co.uk/pykde">
http://www.riverbankcomputing.co.uk/pykde</a>.
"""

import os

import Preferences

try:
    raise ImportError
    # TODO: KDE 4
##    import kdecore
##    import pykdeconfig
##    from PyQt4.QtCore import QString
##    
##    def __kdeIsKDE():
##        """
##        Public function to signal the availability of KDE.
##        
##        @return availability flag (always 1)
##        """
##        return 1
##        
##    def __kdeKdeVersionString():
##        """
##        Public function to return the KDE version as a string.
##        
##        @return KDE version as a string (QString)
##        """
##        try:
##            from kdecore import KDE
##            return KDE.versionString()
##        except (ImportError, AttributeError):
##            try:
##                return QString(pykdeconfig.Configuration().kde_version_str)
##            except:
##                return QString("unknown")
##        
##    def __kdePyKdeVersionString():
##        """
##        Public function to return the PyKDE version as a string.
##        
##        @return PyKDE version as a string (QString)
##        """
##        try:
##            return QString(pykdeconfig.Configuration().pykde_version_str)
##        except:
##            return QString("unknown")
    
except (ImportError, RuntimeError):
    os.environ["e4nokde"] = "1"
    
from PyQt4.QtCore import QString

def __qtIsKDE():
    """
    Private function to signal the availability of KDE.
    
    @return availability flag (always False)
    """
    return False
    
def __qtKdeVersionString():
    """
    Private function to return the KDE version as a string.
    
    @return KDE version as a string (QString) (always empty)
    """
    return QString("")
    
def __qtPyKdeVersionString():
    """
    Private function to return the PyKDE version as a string.
    
    @return PyKDE version as a string (QString) (always empty)
    """
    return QString("")

################################################################################

def isKDEAvailable():
    """
    Public function to signal the availability of KDE.
    
    @return availability flag (always False)
    """
    return not os.getenv("e4nokde")

def isKDE():
    """
    Public function to signal, if KDE usage is enabled.
    
    @return KDE support flag (always False)
    """
    if Preferences.getUI("UseKDEDialogs") and not os.getenv("e4nokde"):
        return __kdeIsKDE()
    else:
        return __qtIsKDE()
    
def kdeVersionString():
    """
    Public function to return the KDE version as a string.
    
    @return KDE version as a string (QString) (always empty)
    """
    if Preferences.getUI("UseKDEDialogs") and not os.getenv("e4nokde"):
        return __kdeKdeVersionString()
    else:
        return __qtKdeVersionString()
    
def pyKdeVersionString():
    """
    Public function to return the PyKDE version as a string.
    
    @return PyKDE version as a string (QString) (always empty)
    """
    if Preferences.getUI("UseKDEDialogs") and not os.getenv("e4nokde"):
        return __kdePyKdeVersionString()
    else:
        return __qtPyKdeVersionString()
