###################################################
### chunk number 1: 
###################################################
library(eRm)
data(raschdat1)
res.rasch <- RM(raschdat1)
pres.rasch <- person.parameter(res.rasch)


###################################################
### chunk number 2: 
###################################################
lrres.rasch <- LRtest(res.rasch, splitcr = "mean", se = TRUE)
lrres.rasch


###################################################
### chunk number 3: 
###################################################
plotGOF(lrres.rasch, beta.subset=c(14,5,18,7,1), tlab="item", conf=list(ia=FALSE,col="blue",lty="dotted"))


###################################################
### chunk number 4: 
###################################################
data(lltmdat2)
W <- matrix(c(1,2,1,3,2,2,2,1,1,1),ncol=2)
res.lltm <- LLTM(lltmdat2, W)
summary(res.lltm)


###################################################
### chunk number 5: 
###################################################
data(pcmdat2)
res.rsm <- RSM(pcmdat2)
thresholds(res.rsm)


###################################################
### chunk number 6: 
###################################################
plotICC(res.rsm, mplot=TRUE, legpos=FALSE,ask=FALSE)


###################################################
### chunk number 7: 
###################################################
plotICC(res.rsm, mplot=TRUE, legpos=FALSE,ask=FALSE)


###################################################
### chunk number 8: 
###################################################
res.pcm <- PCM(pcmdat2)
plotPImap(res.pcm, sorted = TRUE)


###################################################
### chunk number 9: 
###################################################
res.pcm <- PCM(pcmdat2)
plotPImap(res.pcm, sorted = TRUE)


###################################################
### chunk number 10: 
###################################################
pres.pcm <- person.parameter(res.pcm)
itemfit(pres.pcm)


###################################################
### chunk number 11: 
###################################################
lr<- 2*(res.pcm$loglik-res.rsm$loglik)
df<- res.pcm$npar-res.rsm$npar
pvalue<-1-pchisq(lr,df)
cat("LR statistic: ", lr, "  df =",df, "  p =",pvalue, "\n")


###################################################
### chunk number 12: 
###################################################
data(lpcmdat)
grouplpcm <- rep(1:2, each = 10)


###################################################
### chunk number 13: 
###################################################
reslpcm <- LPCM(lpcmdat, mpoints = 2, groupvec = grouplpcm, sum0 = FALSE)
model.matrix(reslpcm)


###################################################
### chunk number 14: 
###################################################
reslpcm


