/* msn_interface.c - functions that talk to the outside world */

#include <stdio.h>

#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/poll.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdlib.h>
#include <string.h>

#include "msn_core.h"
#include "msn_interface.h"

struct pollfd socks[21];

int countsocks(void);

msnconn * mainconn;

main()
{
  for(int a=0; a<20; a++)
  { socks[a].fd=-1; socks[a].events=POLLIN; socks[a].revents=0; }
  socks[0].fd=0;
  socks[0].events=POLLIN;
  socks[0].revents=0;

  fprintf(stderr, "Enter your login name: ");
  fflush(stdout);
  char uname[512];
  char pass[512];
  fgets(uname, 512, stdin);
  uname[strlen(uname)-1]='\0';

  fprintf(stderr, "Enter your password: ");
  fgets(pass, 512, stdin);
  pass[strlen(pass)-1]='\0';

  fprintf(stderr, "Now connecting to the MSN Messenger service, hold onto your hats...\n");

  mainconn=new msnconn;
  msn_init(mainconn, uname, pass);
  msn_connect(mainconn, "messenger.hotmail.com", 1863);// 64.4.13.56

  fprintf(stderr, "> ");
  fflush(stderr);
  while(1)
  {
    poll(socks, 20, -1);
    for(int a=1; a<20; a++)
    {
      if(socks[a].fd==-1) { break; }
      if(socks[a].revents & POLLHUP) { socks[a].revents=0; continue; }
      if(socks[a].revents & (POLLERR|POLLNVAL))
      {
        printf("Dud socket (%d)! Code %x (ERR=%x, INVAL=%x)\n", socks[a].fd, socks[a].revents, POLLERR, POLLNVAL);
        msn_handle_close(socks[a].fd);
        socks[a].fd=-1;
        socks[a].revents=0;
        continue;
      }
      if(socks[a].revents & (POLLIN|POLLPRI))
      {
        //printf("Incoming on socket number %d (%d)\n", a, socks[a].fd);
        msn_handle_incoming(socks[a].fd);
      }
      socks[a].revents=0;
    }
    if(socks[0].revents & POLLIN)
    {
      handle_command();
      socks[0].revents=0;
    }
  }
}

void handle_command(void)
{
  char command[40];

  scanf(" %s", command);

  if(!strcmp(command, "quit"))
  {
    exit(0);
  } else if(!strcmp(command, "msg")) {
    char rcpt[80];
    char msg[1024];

    scanf(" %s", rcpt);

    fgets(msg, 1024, stdin);

    msg[strlen(msg)-1]='\0';

    msn_send_IM(mainconn, rcpt, msg);
  } else if(!strcmp(command, "status")) {
    char state[10];

    scanf(" %s", state);

    msn_set_state(mainconn, state);
  } else if(!strcmp(command, "friendlyname")) {
    char fn[256];

    fgets(fn, 256, stdin);
    fn[strlen(fn)-1]='\0';

    msn_set_friendlyname(mainconn, fn);
  } else if(!strcmp(command, "add")) {
    char list[10];
    char user[128];

    scanf(" %s %s", list, user);

    msn_add_to_list(mainconn, list, user);
  } else if(!strcmp(command, "del")) {
    char list[10];
    char user[128];

    scanf(" %s %s", list, user);

    msn_del_from_list(mainconn, list, user);
  } else {
    fprintf(stderr, "\nBad command \"%s\"", command);
  }

  fprintf(stderr, "\n> ");
  fflush(stderr);
}

int countsocks(void) // at last!  parental nagging has a result --My father
{
  int retval=0;

  for(int a=0; a<20; a++)
  {
    if(socks[a].fd==-1) { break; }
    retval++;
  }
  return retval;
}

void ext_register_sock(int s)
{
  for(int a=0; a<20; a++)
  {
    if(socks[a].fd==-1) { socks[a].fd=s; printf("Added socket %d\n", a); return; }
  }
}

void ext_unregister_sock(int s)
{
  for(int a=0; a<20; a++)
  {
    if(socks[a].fd==s)
    {
      for(int b=a; b<19; b++)
      {
        socks[b].fd=socks[b+1].fd;
      }
      socks[19].fd=-1;
    }
  }
}

void ext_got_friendlyname(msnconn * conn, char * friendlyname)
{
  printf("Your friendlyname is now: %s\n", friendlyname);
}

void ext_got_info(msnconn * conn, syncinfo * info)
{
  printf("Got the sync info!\n");
}

void ext_latest_serial(msnconn * conn, int serial)
{
  printf("The latest serial number is: %d\n", serial);
}

void ext_got_GTC(msnconn * conn, char c)
{
  printf("Your GTC value is now %c\n", c);
}

void ext_got_BLP(msnconn * conn, char c)
{
  printf("Your BLP value is now %cL\n", c);
}

void ext_new_rl_entry(msnconn * conn, char * username, char * friendlyname)
{
  printf("%s (%s) has added you to their contact list.\nYou might want to add them to your Allow or Block list\n", username, friendlyname);
}

void ext_new_list_entry(msnconn * conn, char * list, char * username)
{
  printf("%s is now on your %s\n", username, list);
}

void ext_del_list_entry(msnconn * conn, char * list, char * username)
{
  printf("%s has been removed from your %s\n", username, list);
}

void ext_show_error(char * msg)
{
  printf("MSN: Error: %s\n", msg);
}

void ext_buddy_set(msnconn * conn, char * buddy, char * friendlyname, char * status)
{
  printf("%s (%s) is now %s\n", friendlyname, buddy, status);
}

void ext_buddy_offline(msnconn * conn, char * buddy)
{
  printf("%s is now offline\n", buddy);
}

void ext_got_SB(msnconn * conn, void * tag)
{
  printf("Got switchboard connection\n");
}

void ext_user_joined(msnconn * conn, char * username, char * friendlyname, int is_initial)
{
  printf("%s (%s) is now in the session\n", friendlyname, username);
}

void ext_user_left(msnconn * conn, char * username)
{
  printf("%s has now left the session\n", username);
}

void ext_got_IM(msnconn * conn, char * username, char * friendlyname, char * msg)
{
  printf("--- Message from %s (%s):\n%s\n", friendlyname, username, msg);
}

void ext_IM_failed(msnconn * conn)
{
  printf("**************************************************\n");
  printf("ERROR:  Your last message failed to send correctly\n");
  printf("**************************************************\n");
}

void ext_typing_user(msnconn * conn, char * username, char * friendlyname)
{
  printf("\t%s (%s) is typing...\n", friendlyname, username);
}


void ext_new_connection(msnconn * conn)
{
}

void ext_closing_connection(msnconn * conn)
{
  printf("Closed connection with socket %d\n", conn->sock);
}

void ext_changed_state(msnconn * conn, char * state)
{
  printf("Your state is now: %s\n", state);
}

int ext_connect_socket(char * hostname, int port)
{
  struct sockaddr_in sa;
  struct hostent     *hp;
  int a, s;

  if ((hp= gethostbyname(hostname)) == NULL) { /* do we know the host's */
    errno= ECONNREFUSED;                       /* address? */
    return(-1);                                /* no */
  }

  memset(&sa,0,sizeof(sa));
  memcpy((char *)&sa.sin_addr,hp->h_addr,hp->h_length);     /* set address */
  sa.sin_family= hp->h_addrtype;
  sa.sin_port= htons((u_short)port);

  if ((s= socket(hp->h_addrtype,SOCK_STREAM,0)) < 0)     /* get socket */
    return(-1);
  if (connect(s,(struct sockaddr *)&sa,sizeof sa) < 0) { /* connect */
    close(s);
    return(-1);
  }
  sleep(2);
  return(s);
}
