/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * msn.c
 */

#include <stdio.h>
#include "info_window.h"
#include "value_pair.h"
#include "input_list.h"
#include "plugin_api.h"
#include "account.h"
#include "service.h"

/*************************************************************************************
 *                             Begin Module Code
 ************************************************************************************/
/*  Module defines */
#define plugin_info msn2_LTX_plugin_info
#define SERVICE_INFO msn2_LTX_SERVICE_INFO
#define plugin_init msn2_LTX_plugin_init
#define plugin_finish msn2_LTX_plugin_finish

/* Function Prototypes */
int plugin_init();
int plugin_finish();

static int ref_count = 0;

/*  Module Exports */
PLUGIN_INFO plugin_info = {
	PLUGIN_SERVICE, 
	"MSN Service New", 
	"MSN Messenger support, new library", 
	"$Revision: 1.1 $",
	"$Date: 2002/03/04 20:34:33 $",
	&ref_count,
	plugin_init,
	plugin_finish
};
struct service SERVICE_INFO = { "MSN", -1, FALSE, FALSE, FALSE, FALSE, NULL };
/* End Module Exports */

int plugin_init()
{
	eb_debug(DBG_MOD, "MSN\n");
	ref_count=0;
	return(0);
}

int plugin_finish()
{
	eb_debug(DBG_MOD, "Returning the ref_count: %i\n", ref_count);
	return(ref_count);
}

/*************************************************************************************
 *                             End Module Code
 ************************************************************************************/

static char msn_server[255] = "messenger.hotmail.com";
static char msn_port[10] = "1863";

static int do_mail_notify = 0;
static int do_mail_notify_show = 0;
static int do_mail_notify_run_script = 0;
static char do_mail_notify_script_name[255];
static input_list * msn_prefs = NULL;


gboolean eb_msn_query_connected( eb_account * account )
{
    return FALSE;
}

void eb_msn_login( eb_local_account * account )
{}

void eb_msn_logout( eb_local_account * account )
{}

void eb_msn_send_im( eb_local_account * from, eb_account * account_to, 
					 gchar * message)
{}

eb_local_account * eb_msn_read_local_account_config( GList * values )
{
	return(NULL);
}

GList * eb_msn_write_local_config( eb_local_account * account )
{
	return(NULL);
}


eb_account * eb_msn_read_account_config( GList * config, struct contact * contact)
{
	return(NULL);
}

GList * eb_msn_get_states()
{
	return(NULL);
}

gint eb_msn_get_current_state( eb_local_account * account )
{
	return(0);
}

void eb_msn_set_current_state( eb_local_account * account, gint state )
{}

void eb_msn_terminate_chat(eb_account * account )
{}

void eb_msn_add_user(eb_account * account )
{}

void eb_msn_del_user(eb_account * account )
{}

eb_account * eb_msn_new_account( gchar * account )
{
	return(NULL);
}

void eb_msn_get_status_pixmap( eb_account * account, GdkPixmap ** pm, GdkBitmap ** bm )
{}

gchar * eb_msn_get_status_string( eb_account * account )
{
	return(NULL);
}

void eb_msn_set_idle( eb_local_account * account, gint idle )
{}

void eb_msn_set_away( eb_local_account * account, char * message )
{}

void eb_msn_send_chat_room_message( eb_chat_room * room, gchar * message )
{
}

void eb_msn_join_chat_room( eb_chat_room * room )
{
}

void eb_msn_leave_chat_room( eb_chat_room * room )
{
}

eb_chat_room * eb_msn_make_chat_room( gchar * name, eb_local_account * account )
{
	return NULL;
}

void eb_msn_send_invite( eb_local_account * account, eb_chat_room * room,
						  char * user, char * message )
{
}

void eb_msn_get_info( eb_local_account * reciever, eb_account * sender)
{}

void msn_info_update(info_window *iw)
{}

input_list * eb_msn_get_prefs()
{
	return(NULL);
}

void eb_msn_read_prefs_config(GList * values)
{}

GList * eb_msn_write_prefs_config()
{
	return(NULL);
}

struct service_callbacks * query_callbacks()
{
	struct service_callbacks * sc;

	sc = g_new0( struct service_callbacks, 1 );
	
	sc->query_connected = eb_msn_query_connected;
	sc->login = eb_msn_login;
	sc->logout = eb_msn_logout;
	sc->send_im = eb_msn_send_im;
	sc->read_local_account_config = eb_msn_read_local_account_config;
	sc->write_local_config = eb_msn_write_local_config;
	sc->read_account_config = eb_msn_read_account_config;
	sc->get_states = eb_msn_get_states;
	sc->get_current_state = eb_msn_get_current_state;
	sc->set_current_state = eb_msn_set_current_state;
	sc->add_user = eb_msn_add_user;
	sc->del_user = eb_msn_del_user;
	sc->new_account = eb_msn_new_account;
	sc->get_status_string = eb_msn_get_status_string;
	sc->get_status_pixmap = eb_msn_get_status_pixmap;
	sc->set_idle = eb_msn_set_idle;
	sc->set_away = eb_msn_set_away;
	sc->send_chat_room_message = eb_msn_send_chat_room_message;
	sc->join_chat_room = eb_msn_join_chat_room;
	sc->leave_chat_room = eb_msn_leave_chat_room;
	sc->make_chat_room = eb_msn_make_chat_room;
	sc->send_invite = eb_msn_send_invite;
	sc->terminate_chat = eb_msn_terminate_chat;
        sc->get_info = eb_msn_get_info;

	sc->get_prefs = eb_msn_get_prefs;
	sc->read_prefs_config = eb_msn_read_prefs_config;
	sc->write_prefs_config = eb_msn_write_prefs_config;
	sc->add_importers = NULL;

	{
		input_list * il = g_new0(input_list, 1);
		msn_prefs = il;
		il->widget.entry.value = msn_server;
		il->widget.entry.name = "Server:";
		il->type = EB_INPUT_ENTRY;

		il->next = g_new0(input_list, 1);
		il = il->next;
		il->widget.entry.value = msn_port;
		il->widget.entry.name = "Port:";
		il->type = EB_INPUT_ENTRY;
		
		il->next = g_new0(input_list, 1);
		il = il->next;
		il->widget.checkbox.value = &do_mail_notify;
		il->widget.checkbox.name = "MSN Mail Notification";
		il->type = EB_INPUT_CHECKBOX;

		il->next = g_new0(input_list, 1);
                il = il->next;
                il->widget.checkbox.value = &do_mail_notify_show;
                il->widget.checkbox.name = "Show Mail Notification";
                il->type = EB_INPUT_CHECKBOX;

		il->next = g_new0(input_list, 1);
                il = il->next;
                il->widget.checkbox.value = &do_mail_notify_run_script;
                il->widget.checkbox.name = "Run Script on Mail Notification";
                il->type = EB_INPUT_CHECKBOX;

		il->next = g_new0(input_list, 1);
                il = il->next;
		il->widget.entry.value = do_mail_notify_script_name;
                il->widget.entry.name = "Script Name:";
                il->type = EB_INPUT_ENTRY;
	}

	return sc;
}
