%token ACCOUNT END_ACCOUNT GROUP END_GROUP CONTACT END_CONTACT 
%{
	#include <gtk/gtk.h>
	#include <stdio.h>
	#include <stdlib.h>

	#include "globals.h"
	#include "account.h"
	#include "value_pair.h"
	#include "service.h"
	#include "trigger.h"
	#include "triggerdecls.h"

	extern int Line_contact;
	#define contacterror(error) printf("Parse error on line %d: %s\n", Line_contact, error );
	static struct contact * cur_contact = NULL; 
	static grouplist * cur_group = NULL;
	extern int contactlex();

%}

%union {
	GList * vals;
	value_pair * val;
	grouplist * grp;
	gchar * string;
	eb_account * acnt;
	struct contact * cntct;
}

%token <string> IDENTIFIER
%token <string> STRING
%type <vals> group_list
%type <grp> group
%type <vals> contact_list
%type <cntct> contact
%type <vals> account_list
%type <acnt> account
%type <vals> value_list
%type <val> key_pair
%%

start:
	group_list { groups = $1; }
;

group_list:
		group group_list { $$ = g_list_prepend( $2, $1 ); }
	|	EPSILON { $$ = 0; }
;

group:	
	 GROUP value_list 
	{ 
		char * c;
		cur_group = g_new0(grouplist, 1);
		c = value_pair_get_value( $2, "NAME" );
		strcpy( cur_group->name, c );
		cur_group->tree = NULL;
		value_pair_free($2);
	}
				contact_list END_GROUP	{ cur_group->members = $4;  
		$$ = cur_group; }
;
	
contact_list:
		contact contact_list { $$ = g_list_prepend( $2, $1 ); }
	|	EPSILON { $$ = 0; }
;

contact:
	CONTACT value_list
	{
		char * c;
		cur_contact = g_new0( struct contact, 1 );
		c = value_pair_get_value( $2, "NAME" );
		strcpy( cur_contact->nick, c );

		c = value_pair_get_value( $2, "TRIGGER_TYPE" );
		cur_contact->trigger.type = get_trigger_type_num(c); 

		c = value_pair_get_value( $2, "TRIGGER_ACTION" );
		cur_contact->trigger.action = get_trigger_action_num(c); 

		c = value_pair_get_value( $2, "TRIGGER_PARAM" );
		if(c)
		{
			strcpy( cur_contact->trigger.param ,c ); 
		}
		else
		{
			cur_contact->trigger.param[0] = '\0';
		}

		c = value_pair_get_value( $2, "DEFAULT_PROTOCOL" );
		cur_contact->default_chatb = get_service_id(c);
		cur_contact->default_filetransb = cur_contact->default_chatb;
		cur_contact->group = cur_group;
		cur_contact->list_item = NULL;
		cur_contact->tree = NULL;
		cur_contact->pix = NULL;
		cur_contact->status = NULL;
		cur_contact->icon_handler = -1;
		cur_contact->label = NULL; 
		value_pair_free($2);
	}
	account_list END_CONTACT { cur_contact->accounts = $4;  
		$$=cur_contact; }
;	

account_list:
	 	account account_list{ $$ = g_list_prepend( $2, $1 ); }
	 |	EPSILON { $$ = 0; }

;

account:
	'<' ACCOUNT IDENTIFIER '>' value_list '<' END_ACCOUNT '>' 
	{
		{
			int id = get_service_id($3);

			$$ = eb_services[id].sc->read_account_config($5, cur_contact);
			$$->service_id = id;
			value_pair_free($5);
			g_free($3);
		}
	}
					
;

value_list:
		key_pair value_list { $$ = g_list_append( $2, $1 ); }
	|	key_pair { $$ = g_list_append(NULL, $1); }

;

key_pair:
		IDENTIFIER '=' STRING
		{
			{
				value_pair * vp = g_new0( value_pair, 1 );
				strcpy( vp->key, $1 );
				strcpy( vp->value, $3 );

				free($1);
				free($3);
				$$ = vp;
			}
		}
;

EPSILON : ;
