/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkprivate.h>
#include <stdlib.h>
#include "dialog.h"
#include "util.h"
#include "status.h"
#include "pixmaps/ebicon.xpm"
#include "pixmaps/tb_yes.xpm"
#include "pixmaps/tb_no.xpm"

#include "libproxy/libproxy.h"
#include "globals.h"

static GdkPixmap *icon_pm = NULL;
static GdkBitmap *icon_bm = NULL;

/*------------------------------------------------------------------------*/
/* Function for making buttons											  */
/*------------------------------------------------------------------------*/

static void set_option(GtkWidget * w, int * data )
{
	*data = !(*data);	
	write_prefs();
}

GtkWidget *eb_button(const char *text, int *value, GtkWidget *page)
{
    GtkWidget *button;
    button = gtk_check_button_new_with_label(text);
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), *value);
    gtk_box_pack_start(GTK_BOX(page), button, FALSE, FALSE, 0);
    gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(set_option), value);
    gtk_widget_show(button);
    return button;
}

GtkWidget *eb_push_button(const char *text, GtkWidget *page)
{
    GtkWidget *button;
    button = gtk_button_new_with_label(text);
    gtk_box_pack_start(GTK_BOX(page), button, FALSE, FALSE, 0);
    gtk_widget_show(button);
    return button;
}

/*
  eb_radio function
*/

GSList * eb_radio (GSList * group, const char * text, int curr_val,
		   int set_val, GtkWidget *page, void * set_element)
{
  GtkWidget * radio;

  /* Create Button w/ or w/out text, as requested */
  if (text == NULL)
    {
      radio = gtk_radio_button_new (group);
    }
  else
    {
      radio = gtk_radio_button_new_with_label (group, text);
    }

  /* select this button if it should be */
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(radio),
			       (curr_val == set_val));

  /* add this button to whatever box given */
  gtk_box_pack_start (GTK_BOX(page), radio, FALSE, FALSE, 0);

  /* Set the callback that we're told to set and the argument */
  gtk_signal_connect(GTK_OBJECT(radio), "clicked",
		     GTK_SIGNAL_FUNC(set_element), (void *) set_val);

  /* Make this visible */
  gtk_widget_show (radio);

  /* Return the group */
  return (gtk_radio_button_group (GTK_RADIO_BUTTON(radio)));
}

/*
 * Generalized menu functions ;)
 */

GtkWidget * eb_menu_button (GtkMenu * menu, gchar * label,
			    GtkSignalFunc callback_func,
			    gpointer callback_arg)
{
  GtkWidget * button;
  
  button = gtk_menu_item_new_with_label(label);
  gtk_signal_connect(GTK_OBJECT(button), "activate",
		    callback_func, callback_arg);
  gtk_menu_append(menu, button);
  gtk_widget_show(button);

  return (button);
}

GtkWidget * eb_menu_submenu (GtkMenu * menu, gchar * label,
			     GtkWidget *submenu)
{
  GtkWidget * button;
  
  button = gtk_menu_item_new_with_label(label);
  gtk_menu_append(GTK_MENU(menu), button);

  gtk_menu_item_set_submenu (GTK_MENU_ITEM (button), submenu);
  gtk_widget_show(button);

  return (button);
}

/*
 * End generalized menu functions
 */



/*------------------------------------------------------------------------*/
/* Function for creating Everybuddy Icon on Windows                       */
/*------------------------------------------------------------------------*/

void eb_icon(GdkWindow *w)
{
	GdkAtom icon_atom;
	glong data[2];
        if (icon_pm == NULL) {
                icon_pm = gdk_pixmap_create_from_xpm_d(w, &icon_bm,
                          NULL, (gchar **)ebicon);
        }

		data[0] = ((GdkPixmapPrivate *)icon_pm)->xwindow;
		data[1] = ((GdkPixmapPrivate *)icon_bm)->xwindow;

		icon_atom = gdk_atom_intern( "KWM_WIN_ICON", FALSE);
		gdk_property_change (w, icon_atom, icon_atom,
				32, GDK_PROP_MODE_REPLACE,
				(guchar *)data, 2);

        gdk_window_set_icon(w, NULL, icon_pm, icon_bm);
//		gdk_window_set_back_pixmap(w, icon_pm, 0 );
 //       gdk_window_set_group(w, statuswindow->window);
}

void list_dialog_callback(GtkWidget *widget,
			gint row,
			gint column,
			GdkEventButton *event,
			gpointer data)
{
	gchar *text;
	list_dialog_data *ldd = data;

	gtk_clist_get_text(GTK_CLIST(widget), row, column, &text);
	ldd->callback(strdup(text), ldd->data);
}

void do_list_dialog( gchar * message, gchar * title, char **list, void (*action)(char * text, gpointer data), gpointer data )
{
	GtkWidget * dialog_window;
	GtkWidget * label;
	GtkWidget * clist;
	GtkWidget * button_box;
	char *Row[2]={NULL, NULL};
	list_dialog_data *ldata;

	if(list[0]==NULL)
		return;
	dialog_window = gtk_dialog_new();

	gtk_widget_realize(dialog_window);
	gtk_window_set_title(GTK_WINDOW(dialog_window), title );

	label = gtk_label_new(message);
	gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog_window)->vbox),
        label, FALSE, FALSE, 5);

	/* Convert the **list to a GList */
	clist = gtk_clist_new(1);	/* Only 1 column */
	gtk_clist_set_selection_mode(GTK_CLIST(clist), GTK_SELECTION_SINGLE);
	gtk_clist_set_column_width (GTK_CLIST(clist), 0, 200);
	/* Array of pointers to elements, one per column */
	while(*list) {
		Row[0]=*list;
		list++;
		gtk_clist_append(GTK_CLIST(clist), Row);
	}

	ldata=calloc(1, sizeof(list_dialog_data));
	ldata->callback=action;
	ldata->data=data;
	gtk_signal_connect(GTK_OBJECT(clist),
		"select_row",
		GTK_SIGNAL_FUNC(list_dialog_callback),
		ldata);
	gtk_signal_connect_object(GTK_OBJECT(clist),
		"select_row",
		GTK_SIGNAL_FUNC(gtk_widget_destroy),
		(gpointer)dialog_window);
	gtk_widget_show(clist);
	/* End list construction */

	button_box = gtk_hbox_new(FALSE, 5);

	gtk_box_pack_start(GTK_BOX(button_box), label, FALSE, FALSE, 2 );

	gtk_container_add(GTK_CONTAINER(list), button_box);
	gtk_widget_show(button_box);
	
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog_window)->action_area), 
						clist, FALSE, FALSE, 5 );

	gtk_widget_show_all(dialog_window);
}

void do_dialog( gchar * message, gchar * title, void (*action)(GtkWidget * widget, gpointer data), gpointer data )
{
	GtkWidget * dialog_window;
	GtkWidget * button;
	GtkWidget * label;
	GdkPixmap *pm;
	GdkBitmap *bm;
	GtkWidget * button_box;

	dialog_window = gtk_dialog_new();

	gtk_widget_realize(dialog_window);
	gtk_window_set_title(GTK_WINDOW(dialog_window), title );



	label = gtk_label_new(message);
    gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog_window)->vbox),
        label, FALSE, FALSE, 5);

    button_box = gtk_hbox_new(FALSE, 5);
	pm = gdk_pixmap_create_from_xpm_d(statuswindow->window, &bm, NULL, tb_yes_xpm);
	label = gtk_pixmap_new(pm, bm);

	gtk_box_pack_start(GTK_BOX(button_box), label, FALSE, FALSE, 2 );

	label = gtk_label_new("Yes");
	gtk_box_pack_start(GTK_BOX(button_box), label, FALSE, FALSE, 2 );


	button = gtk_button_new();
	gtk_container_add(GTK_CONTAINER(button), button_box);
	gtk_widget_show(button_box);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			 		   GTK_SIGNAL_FUNC(action), data );
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
			                  GTK_SIGNAL_FUNC(gtk_widget_destroy),
							  (gpointer)dialog_window);
	gtk_object_set_user_data(GTK_OBJECT(button), (gpointer)1);
	
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog_window)->action_area), 
						button, FALSE, FALSE, 5 );

    button_box = gtk_hbox_new(FALSE, 5);
	pm = gdk_pixmap_create_from_xpm_d(statuswindow->window, &bm, NULL, tb_no_xpm);
	label = gtk_pixmap_new(pm, bm);

	gtk_box_pack_start(GTK_BOX(button_box), label, FALSE, FALSE, 2 );

	label = gtk_label_new("No");
	gtk_box_pack_start(GTK_BOX(button_box), label, FALSE, FALSE, 2 );


	button = gtk_button_new();
	gtk_container_add(GTK_CONTAINER(button), button_box);

	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			 		   GTK_SIGNAL_FUNC(action), data);
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
			                  GTK_SIGNAL_FUNC(gtk_widget_destroy),
							  (gpointer)dialog_window);
	gtk_object_set_user_data(GTK_OBJECT(button), (gpointer)0 );

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog_window)->action_area), 
						button, FALSE, FALSE, 5 );

	gtk_widget_show_all(dialog_window);
}

	
	

/*------------------------------------------------------------------------*/
/*  The dialog for getting an error                                       */
/*------------------------------------------------------------------------*/

GtkWidget*
do_error_dialog(char *message, char *title)
{
    GtkWidget *d;
    GtkWidget *label;
    GtkWidget *close;


    d = gtk_dialog_new();
    /* if parent is not main window, set it.
     * This prevents this dialog from popping up 'underneath' another
     * dialog to which it applies
     */
    if(current_parent_widget)
    {
	gtk_window_set_transient_for(GTK_WINDOW(d),
				     GTK_WINDOW(current_parent_widget));
    }
    label = gtk_label_new(message);
    gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
    gtk_widget_show(label);
    close = gtk_button_new_with_label("OK");
    gtk_widget_show(close);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(d)->vbox),
        label, FALSE, FALSE, 5);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(d)->action_area),
        close, FALSE, FALSE, 5);
    /* so text isn't up against the border */
    gtk_container_set_border_width(GTK_CONTAINER(d), 5);
    gtk_widget_realize(d);
    gtk_window_set_title(GTK_WINDOW(d), title);
    gtk_signal_connect_object(GTK_OBJECT(close), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(d));
	gtk_window_set_modal(GTK_WINDOW(d), TRUE);

    gtk_widget_show(d);
    return d;
}

