/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * editcontacts.c
 */


#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "account.h"
#include "service.h"
#include "globals.h"
#include "status.h"
#include "util.h"
#include "contact.h"
#include "dialog.h"
#include "service.h"
#include "value_pair.h"
#include "pixmaps/ok.xpm"
#include "pixmaps/cancel.xpm"
#include "pixmaps/tb_trash.xpm"
#include "pixmaps/tb_edit.xpm"
#include "pixmaps/tb_preferences.xpm"
#include "pixmaps/tb_book_open.xpm"

enum
{
	USER_NAME,
	PASSWORD,
	SERVICE_TYPE
};

typedef char * account_row[3];

static GtkWidget * account_list;
static GtkWidget * account_window = NULL;
static GtkWidget * username;
static GtkWidget * password;
static GtkWidget * service_type;
static GtkWidget * mod_button;
static GtkWidget * del_button;
static gint selected_row = -1;
static gboolean is_open = FALSE;
static gint num_accounts = 0;

static void destroy(GtkWidget * widget, gpointer data)
{
	is_open = FALSE;
	num_accounts = 0;
	selected_row = -1;
}

static void read_contacts()
{
	account_row text;
	GList * node;

	for(node = accounts; node; node = node->next)
	{
		eb_local_account * ela = node->data;
		GList * pairs = RUN_SERVICE(ela)->write_local_config(ela);

		text[SERVICE_TYPE] = strdup(eb_services[ela->service_id].name);

		text[USER_NAME] = strdup(value_pair_get_value(pairs, "SCREEN_NAME"));

		text[PASSWORD] = strdup(value_pair_get_value(pairs, "PASSWORD"));

		value_pair_free(pairs);

		gtk_clist_append(GTK_CLIST(account_list), text);
		num_accounts++;
	}
}

static void selection_unmade(GtkWidget *clist,
								gint	row,
								gint	column,
								GdkEventButton *event,
								gpointer	data)
{
	gtk_entry_set_text(GTK_ENTRY(username),  "");
	gtk_entry_set_text(GTK_ENTRY(password),  "");
}

static void selection_made(GtkWidget      *clist,
                            gint            row,
                            gint            column,
                            GdkEventButton *event,
                            gpointer        data)
{

	gchar *entry_name;
	gchar *entry_pass;
	gchar *entry_service;

	selected_row = row;

	/* Put data in selected row into the entry boxes for revision */
	
	gtk_clist_get_text(GTK_CLIST(clist), row, USER_NAME, &entry_name); 
	gtk_clist_get_text(GTK_CLIST(clist), row, PASSWORD, &entry_pass); 
	gtk_clist_get_text(GTK_CLIST(clist), row, SERVICE_TYPE, &entry_service); 
	gtk_entry_set_text(GTK_ENTRY(username),  entry_name);
	gtk_entry_set_text(GTK_ENTRY(password),  entry_pass);
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(service_type)->entry), entry_service);
	
	gtk_widget_set_sensitive(mod_button, TRUE);
	gtk_widget_set_sensitive(del_button, TRUE);
	
   return;
}

static void remove_callback(GtkWidget * widget, gpointer data)
{
	if(selected_row != -1)
	{
		gtk_clist_remove(GTK_CLIST(account_list), selected_row);
		num_accounts--;
		selected_row = -1;
	}
}

static void options_callback(GtkWidget * widget, gpointer data)
{
	build_prefs();
}

static void cancel_callback(GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy(account_window);
	if(!statuswindow)
		gtk_main_quit();
}

static void ok_callback(GtkWidget * widget, gpointer data)
{
	FILE * fp;
	char buff[1024];
	char * service, *user, *pass;
	int i;
	int id;
	GList *pairs=NULL;
	eb_local_account *ela=NULL;


	g_snprintf(buff, 1024, "%saccounts",config_dir);

	fp=fdopen(creat(buff, 0700), "w");

	for(i = 0; i < num_accounts; i++)
	{
		gtk_clist_get_text(GTK_CLIST(account_list), i, SERVICE_TYPE, &service); 
		gtk_clist_get_text(GTK_CLIST(account_list), i, USER_NAME, &user); 
		gtk_clist_get_text(GTK_CLIST(account_list), i, PASSWORD, &pass); 

		fprintf(fp, "<ACCOUNT %s>\n\tSCREEN_NAME=\"%s\"\n\tPASSWORD=\"%s\"\n</ACCOUNT>\n", 
				service, g_strstrip(user), g_strstrip(pass));
		if(accounts) {
			id=get_service_id(service);
			ela = find_local_account_by_handle(user, id);
			if(ela) {
			}
			else {
				eb_debug(DBG_CORE, "Adding new account %s service %s\n", user, service);
				pairs = value_pair_add(NULL, "SCREEN_NAME", user);
				pairs = value_pair_add(pairs, "PASSWORD", pass);
				save_account_info(service, pairs);
				ela = eb_services[id].sc->read_local_account_config(pairs);
				accounts = g_list_append(accounts, ela);
			}
		}
	}

	fclose(fp);

	gtk_widget_destroy(account_window);

	/* if this was an inital launch, start up EB */
	if(!accounts)
	{
		load_accounts();
		load_contacts();
		eb_status_window();
	}
	else
		rebuild_set_status_menu();
}

static void add_callback(GtkWidget * widget, gpointer data)
{
	char * text[3];

	text[USER_NAME] = gtk_entry_get_text(GTK_ENTRY(username));
	text[PASSWORD] = gtk_entry_get_text(GTK_ENTRY(password));
	text[SERVICE_TYPE] = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(service_type)->entry));

	gtk_clist_append(GTK_CLIST(account_list), text);
	num_accounts++;
	printf("num_acccounts %d\n",num_accounts);
	gtk_entry_set_text(GTK_ENTRY(username), "");
	gtk_entry_set_text(GTK_ENTRY(password), "");
}

static void modify_callback(GtkWidget * widget, gpointer data)
{
	char * text[3];
	
	/* update selected row in list */
	
	text[USER_NAME] = gtk_entry_get_text(GTK_ENTRY(username));
	gtk_clist_set_text(GTK_CLIST(account_list), 
			selected_row, USER_NAME, text[USER_NAME]);
	
	text[PASSWORD] = gtk_entry_get_text(GTK_ENTRY(password));
	gtk_clist_set_text(GTK_CLIST(account_list), 
						selected_row, PASSWORD, text[PASSWORD]);

	text[SERVICE_TYPE] = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(service_type)->entry));
	gtk_clist_set_text(GTK_CLIST(account_list), 
						selected_row, SERVICE_TYPE, text[SERVICE_TYPE]);

	/* reset the entry fields */

	gtk_entry_set_text(GTK_ENTRY(username), "");
	gtk_entry_set_text(GTK_ENTRY(password), "");
}
		
void eb_new_user()
{
	char * text[] ={"Screen Name", "Password", "Service Type"};
	GtkWidget * box;
	GtkWidget * window_box;
	GtkWidget * hbox;
	GtkWidget * button_box;
	GtkWidget * label;
	GtkWidget * iconwid;
	GtkWidget * toolbar;
	GtkWidget * toolitem;
	GtkWidget * frame;
	GtkWidget * separator;
	GList * list;
	GdkPixmap *icon;
	GdkBitmap *mask;

	if(is_open)
		return;

	is_open = 1;

	account_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_realize(account_window);
	account_list = gtk_clist_new_with_titles(3,text); 
	gtk_clist_set_column_visibility(GTK_CLIST(account_list), PASSWORD, FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(account_window), 5);
	gtk_signal_connect(GTK_OBJECT(account_list), "select_row",
	                  	GTK_SIGNAL_FUNC(selection_made),
	                  	NULL);
	gtk_signal_connect(GTK_OBJECT(account_list), "unselect_row",
						GTK_SIGNAL_FUNC(selection_unmade), 
						NULL);
	
	box = gtk_vbox_new(FALSE, 0);
	window_box = gtk_vbox_new(FALSE,5);
	hbox = gtk_hbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);

	/*Screen Name Section*/
   
	label = gtk_label_new("Screen Name:");
	gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 0);
	gtk_widget_show(label);
	username = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(box), username, FALSE, FALSE, 2);
	gtk_widget_show(username);

	/*Password Section*/
   
	label = gtk_label_new("Password:");
	gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 5);
	gtk_widget_show(label);
	password = gtk_entry_new();
	gtk_entry_set_visibility(GTK_ENTRY(password), FALSE);
	gtk_box_pack_start(GTK_BOX(box), password, FALSE, FALSE, 2);
	gtk_widget_show(password);

	/*Service Type Section*/
   
	label = gtk_label_new("Service Type:");
	gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 5);
	gtk_widget_show(label);
	service_type = gtk_combo_new();
	list = get_service_list();
	gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(service_type)->entry), FALSE);
	gtk_combo_set_popdown_strings(GTK_COMBO(service_type), list);
	g_list_free(list);
	gtk_widget_show(service_type);
	gtk_box_pack_start(GTK_BOX(box), service_type, FALSE, FALSE, 2);
	
	gtk_box_pack_start(GTK_BOX(hbox), box, FALSE, FALSE, 2);  
	gtk_widget_show(box);
	
	box = gtk_vbox_new(FALSE, 0);

	read_contacts();

	gtk_box_pack_start(GTK_BOX(box), account_list, TRUE, TRUE, 0);
	gtk_widget_show(account_list);

	gtk_box_pack_start(GTK_BOX(hbox), box, TRUE, TRUE, 2);
	gtk_widget_show(box);

	/*Initialize a frame for everything up to this point to go in*/
	
	frame = gtk_frame_new(NULL);
	gtk_frame_set_label(GTK_FRAME(frame), "Account Editor");

 	gtk_container_add(GTK_CONTAINER(frame), hbox);
    gtk_widget_show(hbox);

	gtk_box_pack_start(GTK_BOX(window_box), frame, TRUE, TRUE, 0);
	gtk_widget_show(frame);

   	button_box = gtk_hbox_new(FALSE, 0);
	
	/*Initialize Toolbar*/

	toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
	gtk_toolbar_set_button_relief(GTK_TOOLBAR(toolbar), GTK_RELIEF_NONE);
	gtk_container_set_border_width(GTK_CONTAINER(toolbar), 0);
   	gtk_toolbar_set_space_size(GTK_TOOLBAR(toolbar), 5);
   
	/*Add Button*/
   
	icon = gdk_pixmap_create_from_xpm_d(account_window->window, &mask, NULL, tb_preferences_xpm);
	iconwid = gtk_pixmap_new(icon, mask);
	gtk_widget_show(iconwid);
	toolitem = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
										"Add",
                              			"Add Account",
                              			"Add",
                              			iconwid,
                              			GTK_SIGNAL_FUNC(add_callback),
                              			NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
	
	/*Delete Button*/
	
	icon = gdk_pixmap_create_from_xpm_d(account_window->window, &mask, NULL, tb_trash_xpm);
	iconwid = gtk_pixmap_new(icon, mask);
	gtk_widget_show(iconwid);
	del_button = gtk_toolbar_append_item (GTK_TOOLBAR(toolbar),
										"Delete",
                              			"Delete Account",
                              			"Delete",
                              			iconwid,
                              			GTK_SIGNAL_FUNC(remove_callback),
                              			NULL);
	gtk_widget_set_sensitive(del_button, FALSE);
	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
   
	/* Modify Button */
	
	icon = gdk_pixmap_create_from_xpm_d(account_window->window, &mask, NULL, tb_edit_xpm);
	iconwid = gtk_pixmap_new(icon, mask);
	gtk_widget_show(iconwid);
	mod_button = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
											"Modify",
                              				"Modify Account",
                              				"Modify",
                              				 iconwid,
                              				 GTK_SIGNAL_FUNC(modify_callback),
                              				 NULL);
	gtk_widget_set_sensitive(mod_button, FALSE);
	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

	separator = gtk_vseparator_new();
	gtk_widget_set_usize(GTK_WIDGET(separator), 0, 20);
	gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar), separator, NULL, NULL);
	gtk_widget_show(separator);
	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
   
	/*Options Button*/
	
	icon = gdk_pixmap_create_from_xpm_d(account_window->window, &mask, NULL, tb_book_open_xpm);
	iconwid = gtk_pixmap_new(icon, mask);
	gtk_widget_show(iconwid);
	toolitem = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
   										"Options",
                              			"Show Options",
                              			"Options",
                              			iconwid,
                              			GTK_SIGNAL_FUNC(options_callback),
                              			NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

	separator = gtk_vseparator_new();
	gtk_widget_set_usize(GTK_WIDGET(separator), 0, 20);
	gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar), separator, NULL, NULL);
	gtk_widget_show(separator);
	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

	/*Okay Button*/
	
	icon = gdk_pixmap_create_from_xpm_d(account_window->window, &mask, NULL, ok_xpm);
	iconwid = gtk_pixmap_new(icon, mask);
	gtk_widget_show(iconwid);
	toolitem = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
   										"Ok",
                              			"Ok",
                              			"Ok",
                              			iconwid,
                              			GTK_SIGNAL_FUNC(ok_callback),
                              			NULL);
	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

	/*Cancel Button*/
	
	icon = gdk_pixmap_create_from_xpm_d(account_window->window, &mask, NULL, cancel_xpm);
	iconwid = gtk_pixmap_new(icon, mask);
	gtk_widget_show(iconwid);
	toolitem = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
										"Cancel",
                              			"Cancel",
                              			"Cancel",
                              			iconwid,
                              			GTK_SIGNAL_FUNC(cancel_callback),
                              			NULL);

	/*Buttons End*/
   
	button_box = gtk_hbox_new(FALSE, 0);
   
	gtk_box_pack_end(GTK_BOX(button_box), toolbar, FALSE, FALSE, 0);
	gtk_widget_show(toolbar);
   
	gtk_box_pack_start(GTK_BOX(window_box), button_box, FALSE, FALSE, 5);
	gtk_widget_show(button_box);
   
	gtk_widget_show(window_box);

	gtk_container_add(GTK_CONTAINER(account_window), window_box);
   
	gtk_window_set_title(GTK_WINDOW(account_window), "EveryBuddy Account Editor");

	gtk_signal_connect(GTK_OBJECT(account_window), "destroy",
					   GTK_SIGNAL_FUNC(destroy), NULL );
	gtk_widget_show(account_window);
}
