/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _PLUGIN_H
#define _PLUGIN_H

#include <ltdl.h>
#include "plugin_api.h"

#define EB_PLUGIN_LIST "PLUGIN::LIST"

extern char *PLUGIN_TYPE_TXT[];
extern char *PLUGIN_STATUS_TXT[];

typedef enum {
	PLUGIN_NOT_LOADED,
	PLUGIN_LOADED,
	PLUGIN_CANNOT_LOAD,
	PLUGIN_NO_STATUS
} PLUGIN_STATUS;

typedef struct {
	PLUGIN_INFO pi;			/* Information provided by the plugin */
	lt_dlhandle Module;		/* Reference to the shared object itself */
	char *path;			/* Full Path */
	char *name;			/* File Name */
	char *service;			/* Non NULL if this is a service plugin */
	PLUGIN_STATUS status;			/* Is the plugin loaded? */
	const char *status_desc;	/* Error dsecription */
} eb_PLUGIN_INFO;

typedef struct {
	void *data;
	eb_callback_action action;
	
} callback_data;

typedef struct {
	char *label;
	eb_menu_callback callback;
	/*FIXME: Should have some sort of conditional callback to see if menu item should be displayed */
	ebmCallbackData *data;
	void *user_data;
} menu_item_data;

typedef void (*menu_func)();
typedef struct {
	GList *menu_items;	/* A GList of menu_item_data elements */
	menu_func redraw_menu;	/* The function to call when the menu is changed */
	ebmType type;		/* What kind of data structure do we send back? */
} menu_data;

eb_PLUGIN_INFO *FindPluginByName(char *name);
eb_PLUGIN_INFO *FindPluginByService(char *service);

int unload_module(eb_PLUGIN_INFO *epi);
int load_module(char *path, char *name);
void load_modules();
int load_service_plugin(lt_dlhandle Module, PLUGIN_INFO *info, char *name);
int load_utility_plugin(lt_dlhandle Module, PLUGIN_INFO *info, char *name);
int load_log_plugin(lt_dlhandle Module, PLUGIN_INFO *info, char *name);
int load_sound_plugin(lt_dlhandle Module, PLUGIN_INFO *info, char *name);
int load_gui_plugin(lt_dlhandle Module, PLUGIN_INFO *info, char *name);

/* Make sure that all the plugin_api accessible menus, as defined in plugin_api.h, are initialized */
int init_menus();

#endif /* _PLUGIN_H */
