/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <gtk/gtk.h>
#include <gdk/gdkprivate.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <assert.h>
#include "service.h"
#include "globals.h"
#include "account.h"
#include "dialog.h"
#include "util.h"
#include "nomodule.h"

#ifdef HAVE_MIT_SAVER_EXTENSION
#include <X11/extensions/scrnsaver.h>
#endif /* HAVE_MIT_SAVER_EXTENSION */


static guint idle_timer;
static time_t lastsent = 0;
static int is_idle = 0;
static int scrnsaver_ext = 0;
int NUM_SERVICES=0;		/* Used in prefs.c */


/* Following chunk will be moved to a 'real' code file */
/* FIXME: Should be a dynamic array */
struct service eb_services[255];

/* Add a new service, or replace an existing one */
gint add_service(struct service *Service_Info)
{
	int i;
	GList *session_prefs=NULL;

	assert(Service_Info);	

	eb_debug(DBG_CORE, ">Entering\n");
	if(Service_Info->sc->read_prefs_config) {
		session_prefs=GetPref(Service_Info->name);
		Service_Info->sc->read_prefs_config(session_prefs);
	}

	for (i=0; i < NUM_SERVICES; i++ )
	{
		/* Check to see if another service exists for the same protocol, if so, replace it */
		if(!strcasecmp(eb_services[i].name,Service_Info->name))
		{
				eb_debug(DBG_CORE, "Replacing %s service\n", Service_Info->name);
				Service_Info->protocol_id=i;
				memcpy(&eb_services[i], Service_Info, sizeof(struct service));
				refresh_service_contacts(i);
				reload_service_accounts(i);
				return(i);
		}
		
	}
	Service_Info->protocol_id=NUM_SERVICES++;
	memcpy(&eb_services[Service_Info->protocol_id], Service_Info, sizeof(struct service));
	refresh_service_contacts(i);
	reload_service_accounts(Service_Info->protocol_id);
	eb_debug(DBG_CORE, "<Leaving\n");
	return(Service_Info->protocol_id);
}

/* This now creates a service if the name is not recognized */
gint get_service_id( gchar * servicename )
{
	int i;
	char buf[1024];

	for (i=0; i < NUM_SERVICES; i++ )
	{
		if(strcasecmp(eb_services[i].name,servicename)==0)
		{
			return i;	
		}
	}
	eb_debug(DBG_CORE, "Creating empty service for %s\n", servicename);
	memcpy(&eb_services[NUM_SERVICES], &nomodule_SERVICE_INFO, sizeof(struct service));
	eb_services[NUM_SERVICES].sc=eb_nomodule_query_callbacks();
	eb_services[NUM_SERVICES].name = strdup(servicename);
	eb_services[NUM_SERVICES].protocol_id=NUM_SERVICES;
	NUM_SERVICES++;
	sprintf(buf, "%s::path", servicename);
	cSetLocalPref(buf, "Empty Module");
	return(NUM_SERVICES-1);
}

gchar *get_service_name( gint service_id )
{
	if ((service_id >= 0) && (service_id < NUM_SERVICES))
	{
		return (eb_services[service_id].name);
	}

	fprintf(stderr, "warning: unknown service id: %d\n", service_id);
	return "unknown";
}

GList * get_service_list()
{
	GList * newlist = NULL;
	int i;
	for( i = 0; i < NUM_SERVICES; i++ )
	{
		newlist = g_list_append( newlist, eb_services[i].name );
	}
	return newlist;
}

void serv_touch_idle()
{
    /* Are we idle?  If so, not anymore */
    if (is_idle > 0) {
		GList * node;
        is_idle = 0;
		for(node = accounts; node; node = node->next )
		{
			if(((eb_local_account *)(node->data))->connected)
			{
				if(RUN_SERVICE(((eb_local_account*)(node->data)))->set_idle)
				{
					RUN_SERVICE(((eb_local_account*)node->data))->set_idle(
								 (eb_local_account*)node->data, 0);
				}
			}
		}
    }
    time(&lastsent);
}

static guint idle_time = 0;

static gint report_idle()
{
	GList * node;

	if (!is_idle)
		return FALSE;

	for(node = accounts; node; node = node->next )
	{
		if(((eb_local_account *)node->data)->connected)
		{
			if(RUN_SERVICE(((eb_local_account*)node->data))->set_idle)
			{
				RUN_SERVICE(((eb_local_account*)node->data))->set_idle(
						(eb_local_account*)node->data, idle_time);
			}
		}
	}
	return TRUE;
}

static gint check_idle()
{
	gint idle_reporter = -1;

#ifdef HAVE_MIT_SAVER_EXTENSION
	if (scrnsaver_ext) {
		static XScreenSaverInfo * mit_info = NULL;
		mit_info = XScreenSaverAllocInfo();
		XScreenSaverQueryInfo(gdk_display, DefaultRootWindow(gdk_display), mit_info);
		idle_time = mit_info->idle/1000;
		free(mit_info);
	} else
#endif
	{
    	time_t t;

    	if (is_idle)
        	return TRUE;
    	time(&t);
		
		idle_time = t - lastsent;
	}
	if ((idle_time >= 600) && do_send_idle_time) {
		if (is_idle == 0) {
			GList * node;
			idle_reporter = gtk_timeout_add(60000, (GtkFunction)report_idle, NULL);
			for(node = accounts; node; node = node->next )
			{
				if(((eb_local_account *)node->data)->connected)
				{
					if(RUN_SERVICE(((eb_local_account*)node->data))->set_idle)
					{
						RUN_SERVICE(((eb_local_account*)node->data))->set_idle(
								(eb_local_account*)node->data, idle_time);
					}
				}
			}
		}
		is_idle = 1;
	} else if ((idle_time < 600) && do_send_idle_time && (is_idle == 1)) {
		if (idle_reporter != -1)
			gtk_idle_remove(idle_reporter);
		serv_touch_idle();
	}
    return TRUE;

}

void add_idle_check()
{
	int eventnum, errornum;
	idle_timer = gtk_timeout_add(5000, (GtkFunction)check_idle, NULL);
	serv_touch_idle();
#ifdef HAVE_MIT_SAVER_EXTENSION
	if (XScreenSaverQueryExtension(gdk_display, &eventnum, &errornum)) {
		scrnsaver_ext = 1;
	}
#endif
}

//FIXME: Don't blow away an existing log
void rename_nick_log(char *oldnick, char *newnick)
{
   gchar oldnicklog[255], newnicklog[255];
   strcpy(oldnicklog, config_dir);
   strcat(oldnicklog, "logs/");
   strcpy(newnicklog, oldnicklog);
   strcat(oldnicklog, oldnick);
   strcat(newnicklog, newnick);
   rename(oldnicklog, newnicklog);
   printf("Renamed log from %s to %s\n", oldnicklog, newnicklog);
}

