#include <libebook/e-book.h>
#include <libedataserver/e-source-group.h>
#include <glib.h>
#include <locale.h>

void dump_as_vcard(EContact *contact, int dump_all)
{
	GList *attrs;
	int i;

	printf("BEGIN:VCARD\n");
	attrs = e_vcard_get_attributes(&contact->parent);
	for (i = 0; i < g_list_length(attrs); i++) {
		EVCardAttribute *attr = (EVCardAttribute *) 
			g_list_nth_data(attrs, i);
		int j;
		const char *attr_name = e_vcard_attribute_get_name(attr);

		if (!dump_all && 
		    strcmp(attr_name, "TEL") != 0 &&
		    strcmp(attr_name, "FN") != 0 &&
		    strcmp(attr_name, "BDAY") != 0 &&
		    strcmp(attr_name, "ORG") != 0 &&
		    strcmp(attr_name, "TEL") != 0 &&
		    strcmp(attr_name, "EMAIL") != 0 &&
		    strcmp(attr_name, "NOTE") != 0 &&
		    strcmp(attr_name, "NICKNAME") != 0
			) {
			continue;
		}

		if (e_vcard_attribute_is_single_valued(attr)) {
			char *av = e_vcard_attribute_get_value(attr);
			printf("%s: %s\n", 
			       attr_name,
			       av);
		} else {
			GList *vals = e_vcard_attribute_get_values(attr);

			for (j = 0; j < g_list_length(vals); j++) {
				const char *av = *(char**) g_list_nth(vals, j);

				printf("%s: %s\n", attr_name, av);
			}
		}
	}
	printf("END:VCARD\n");
}

static gchar **search_filter = NULL;

static GOptionEntry entries[] = 
{
	{ G_OPTION_REMAINING, 0, G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_STRING_ARRAY, &search_filter, NULL, NULL},
	{ NULL }
};

int main(int argc, char **argv)
{
	EBook *book;
	ESourceList *source_list;
	ESourceGroup *group;
	ESource *source;
	GSList *groups;
	EBookQuery *query;
	GList *contacts;
	GSList *sources;
	GSList *g, *s;
	GList *c;
	GError *error = NULL;
	GOptionContext *optioncontext;

	setlocale (LC_ALL, "");

	optioncontext = g_option_context_new ("- whack address book");
	g_option_context_add_main_entries (optioncontext, entries, NULL);
	g_option_context_parse (optioncontext, &argc, &argv, &error);

	if (error != NULL) {
		fprintf(stderr, "%s\n", error->message);
		return 1;
	}

	e_book_get_addressbooks(&source_list, &error);

	if (error != NULL) {
		fprintf(stderr, "%s\n", error->message);
		return 1;
	}

	if (search_filter != NULL) {
		query = e_book_query_any_field_contains(*search_filter);
	} else {
		query = e_book_query_field_exists(E_CONTACT_FULL_NAME);
	}

	groups = e_source_list_peek_groups(source_list);
	for (g = groups; g; g = g->next) {

		group = E_SOURCE_GROUP (g->data);
		sources = e_source_group_peek_sources(group);

		for (s = sources ; s; s = s->next) {
			source = E_SOURCE(s->data);
			book = e_book_new(source, &error);

			if (error != NULL) {
			  fprintf(stderr, "%s\n", error->message);
			  return 1;
			}

			e_book_open(book, TRUE, &error);


			if (error != NULL) {
			  fprintf(stderr, "%s\n", error->message);
			  return 1;
			}

			e_book_get_contacts(book, query, &contacts, &error);
			if (error != NULL) {
			  fprintf(stderr, "%s\n", error->message);
			  return 1;
			}

			for (c = contacts; c; c = c->next) {
				dump_as_vcard(E_CONTACT(c->data), 1);
			}
		}
	}
	e_book_query_unref (query);
}
