#include <stdio.h>
#include <stdlib.h>

typedef unsigned int __u32;

int ext2_sparse_groups(__u32 *three, __u32 *five, __u32 *seven)
{
	__u32 *min = three;
	__u32 mult = 3;
	__u32 ret;

	if (*five < *min) {
		min = five;
		mult = 5;
	}
	if (*seven < *min) {
		min = seven;
		mult = 7;
	}

	ret = *min;
	*min *= mult;

	return ret;
}

int main(int argc, char *argv[])
{
	__u32 three = 1, five = 5, seven = 7;
	__u32 max, ret;

	if (argc < 2) {
		fprintf(stderr, "usage: %s max_groups\n", argv[0]);
		return 1;
	}

	max = strtoul(argv[1], NULL, 0);

	printf("0\n");
	while ((ret = ext2_sparse_groups(&three, &five, &seven)) < max)
		printf("%u\n", ret);

	return 0;
}
