
/*
 * lib_mdidentd.h
 *
 * Header for mdidentd library. With only one function, what a library
 * it is.
 *
 * Written by Murat Deligonul, October 1998
 *
 *
 * This file is public domain.
 * 
 * THIS FILE COMES WITH ABSOLUTELY NO WARRANTY, EITHER
 * EXPRESSED OR IMPLIED. 
 */
 
#ifndef __lib__mdidentd_h
#define __lib__mdidentd_h

#ifdef __cplusplus
extern "C" {
#endif

/* Constants used by the library */

#define IDENT_OK 1                  /* Success */
#define IDENT_AUTH_FAILURE (-1)     /* Authorization failure */
#define IDENT_ERROR_EXISTS    (-2)  /* Trying to add dup to ident list */
#define IDENT_CONNECT_FAILURE (-3)  /* Was unable to connect to the domain socket. Check errno. */
#define IDENT_ERROR_INVAL (-4)      /* Invalid fake ident request given */
#define IDENT_ERROR 0               /* Unknown error */

#define MAX_IDENT_LENGTH    50      /* 50 ought to be enough? */


/*
 * This is where mdidentd's domain socket resides ..
 */
#define MDIDENTD_SOCK_PATH "/var/run/mdidentd"
#define MDIDENTD_PATH MDIDENTD_SOCK_PATH

/*
 * Set a fake ident. Arguments are:
 *  path of socket:         use MDIDENTD_SOCK_PATH
 *  name of fake ident:     ditto
 *  u_short 1:              local port
 *  u_short 2:              remort port
 */ 
int register_fake_ident(char const *, char const *, unsigned short, unsigned short);


/*
 * Returns a string version of an error given by the above
 * function. 
 *
 * int argument:        the error
 */
char const * const ident_error(int);


#ifdef __cplusplus
}
#endif

#endif
