// server.h

#ifndef __server_h
#define __server_h

#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <time.h>

/* #define ENABLE_DEBUG_LOGGING */

extern int start_proxy(void);
extern int stop_proxy(void);
    
extern int ircproxy_listen(unsigned short, const struct in_addr * = NULL);
extern int ircproxy_die(bool now, const char *);
extern int ircproxy_startlog(const char *);
extern int ircproxy_closelog(void);

extern void ircproxy_rehash(void);
extern void ircproxy_redir_stdxxx(void);

/* The logging system */
extern int printlog(const char *format, ...);
#if defined(__DEBUG__) || defined(ENABLE_DEBUG_LOGGING)
#   define DEBUG(format, args...) printlog ("DEBUG: " ## format, ## args)
#else
#   define DEBUG(format, args...)
#endif

/* 
 * Somewhere to hold the current time while we process the conn
 * objects requests so that they don't call time(2) a billion
 * more times.
 */

inline time_t ircproxy_time(void)
{
    extern time_t time_ctr;
    return time_ctr;
}


inline time_t update_time_ctr(void)
{
    extern time_t time_ctr;
    return (time_ctr = ::time(NULL));
}
#endif
