/*
 * $Id: conn_isa.c,v 1.12 2009-06-03 11:34:05 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "conn_isa.h"

struct cpssp {
	struct sig_boolean_merge *forward_p5V;
	struct sig_boolean_merge *forward_m5V;
	struct sig_boolean_merge *forward_p12V;
	struct sig_boolean_merge *forward_m12V;
	struct sig_boolean_merge *forward_n_reset;
	struct sig_isa_bus_main_merge *forward_main;
	struct sig_isa_bus_dma_merge *forward_dma0;
	struct sig_isa_bus_dma_merge *forward_dma1;
	struct sig_isa_bus_dma_merge *forward_dma2;
	struct sig_isa_bus_dma_merge *forward_dma3;
	struct sig_isa_bus_dma_merge *forward_dma5;
	struct sig_isa_bus_dma_merge *forward_dma6;
	struct sig_isa_bus_dma_merge *forward_dma7;
	struct sig_boolean_or_merge *forward_int3;
	struct sig_boolean_or_merge *forward_int4;
	struct sig_boolean_or_merge *forward_int5;
	struct sig_boolean_or_merge *forward_int6;
	struct sig_boolean_or_merge *forward_int7;
	struct sig_boolean_or_merge *forward_int9;
	struct sig_boolean_or_merge *forward_int10;
	struct sig_boolean_or_merge *forward_int11;
	struct sig_boolean_or_merge *forward_int12;
	struct sig_boolean_or_merge *forward_int14;
	struct sig_boolean_or_merge *forward_int15;
};

void *
conn_isa_create(
	const char *name,
	struct sig_manage *port_manage,

	struct sig_isa_bus *port_isa,

	struct sig_boolean *port_p5V,
	struct sig_boolean *port_m5V,
	struct sig_boolean *port_p12V,
	struct sig_boolean *port_m12V,
	struct sig_boolean *port_n_reset,
	struct sig_isa_bus_main *port_main,
	struct sig_isa_bus_dma *port_dma0,
	struct sig_isa_bus_dma *port_dma1,
	struct sig_isa_bus_dma *port_dma2,
	struct sig_isa_bus_dma *port_dma3,
	struct sig_isa_bus_dma *port_dma5,
	struct sig_isa_bus_dma *port_dma6,
	struct sig_isa_bus_dma *port_dma7,
	struct sig_boolean_or *port_int3,
	struct sig_boolean_or *port_int4,
	struct sig_boolean_or *port_int5,
	struct sig_boolean_or *port_int6,
	struct sig_boolean_or *port_int7,
	struct sig_boolean_or *port_int9,
	struct sig_boolean_or *port_int10,
	struct sig_boolean_or *port_int11,
	struct sig_boolean_or *port_int12,
	struct sig_boolean_or *port_int14,
	struct sig_boolean_or *port_int15
)
{
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->forward_p5V = sig_boolean_merge(
			port_p5V, port_isa->p5V);
	cpssp->forward_m5V = sig_boolean_merge(
			port_m5V, port_isa->m5V);
	cpssp->forward_p12V = sig_boolean_merge(
			port_p12V, port_isa->p12V);
	cpssp->forward_m12V = sig_boolean_merge(
			port_m12V, port_isa->m12V);
	cpssp->forward_n_reset = sig_boolean_merge(
			port_n_reset, port_isa->n_reset);
	cpssp->forward_main = sig_isa_bus_main_merge(
			port_isa->main, port_main);
	cpssp->forward_dma0 = sig_isa_bus_dma_merge(
			port_isa->dma0, port_dma0);
	cpssp->forward_dma1 = sig_isa_bus_dma_merge(
			port_isa->dma1, port_dma1);
	cpssp->forward_dma2 = sig_isa_bus_dma_merge(
			port_isa->dma2, port_dma2);
	cpssp->forward_dma3 = sig_isa_bus_dma_merge(
			port_isa->dma3, port_dma3);
	cpssp->forward_dma5 = sig_isa_bus_dma_merge(
			port_isa->dma5, port_dma5);
	cpssp->forward_dma6 = sig_isa_bus_dma_merge(
			port_isa->dma6, port_dma6);
	cpssp->forward_dma7 = sig_isa_bus_dma_merge(
			port_isa->dma7, port_dma7);
	cpssp->forward_int3 = sig_boolean_or_merge(
			port_isa->int3, port_int3);
	cpssp->forward_int4 = sig_boolean_or_merge(
			port_isa->int4, port_int4);
	cpssp->forward_int5 = sig_boolean_or_merge(
			port_isa->int5, port_int5);
	cpssp->forward_int6 = sig_boolean_or_merge(
			port_isa->int6, port_int6);
	cpssp->forward_int7 = sig_boolean_or_merge(
			port_isa->int7, port_int7);
	cpssp->forward_int9 = sig_boolean_or_merge(
			port_isa->int9, port_int9);
	cpssp->forward_int10 = sig_boolean_or_merge(
			port_isa->int10, port_int10);
	cpssp->forward_int11 = sig_boolean_or_merge(
			port_isa->int11, port_int11);
	cpssp->forward_int12 = sig_boolean_or_merge(
			port_isa->int12, port_int12);
	cpssp->forward_int14 = sig_boolean_or_merge(
			port_isa->int14, port_int14);
	cpssp->forward_int15 = sig_boolean_or_merge(
			port_isa->int15, port_int15);

	return cpssp;
}

void
conn_isa_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
