/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE

#ifdef INP_0
#define IN_N 1
#endif

#ifdef INP_1
#undef IN_N
#define IN_N 2
#endif

#include "zuse_generic.c"

unsigned int NAME_(state0);

#endif /*STATE*/

#ifdef BEHAVIOUR

/* beautiful helper macros to create the function names*/
#define PASTER(x,y,z)       x ## _ ## y ## _ ## z
#define EVALUATOR(x,y,z)    PASTER(x,y,z)

/* macros to concat function names */
#ifdef INP_0
#define NAME_IN_PORT_0_(z)  EVALUATOR(NAME, INP_0, z)
#endif

#ifdef INP_1
#define NAME_IN_PORT_1_(z)  EVALUATOR(NAME, INP_1, z)
#endif

#ifdef OUTP_0
#define NAME_OUT_PORT_0_(z) EVALUATOR(NAME, OUTP_0, z)
#endif

/* Debug makros */
#if DEBUG

#ifndef STR
#define STR(x)   #x
#endif /* STR */

#ifndef SHOW_DEFINE
#define SHOW_DEFINE(x) fprintf(stderr, "%s", STR(x))
#endif /* SHOW_DEFINE */

#endif /* DEBUG */

static void
NAME_(destroy)(struct cpssp *cpssp)
{
    return;
}

static void
NAME_(reset) (void *_cpssp) {
    /* reset output to 0 */
    struct cpssp *cpssp = _cpssp;
#if DEBUG
    SHOW_DEFINE(NAME);
    fprintf(stderr, " resets to 0\n");
#endif /* DEBUG */
    NAME_OUT_PORT_0_(out_set)(cpssp, SIG_STD_LOGIC_0);
}

static void
NAME_(solve)(struct cpssp *cpssp) {

    /* if input is 0 and sets to 1 a short 1 is read at the output */

    unsigned int res0 = 2000 < SIG_mV(cpssp->NAME.states[0]);
    unsigned int res1 = 2000 < SIG_mV(cpssp->NAME.states[0]);
    unsigned int res = 0;
    if(cpssp->NAME_(state0) != res0) {
	if(cpssp->NAME_(state0)) {
	    /* actually do something */
	    res = 1;
	}
	cpssp->NAME_(state0) = res0;
    }

    if(res && res1) {
#if DEBUG
	SHOW_DEFINE(NAME);
	fprintf(stderr, " sets to 1 for a short time\n");
#endif /* DEBUG */
	NAME_OUT_PORT_0_(out_set)(cpssp, SIG_STD_LOGIC_1);
	res = 0;
	time_call_after(TIME_HZ / 4, NAME_(reset), cpssp);
    } else {
#if DEBUG
	SHOW_DEFINE(NAME);
	fprintf(stderr, " stays 0\n");
#endif /* DEBUG */

	NAME_OUT_PORT_0_(out_set)(cpssp, SIG_STD_LOGIC_0);
    }
}

#include "zuse_generic.c"

static void
NAME_(create)(struct cpssp *cpssp)
{
#ifdef INP_0
    NAME_IN_PORT_0_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_1
    NAME_IN_PORT_1_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
}

#ifdef INP_0
#undef NAME_IN_PORT_0_
#undef INP_0
#endif

#ifdef INP_1
#undef NAME_IN_PORT_1_
#undef INP_1
#endif

#ifdef OUTP_0
#undef OUTP_0
#undef NAME_OUT_PORT_0_
#endif

#endif /*BEHAVIOUR*/
