/*
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __EL_TORITO_H_INCLUDED
#define __EL_TORITO_H_INCLUDED

#include "compiler.h"

/* Boot Record Volume Descriptor */
struct boot_record_volume {
	uint8_t indicator;
	uint8_t identifier[5];
	uint8_t version;
	uint8_t bootsys_identifier[32];
	uint8_t reserved0[32];
	uint32_t bootcat_p;
	uint8_t reserved1[1973];
} PACKED;

#define BRV_SECTOR	0x11

/* Boot Catalog entries */
/* Validation Entry */
struct validation {
	uint8_t header_id;
	uint8_t platform_id;
	uint16_t reserved0;
	uint8_t identifier[24];
	uint16_t chk_sum;
	uint16_t key;
} PACKED;

/* Initial/Default Entry */
struct initial {
	uint8_t boot_indicator;
	uint8_t boot_media;
	uint16_t load_segment;
	uint8_t system_type;
	uint8_t reserved0;
	uint16_t sector_count;
	uint32_t load_rba;	/* rba: relative block addressing */
	uint8_t reserved1[20];
} PACKED;

/* Section Header Entry */
struct section_header {
	uint8_t header_id;
	uint8_t platform_id;
	uint16_t sections;
	uint8_t identifier[28];
} PACKED;

/* Section Entry */
struct section_entry {
	uint8_t boot_indicator;
	uint8_t boot_media;
	uint16_t load_segment;
	uint8_t system_type;
	uint8_t reserved0;
	uint16_t sector_count;
	uint32_t load_rba;
	uint8_t selection_criteria;
	uint8_t vendor_sel_crit[18];
} PACKED;

struct section_entry_extension {
	uint8_t extension_indicator;
	uint8_t final_ext_flag;
	uint8_t vendor_sel_crit[30];
} PACKED;

#endif /* __EL_TORITO_H_INCLUDED */
