'\" t
.\"	fhist - file history and comparison tools
.\"	Copyright (C) 1993-1995, 1998, 2001, 2002 Peter Miller;
.\"	All rights reserved.
.\"
.\"	This program is free software; you can redistribute it and/or modify
.\"	it under the terms of the GNU General Public License as published by
.\"	the Free Software Foundation; either version 2 of the License, or
.\"	(at your option) any later version.
.\"
.\"	This program is distributed in the hope that it will be useful,
.\"	but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"	GNU General Public License for more details.
.\"
.\"	You should have received a copy of the GNU General Public License
.\"	along with this program; if not, write to the Free Software
.\"	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
.\"
.\" MANIFEST: source for the BUILDING file
.\"
.if n .ftr CW R
.if n .ftr C R
.if n .ftr CB B
.if n .ftr CI I
.TH Building FHist FHist "Reference Manual"
.so version.so
.if n .ad l
.if n .hy 0
.SH NAME
fhist \- file history and comparison tools
.XX "" "How to Build the Sources"
.br
.if t .ds C) \(co
.if n .ds C) (C)
Copyright \*(C)
.nr d) \n(.d
\*(Y) Peter Miller;
.if '\n(d)'\n(.d' .br
All rights reserved.
.PP
Portions of this program are
.br
Copyright \*(C) 1990 David I. Bell.
.PP
The
.I fhist
package is distrributed under the terms of the
GNU General Public License,
see the
.I LICENSE
section,
below,
for more information.
.br
.ne 2i
.SH SPACE REQUIREMENTS
You will need about 600K to unpack and build the
.I fhist
package.
(This is the worst case seen so far,
most systems have binaries about 60% as big as this,
400K is more typical.)
Your mileage may vary.
.br
.ne 1i
.SH BEFORE YOU START
There are a few pieces of software you may want to
fetch and install before you proceed with your installation of cook.
.TP 8n
GNU Gettext
The
.I fhist
package has been internationalized.
It can now print error messages in any of the supported languages.
In order to do this, the GNU Gettext package must be installed
.I before
you run the configure script as detailed in the next section.
This is because the configure script looks for it.
On systems which use the GNU C library, version 2.0 or later,
there is no need to explictly do this as GNU Gettext is included.
Remember to use the GNU Gettext configure \fI--with-gnu-gettext\fP option
if your system has native gettext tools.
.TP 8n
GNU Groff
The documentation for the
.I fhist
package was prepared using the GNU Groff package.
This distribution includes full documentation,
which may be processed into PostScript or DVI files
at install time \- if GNU Groff has been installed.
.TP 8n
GNU Groff patch
There is a patch for GNU Groff available,
which gives
.IR groff (1)
and
.IR gsoelim (1)
a \fB\-B\fP\fIpath\fP option.
This adds an include file search path, similar to
.IR cpp (1).
The Makefile assumes this is available.
The patch is at
\f(CWhttp://www.canb.auug.org.au/~millerp/groff-1.11a.patch\fP
or its mirrors.
.TP 8n
Bison
If your operating system does not have a native
.IR yacc (1)
you will need to fetch and install GNU Bison
in order to build the
.I fhist
package.
.TP 8n
An ANSI C compiler.
You must have an ANSI C compiler to compile this program.
You may also want to consider fetching and installing the GNU C Compiler
if you have not done so already.
.PP
The GNU FTP archives may be found at \f(CWprep.ai.mit.edu\fP,
and are mirrored around the world.
.br
.ne 1i
.SH SITE CONFIGURATION
The
.B fhist
package is configured using the
.I configure
shell script included in this distribution.
.PP
The
.I configure
shell script attempts to guess correct values for
various system-dependent variables used during compilation,
and creates the
.I Makefile
and
.I common/config.h
files.
It also creates a shell script
.I config.status
that you can run in the future to recreate the current configuration.
.PP
Normally,
you just
.I cd
to the directory containing 
.IR fhist "'s"
source code and type
.RS
.ft CW
.nf
% \f(CB./configure\fP
\fI\&...lots of output...\fP
%
.fi
.ft R
.RE
If you're using
.I csh
on an old version of System V,
you might need to type
.RS
.ft CW
.nf
% \f(CBsh configure\fP
\fI\&...lots of output...\fP
%
.fi
.ft R
.RE
instead to prevent
.I csh
from trying to execute
.I configure
itself.
.PP
Running
.I configure
takes a minute or two.
While it is running,
it prints some messages that tell what it is doing.
If you don't want to see the messages,
run
.I configure
with its standard output redirected to
.IR /dev/null ;
for example,
.RS
.FT CW
.nf
% \f(CW./configure > /dev/null\fP
%
.fi
.ft R
.RE
.PP
By default,
.I configure
will arrange for the
.I "make install"
command to install the
.B fhist
package's files in
.IR /usr/local/bin
and
.IR /usr/local/man .
You can specify an installation prefix other than
.I /usr/local
by giving
.I configure
the option \f(CW--prefix=\fP\fIPATH\fP.
.PP
You can specify separate installation prefixes for
architecture-specific files and architecture-independent files.
If you give
.I configure
the option \f(CW--exec-prefix=\fP\fIPATH\fP
the
.B fhist
package will use
.I PATH
as the prefix for installing programs and libraries.
Data files and documentation will still use the regular prefix.
Normally,
all files are installed using the same prefix.
.PP
.I configure
ignores any other arguments that you give it.
.PP
On systems that require unusual options for compilation or linking
that the
.I fhist
package's
.I configure
script does not know about,
you can give
.I configure
initial values for variables by setting them in the environment.
In Bourne-compatible shells,
you can do that on the command line like this:
.RS
.ft CW
.nf
$ \f(CBCC='gcc -traditional' LIBS=-lposix ./configure\fP
\fI\&...lots of output...\fP
$
.fi
.ft R
.RE
Here are the
.I make
variables that you might want to override with
environment variables when running
.IR configure .
.TP 8n
Variable: CC
C compiler program.
The default is
.IR cc .
.TP 8n
Variable: INSTALL
Program to use to install files.
The default is
.I install
if you have it,
.I cp
otherwise.
.TP 8n
Variable: LIBS
Libraries to link with,
in the form \f(CW-l\fP\fIfoo\fP \f(CW-l\fP\fIbar\fP.
The
.I configure
script will append to this,
rather than replace it.
.PP
If you need to do unusual things to compile the package,
the author encourages you to figure out how
.I configure
could check whether to do them,
and mail diffs or instructions to the author
so that they can be included in the next release.
.br
.ne 2i
.SH BUILDING FHIST
All you should need to do is use the
.RS
.ft CW
.nf
% \f(CBmake\fP
\fI\&...lots of output...\fP
%
.fi
.ft R
.RE
command and wait.
When this finishes you should see a directory called
.I bin
containing four files:
.IR fcomp ,
.IR fhist ,
.I fmerge
and
.IR txt2c .
.TP 8n
.B fcomp
The
.I fcomp
program is user to
compare two text files.
.TP 8n
.B fhist
The
.I fhist
program is used to
maintain and edit history of a text file.
.TP 8n
.B fmerge
The
.I fmerge
program is used to
merge together edits from two descendants of a file.
.TP 8n
.B txt2c
The
.I txt2c
program is a utility used to build the
.I fhist
package;
it is not intended for general use and should not be installed.
.PP
You can remove the program binaries and object files from the
source directory by using the
.RS
.ft CW
.nf
% \f(CBmake clean\fP
\fI\&...lots of output...\fP
%
.fi
.ft R
.RE
command.
To remove all of the above files, and also remove the
.I Makefile
and
.I common/config.h
and
.I config.status
files, use the
.RS
.ft CW
.nf
% \f(CBmake distclean\fP
\fI\&...lots of output...\fP
%
.fi
.ft R
.RE
command.
.PP
The file
.I etc/configure.in
is used to create
.I configure
by a GNU program called
.IR autoconf .
You only need to know this if you want to regenerate
.I configure
using a newer version of
.IR autoconf .
.br
.ne 2i
.SH TESTING FHIST
The
.I fhist
package is accompanied by a test suite.
To run this test suite,
use the following command:
.RS
.nf
% \fBmake sure\fP
\fI\&...lots of output...\fP
%
.fi
.RE
.PP
This is successful if the last line of the test output
reads "Passed All Tests".
.PP
Please let the author know if any of the tests fail,
and why if you can work that out.
.br
.ne 2i
.SH INSTALLING FHIST
As explained in the
.I "SITE CONFIGURATION"
section, above,
the
.I fhist
package is installed under the
.I /usr/local
tree by default.
Use the \f(CW--prefix=\fP\fIPATH\fP option to
.I configure
if you want some other path.
.PP
All that is required to install the
.I fhist
package is to use the
.RS
.ft CW
.nf
% \f(CBmake install\fP
\fI\&...lots of output...\fP
%
.fi
.ft R
.RE
command.
Control of the directories used may be found in the first
few lines of the
.I Makefile
file if you want to bypass the
.I configure
script.
.PP
The above procedure assumes that the
.IR soelim (1)
command is somewhere in the command search
.IR PATH .
The
.IR soelim (1)
command is available as part of the
.I "GNU Roff"
package,
mentioned previously in the
.I "PRINTED MANUALS"
section.
If you don't have it,
but you do have the
.I cook
package,
then a link from
.I roffpp
to
.I soelim
will also work.
.PP
The above procedure also assumes that the
.I $(prefix)/man/man1
and
.I $(prefix)/man/man5
directories already exist.
If they do not,
you will need to
.I mkdir
them manually.
.br
.ne 1i
.SH PRINTED MANUALS
The easiest way to get copies of the manuals
is to get the
.I fhist.\*(v).pdf
file from the archive site.
This is an Adobe AcroRead file containing the Reference Manual,
which contains the README file,
the BUILDING file
and internationalization notes,
as well as all of the manual pages for all of the commands.
.PP
This distribution contains the sources to
all of the documentation for
.IR fhist .
The author used the GNU groff package
and a postscript printer to prepare the documentation.
If you do not have this software,
you will need to substitute commands appropriate to your site.
.PP
If you have the GNU Groff package installed
.I before
you run the
.I configure
script, the
.I Makefile
will contain instructions for constructing the documentation.
If you already used the
.I make
command, above, this has already been done.
The following command
.RS
.ft CW
.nf
\fB% \fPmake doc
\fI\&...lots of output...\fP
\fB%\fP
.fi
.ft R
.RE
can be used to do this explicitly, if you managed to get to this point
without doing it.  Please note that there may be some warnings from groff,
particularly about missing fonts,
particularly for the \f(CW.txt\fP files; this is normal.
.PP
Once the documents have been formatted, you only need to print them.
The following command
.RS
.ft CW
.nf
\fB% \fPlpr lib/en/reference.ps
\fB%\fP
.fi
.ft R
.RE
will print the English PostScript version of the Reference Manual.
Watch the
.I make
output to see what other versions are available.
.so ../man1/z_cr.so
