/* dir.c */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* for directory functions */
/*
 * $Log: dir.c,v $
 * Revision 1.3  2001/01/31 15:38:06  movement
 * pre11 - fix netscape, add metapost support, credit foggy
 *
 * Revision 1.3  2001/01/29 20:57:28  moz
 * Make netscape work again, metapost support.
 *
 * Revision 1.2  2000/12/06 20:56:01  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:30  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:30  moz
 * CVS Import
 *
 * Revision 1.9  2000/03/09 23:18:06  moz
 * Create "false" ../ entry for unreadable dirs.
 *
 * Revision 1.8  2000/02/17 22:16:27  moz
 * Compiler fixes.
 *
 * Revision 1.7  1999/11/15 02:08:04  moz
 * Name change.
 *
 * Revision 1.6  1999/05/19 17:06:22  moz
 * 1.0 Checkin.
 *
 * Revision 1.5  1999/05/03 06:20:33  moz
 * Show fig only for all relevant dialogs.
 *
 * Revision 1.4  1999/04/23 01:04:59  moz
 * FIG files only.
 *
 * Revision 1.3  1999/04/12 19:05:28  moz
 * New function to strip off directory.
 *
 * Revision 1.2  1999/04/04 03:13:41  moz
 * Core-dump fix on overflowing string.
 *
 * Revision 1.1  1999/04/04 03:11:23  moz
 * Initial revision
 *
 */    

#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h> 
#include <string.h> 
#include "include/figurine.h"
#include "include/extern.h"

/* returns filename part  */  
/* e.g. /home/moz/man becomes */
/* man */
char *
strip_dirname(char *fname)
{
	char *a=fname+strlen(fname);

	while (a>=fname && *a!='/')
		a--;
	
	return a+1; 
}

/* replace a file name with chosen extension  */  
void
add_export_extension(int type)
{
	char newext[10];
	char s[FIGURINE_PATH_MAX]; 
	char *cp; 

	switch (type)
		{
		case EXPORT_LATEX_BOX:
			strcpy(newext,".box");
			break;
			
		case EXPORT_LATEX_PICTURE:
			strcpy(newext,".latex");
			break;

		case EXPORT_EPIC:
			strcpy(newext,".epic");
			break;

		case EXPORT_EEPIC:
			strcpy(newext,".eepic");
			break;

		case EXPORT_EEPICEMU:
			strcpy(newext,".eepicemu");
			break;

		case EXPORT_PICTEX:
			strcpy(newext,".pictex");
			break;
			
		case EXPORT_IBMGL:
			strcpy(newext,".hgl");
			break;

		case EXPORT_EPS:
			strcpy(newext,".eps");
			break;
			 
		case EXPORT_PS:
			strcpy(newext,".ps");
			break;
			 
		case EXPORT_PSLATEX:
			strcpy(newext,".pstex");
			break;
			 
		case EXPORT_TEXTYL:
			strcpy(newext,".textyl");
			break;
			 
		case EXPORT_TPIC:
			strcpy(newext,".tpic");
			break;
			 
		case EXPORT_PIC:
			strcpy(newext,".pic");
			break;
			 
		case EXPORT_METAFONT:
			strcpy(newext,".mf");
			break;
			 
		case EXPORT_METAPOST:
			strcpy(newext,".mp");
			break;

		case EXPORT_MULTIMETAPOST:
			strcpy(newext,".mmp");
			break;

		case EXPORT_AUTOCAD:
			strcpy(newext,".sld");
			break;
			 
		case EXPORT_PCX:
			strcpy(newext,".pcx");
			break;
			 
		case EXPORT_PNG:
			strcpy(newext,".png");
			break;
			 
		case EXPORT_GIF:
			strcpy(newext,".gif");
			break;
			 
		case EXPORT_JPEG:
			strcpy(newext,".jpg");
			break;
			 
		case EXPORT_TIFF:
			strcpy(newext,".tif");
			break;
			 
		case EXPORT_PPM:
			strcpy(newext,".ppm");
			break;
			 
		case EXPORT_XBM:
			strcpy(newext,".xbm");
			break;
			 
		case EXPORT_XPM:
			strcpy(newext,".xpm");
			break;
			 
		default:
			strcpy(newext,".tex");
		};
	
	stk_get_text_entry(exportfile_entry,s);
	
	cp = s+strlen(s);

	while (cp>s && *cp!='/' && *cp!='.')
		cp--;
	
	if (*cp=='.')
		{
		*cp = '\0';
		strcat(s,newext);
		}; 
	
	if (*cp=='/' && cp!=(s+strlen(s)-1))
		strcat(s,newext); 
		
	stk_set_text_entry(exportfile_entry,s);
	 
}

/* strip last directory from a path name  */  
void 
strip_end_dir(char *path)
{
	char *a=&path[strlen(path)];

	if (path==NULL)
		return;
	
	if (strlen(path)>1 && *(a-1)=='/')
		{
		a--;
		*a='\0';
		}; 

	if (streq("/",path))
		return;

	if (is_directory(path))
		{
		while (a!=path && *a!='/')
			a--;
		};
	
	if (a==path)
		{
		*path='/';
		*(path+1)='\0';
		}
	else
		*(a+1)='\0';
	
}

Boolean 
is_directory(char *dir)
{
	struct stat st;

	if (streq(dir,""))
		return FALSE;

	if (!stat(dir,&st))
		return (st.st_mode & S_IFDIR);
	else
		return FALSE;
}

int 
stringcomp(char **a, char **b)
{
	return (strcmp(*a,*b));
}
 
/* fill in a dialog with the cwd contents  */   
/* Window l is dirs  */  
/* Window r is files  */  
/* if figonly, mask is *.fig  */  
void 
fill_in_file(Window l, Window r, Boolean figonly)
{
	DIR *dir;
	char *files[500]; /* MAX no. of files displayed */  
	char *dirs[500]; /* MAX no. of dirs displayed  */  
	char cd[FIGURINE_PATH_MAX]; 
	uint fn = 0;
	uint dn = 0;
	uint i; 
	struct dirent *entry;
	struct stat st;

	stk_clear_textlist(l);
	stk_clear_textlist(r);

	strncpy(cd,state.cwd,FIGURINE_PATH_MAX);
	dir = opendir(cd);

	/* if not accessible, just add parent ../ */
	if (dir==NULL)
		{
		stk_add_textlist_member(l, "../");
		return;
		}; 

	while ((entry=readdir(dir))!=NULL)
		{
	if (!stat(entry->d_name,&st))
		{ 
		if (is_directory(entry->d_name))
			{
			if (dn<500 && !streq(entry->d_name,"."))
				{
				dirs[dn] = (char *)malloc(strlen(entry->d_name)+1+1);
				strcpy(dirs[dn], entry->d_name);
				strcat(dirs[dn], "/"); 
				dn++;
				};
			}
		else
			{
			if (fn<500)
				{
					if (!figonly || (strlen(entry->d_name)>3 &&  
						 streq(&entry->d_name[strlen(entry->d_name)-4],".fig"))) 
						{ 
						files[fn] = (char *)malloc(strlen(entry->d_name)+1);
						strcpy(files[fn], entry->d_name);
						fn++;
						};  
				};
			};
		};
	}; 
	
	/* sort them */  
	qsort(&files, fn, sizeof(char *),  (int (*)(const void *, const void *))stringcomp);
	qsort(&dirs, dn, sizeof(char *),  (int (*)(const void *, const void *))stringcomp);
	 
	for (i=0; i<fn; i++)
	stk_add_textlist_member(r, files[i]);
	
	for (i=0; i<dn; i++)
	stk_add_textlist_member(l, dirs[i]);
	 
	for (i=0; i<fn; i++)
		free(files[i]);

	for (i=0; i<dn; i++)
		free(dirs[i]);

}
