/* ellipse.c  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* contains functions assoc. with ellipse and circle composition */
/*
 * $Log: ellipse.c,v $
 * Revision 1.2  2000/12/06 20:56:01  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:30  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:30  moz
 * CVS Import
 *
 * Revision 1.5  2000/03/08 00:43:42  moz
 * Compile fixes.
 *
 * Revision 1.4  1999/11/15 02:11:10  moz
 * Name change.
 *
 * Revision 1.3  1999/05/19 17:10:54  moz
 * 1.0 Checkin.
 *
 * Revision 1.2  1999/04/29 00:13:11  moz
 * In draw_ellipse, make sure it is this object we are scaling (test gc==blackxorgc).
 *
 * Revision 1.1  1999/03/30 00:04:48  moz
 * Initial revision
 *
 */    

/* see mouse_button.c for general behaviour */  
 
#include "include/figurine.h"  
#include "include/extern.h"
 
static long x1=0; /* for boxellipse  */ 
static long y1=0;
static long cx=0;
static long cy=0;
static long xr=0;
static long yr=0;

static Boolean held=FALSE;

void 
commit_ellipse(View *view, long x, long y)
{
	Object *ob; 
	 
	if (state.current_icon==BOXELLIPSEICON)
		{
		if (view->gridon)
			{
			cx = (GXP2D(x,view) - x1)/2 + x1;
			cy = (GYP2D(y,view) - y1)/2 + y1;
			xr = abs(GXP2D(x,view) - x1)/2;
			yr = abs(GYP2D(y,view) - y1)/2;
			}
		else
			{
			cx = (XP2D(x,view) - x1)/2 + x1;
			cy = (YP2D(y,view) - y1)/2 + y1;
			xr = abs(XP2D(x,view) - x1)/2;
			yr = abs(YP2D(y,view) - y1)/2;
			};
		}
	else
		{
		if (view->gridon)
			{
			xr = abs(GXP2D(x, view) - cx);
			yr = abs(GYP2D(y, view) - cy);
			}
		else
			{
			xr = abs(XP2D(x, view) - cx);
			yr = abs(YP2D(y, view) - cy);
			};
		};
		 
	/* constrain */
 	if (state.control_down) 
 		constrain_ellipse(&xr,&yr); 

	ob = (Object *)malloc(sizeof(Object));
	if (ob==NULL)
		return;
	
	ob->type = ELLIPSE;
	ob->ticket = ob_ticket++;
	ob->derries = NULL; 
	ob->depth = view->doc->ob_depth--;  
	ob->ls = view->linestyle;
	ob->lw = view->linewidth; 
	ob->colour = view->colour; 
	ob->fillcolour = view->fillcolour; 
	if (view->fillon)
		ob->fs = view->fillstyle;
	else
		ob->fs = NONE;

	ob->dash = 5;
	ob->gap = 4;
	ob->bbox.x1 = cx - xr;
	ob->bbox.y1 = cy - yr;
	ob->bbox.x2 = cx + xr;
	ob->bbox.y2 = cy + yr;
	ob->ob.ellipse.centre.x = cx - ob->bbox.x1;
	ob->ob.ellipse.centre.y = cy - ob->bbox.y1;
	ob->ob.ellipse.xradius = xr;
	ob->ob.ellipse.yradius = yr;
	ob->farrow = NULL; 
	ob->barrow = NULL; 
	
 	normalise_rectangle(&ob->bbox.x1, &ob->bbox.y1, &ob->bbox.x2, &ob->bbox.y2); 
	ob->bbox.x2 = cx + xr +1;
	ob->bbox.y2 = cy + yr +1;
	 
	view->doc->o = add_object(view->doc->o, &view->doc->lo, ob);
	 
	register_undo(UNDO_PASTE,ob,view->doc); 
	send_redraw_object(view,ob); 
}

void 
ellipse_button(BEvent *bev, View *view)
{
	 
	if (((held && bev->button==Button2) || bev->button==Button3) && state.busy_drawing )
		{
		/* cancel the current ellipse */ 
		if (!held) 
			XUngrabPointer(display,CurrentTime);
		
		toggle_ellipse(view, bev->x, bev->y);
			 
		state.busy_drawing = FALSE;
		held = FALSE;
		}
	else if (bev->button==Button1)
		{
		if (!P_IN_DOC(bev->x, bev->y, view) && state.busy_drawing)
			{
			/* ok, cancel the ellipse  we're drawing  */
			state.busy_drawing = FALSE;
			 
			if (!held)
				XUngrabPointer(display,CurrentTime);
			else 
				held = FALSE;
			
			toggle_ellipse(view, bev->x, bev->y);
			}
		else
			{
			switch (bev->type)
				{
				case BUTTON_HELD:
					
					if (!state.busy_drawing)
						{
						/* start drawing */
						state.busy_drawing = TRUE;
						held = TRUE;
						if (state.current_icon==BOXELLIPSEICON)
							{
							if (view->gridon)
								{
								x1 = GXP2D(bev->x,view);
								y1 = GYP2D(bev->y,view);
								}
							else
								{
								x1 = XP2D(bev->x,view);
								y1 = YP2D(bev->y,view);
								};
							};
							 
						if (view->gridon)
							{
							cx = GXP2D(bev->x,view);
							cy = GYP2D(bev->y,view);
							}
						else
							{
							cx = XP2D(bev->x,view);
							cy = YP2D(bev->y,view);
							};	
						
						xr = 1;
						yr = 1; 
							
 						toggle_ellipse(view, bev->x, bev->y);  
						}; 

					break; /* BUTTON_HELD  */ 

				case BUTTON_CLICKED:

					if (held)
						{
						XGrabPointer(display, view->draw_window->win, False, ButtonPressMask | ButtonReleaseMask | PointerMotionMask | ButtonMotionMask 
										 | Button1MotionMask, GrabModeAsync, GrabModeAsync, None, None, CurrentTime); 
						}
					else
						{
						XUngrabPointer(display,CurrentTime);
						toggle_ellipse(view, bev->x, bev->y);
					
						commit_ellipse(view, bev->x, bev->y);

						state.busy_drawing=FALSE;
						}; 
					 
					held = FALSE; 
					break;
					 
					  
				case BUTTON_RELEASED:
					
					toggle_ellipse(view, bev->x, bev->y);
					 
					commit_ellipse(view, bev->x, bev->y);
					held = FALSE;
					state.busy_drawing=FALSE;

					break;
				};
			}; 
		}; 
}

void 
toggle_ellipse(View *view, int x, int y)
{
	if (state.current_icon==BOXELLIPSEICON)
		{
		if (view->gridon)
			{
			cx = (GXP2D(x,view) - x1)/2 + x1;
			cy = (GYP2D(y,view) - y1)/2 + y1;
			xr = abs(GXP2D(x,view) - x1)/2;
			yr = abs(GYP2D(y,view) - y1)/2;
			}
		else
			{
			cx = (XP2D(x,view) - x1)/2 + x1;
			cy = (YP2D(y,view) - y1)/2 + y1;
			xr = abs(XP2D(x,view) - x1)/2;
			yr = abs(YP2D(y,view) - y1)/2;
			};
		}
	else
		{
		if (view->gridon)
			{
			xr = abs(GXP2D(x, view) - cx);
			yr = abs(GYP2D(y, view) - cy);
			}
		else
			{
			xr = abs(XP2D(x, view) - cx);
			yr = abs(YP2D(y, view) - cy);
			};
		}; 
		 
	/* constrain */
 	if (state.control_down) 
 		constrain_ellipse(&xr,&yr); 

	XDrawArc(display, view->draw_window->win, blackxorgc, XD2P(cx-xr,view), YD2P(cy-yr,view),
				(uint)D2P(2*xr,view), (uint)D2P(2*yr,view), 0, 360*64);
}

void 
draw_ellipse(Object *ob, View *view, GC gc, long x,long y, double rx, double ry)
{
	GC tgc;
	int r; 

	if (gc==NULL)
		tgc = ugc;
	else 
		tgc = gc;
	
	if (gc==blackxorgc && state.tied_corner != NOTSCALING)
		{
		corner_magic(ob, &x, &y, rx, ry);
		r = ellipse_box(XD2P(x+ob->ob.ellipse.centre.x,view),YD2P(y+ob->ob.ellipse.centre.y,view),
				 D2P(ob->ob.ellipse.xradius,view), D2P(ob->ob.ellipse.yradius,view),
				 0, 0, (long)view->window.w, (long)view->window.h);

		if (r!=NO_INTERSECT && r!=CONTAINS)
			{
			XDrawArc(display, view->draw_window->win, tgc, 
					XD2P(x,view), YD2P(y,view),
					(uint)D2P(abs(R(2*ob->ob.ellipse.xradius,rx)),view), 
					(uint)D2P(abs(R(2*ob->ob.ellipse.yradius,ry)),view), 
					0, 360*64);
			};
		}
	else
		{
		r = ellipse_box(XD2P(x+ob->ob.ellipse.centre.x,view),YD2P(y+ob->ob.ellipse.centre.y,view),
				 D2P(ob->ob.ellipse.xradius,view), D2P(ob->ob.ellipse.yradius,view),
				 0, 0, (long)view->draw_window->w, (long)view->draw_window->h);
	
		if (r==CONTAINED && ob->fs!=NONE && gc!=blackxorgc)
			{
			XFillArc(display, view->draw_window->win, fillgc,
					XD2P(x,view), YD2P(y,view),
					(uint)D2P(2*ob->ob.ellipse.xradius,view), 
					(uint)D2P(2*ob->ob.ellipse.yradius,view), 
					0, 360*64);
			};
			 
		if (r==CONTAINS && ob->fs!=NONE && gc!=blackxorgc)
			XFillRectangle(display,view->draw_window->win,fillgc,0,0,view->draw_window->w, view->draw_window->h);

		if (r!=NO_INTERSECT && r!=CONTAINS && (gc==blackxorgc || ob->lw!=0))
			{
			XDrawArc(display, view->draw_window->win, tgc, 
					XD2P(x,view), YD2P(y,view),
					(uint)D2P(2*ob->ob.ellipse.xradius,view), 
					(uint)D2P(2*ob->ob.ellipse.yradius,view), 
					0, 360*64);
			};
		};
	
}
