/* keyboard.c  */
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* for handling keyboard events  */ 
/*
 * $Log: keyboard.c,v $
 * Revision 1.3  2000/12/17 00:57:42  moz
 * examples, filled open splines, highlight_objects
 *
 * Revision 1.2  2000/12/06 20:56:02  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:31  moz
 * CVS Import
 *
 * Revision 1.31  2000/03/14 02:16:51  moz
 * editing_object fixes.
 *
 * Revision 1.30  2000/03/12 04:13:27  moz
 * Tab only in edit mode.
 *
 * Revision 1.29  2000/03/11 19:49:23  moz
 * Don't tab when editing object, points, or in points mode.
 *
 * Revision 1.28  2000/03/11 19:42:59  moz
 * Added tab feature.
 *
 * Revision 1.27  2000/03/07 21:44:11  moz
 * Compile fixes.
 *
 * Revision 1.26  2000/02/04 01:53:48  moz
 * switch_icons() needs view.
 *
 * Revision 1.25  2000/01/29 21:00:08  moz
 * Removed dead comment.
 *
 * Revision 1.24  2000/01/26 18:16:57  moz
 * Delete list fix for intersecting_objects().
 *
 * Revision 1.23  1999/11/15 02:08:55  moz
 * Name change.
 * Better typing with enums.
 *
 * Revision 1.22  1999/08/09 00:18:07  moz
 * Pass along suitable keypresses to icon_chosen().
 *
 * Revision 1.21  1999/08/08 20:55:00  moz
 * From clean up of structs.
 *
 * Revision 1.20  1999/07/04 00:57:14  moz
 * Re-instated the zoom ability whilst drawing !
 *
 * Revision 1.19  1999/07/03 21:35:45  moz
 * zoom_in() and zoom_out() from a button==FALSE.
 *
 * Revision 1.18  1999/06/30 13:08:33  moz
 * Don't allow silly keypresses when editing text.
 *
 * Revision 1.17  1999/05/22 23:39:04  moz
 *  Pedantic ANSI.
 *
 * Revision 1.16  1999/05/22 02:54:38  moz
 * new_doc takes an argument.
 *
 * Revision 1.15  1999/05/19 17:08:59  moz
 * 1.0 Checkin.
 *
 * Revision 1.14  1999/05/05 12:29:01  moz
 * Print dialog.
 *
 * Revision 1.13  1999/05/04 22:31:29  moz
 * Update grid and showgrid icons correctly.
 *
 * Revision 1.12  1999/05/04 22:23:46  moz
 * All keyboard shortcuts.
 *
 * Revision 1.11  1999/05/04 15:49:43  moz
 * Make sure we're not editing before handling keypress.
 *
 * Revision 1.10  1999/05/03 06:21:04  moz
 * Updates with event_loop.c
 *
 * Revision 1.9  1999/04/29 22:02:21  moz
 * Redo is ^R.
 * register an undo for moving ob with cursor keys.
 *
 * Revision 1.8  1999/04/27 16:55:36  moz
 * Flip object.
 *
 * Revision 1.7  1999/04/27 04:10:57  moz
 * -Wall appeased.
 *
 * Revision 1.6  1999/04/26 19:59:47  moz
 * Use move_object.
 *
 * Revision 1.5  1999/04/23 00:39:47  moz
 * redraw_view_window change.
 *
 * Revision 1.4  1999/04/08 02:06:23  moz
 * Get correct icons on switching back to edit object mode fix.
 *
 * Revision 1.3  1999/04/04 01:50:08  moz
 * Various fixes and changes.
 *
 * Revision 1.2  1999/04/03 21:12:16  moz
 * Harmonised structure of file, added Undo and Help, moved help to handle_menu.c
 *
 * Revision 1.1  1999/03/30 00:05:15  moz
 * Initial revision
 *
 */

#include "include/figurine.h"
#include "include/extern.h"
#include <X11/keysym.h> 
 
void
fake_icon_chosen(IconType icon, Window parent)
{
	XEvent report;

	report.xclient.data.l[0] = icon;

	switch (icon)
		{
		case POINTERICON:
		case POLYLINEICON:
		case ELLIPSEICON:
		case ARCELLIPSEICON:
		case BOXELLIPSEICON:
		case COMPOUNDICON:
		case POLYGONICON:
		case SPLINEICON:
		case NODEICON:
		case ARCICON:
		case RECTANGLEICON:
		case TEXTICON:
			change_function(report);
			break;

		default:
			/* e.g. "m" on the tool window shouldn't work  */  
			if (parent==(Window)-1)
				return;
			report.xclient.data.l[1] = (ulong)parent;
			icon_chosen(report); 
			break; 
		};
}

void 
handle_keypress(XKeyPressedEvent *report)
{
	List l;
	View *v=NULL; 
	char str[FIGURINE_PATH_MAX];
	KeySym keysym; 
	Object *o; 

	l = where_in_list(wins,report->window);

	if (l!=NULL)
		{
		switch (l->type)
			{
			case DRAW_WIN:
			case RULER_X_WIN:
			case RULER_Y_WIN:
				l = where_in_list(wins,WS(l)->parent);
			case MAIN_VIEW_WIN:
				v = VIEW(l); /* for readability  */  
			};
		}; 
	
	if (v!=NULL && v->guide_lines_displayed)
		{
		toggle_guidelines(v);
		v->guide_lines_displayed=FALSE;
		};
		 
	/* if keypress fell on view window, v will be set  */  
	if (v!=NULL)
		{
		/* if editing text, pass on to text.c */  
		if (state.editing_text)
			{
			text_key(v,report);
			return;
			};
				 
		/* or arc.c if ARCICON is selected  */ 
		if (state.current_icon==ARCICON)
			{
			if (arc_key(v,report))
				return;
			};
		}; 
		 
	XLookupString(report,str,sizeof(str), &keysym, NULL);
	 
	/* if we're busy, ignore keypresses other than zoom  */ 
	if ((state.busy_drawing || state.editing_point || state.editing_object || state.editing_text) &&
		 keysym!=XK_plus && keysym!=XK_equal && keysym!=XK_minus && keysym!=XK_underscore)
		return;
	
	 
	/* menus, control+key  */
	if (report->state & ControlMask)
		{
		switch (keysym)
			{
			case XK_N:
			case XK_n: 
				new_view(new_doc(TRUE)); 
				return;
				break;
			
			case XK_O:
			case XK_o:
				fill_in_file(lfile_text,rfile_text,state.show_fig_files_only);
				if (state.show_fig_files_only) 
					stk_choice_on(file_figfiles,0);
				else
					stk_choice_off(file_figfiles,0);
				stk_set_text_entry(file_entry,state.cwd);
				stk_open_dialog(file_dialog,NULL); 
				return; 
				break;

			case XK_S:
			case XK_s:
				if (v) 
					save(v->doc); 
				return;
				break;

			case XK_h:
			case XK_H:
				start_help(); 
				return; 
				break;

			case XK_I:
			case XK_i:
				if (v)
					{
					fill_in_file(insertlfile_text,insertrfile_text,state.show_fig_files_only);
					if (state.show_fig_files_only) 
						stk_choice_on(insertfile_figfiles,0);
					else
						stk_choice_off(insertfile_figfiles,0);
					stk_set_text_entry(insertfile_entry,state.cwd);
					stk_open_dialog(insertfile_dialog,(void *)v);
					return; 
					}; 
				return; 
				break; 
					
			case XK_A:	
			case XK_a:
				if (v)
					{
					fill_in_file(savelfile_text, saverfile_text, state.show_fig_files_only);
					if (state.show_fig_files_only) 
						stk_choice_on(savefile_figfiles,0);
					else
						stk_choice_off(savefile_figfiles,0);
					stk_set_text_entry(savefile_entry,state.cwd);
					stk_open_dialog(savefile_dialog,(void *)v);
					return;
					}; 
				return; 
				break;

			case XK_E:
			case XK_e:
				if (v)
					{
					fill_in_file(exportlfile_text, exportrfile_text,FALSE);
					strcpy(str,v->doc->pathname);
					strcat(str,v->doc->filename);
					stk_set_text_entry(exportfile_entry,str);
					add_export_extension(EXPORT_EPS);
					stk_select_textlist_member(exportformat_text,".eps: Encapsulated PostScript");
					stk_open_dialog(exportfile_dialog,(void *)v);
					}; 
				return;
				break;

			case XK_P:
			case XK_p:
				if (v)
					{
					strcpy(str,state.print);
					if (v->doc->centred) 
						{ 
						stk_choice_on(printfile_choice,1);
						stk_choice_off(printfile_choice,2);
						}
					else
						{
						stk_choice_on(printfile_choice,2);
						stk_choice_off(printfile_choice,1);
						};
					stk_set_text_entry(printfile_entry,str);
					stk_open_dialog(printfile_dialog,(void *)v);
					};
				return;
				break;

			case XK_D:
			case XK_d:
				if (v) 
					close_view(v);
				return; 
				break;

			case XK_M:
			case XK_m:
				if (v) 
					new_view(v->doc);
				return;
				break;

			case XK_B:
			case XK_b:
				if (v)
					{
					sprintf(str,"%.3f",((double)(v->grid_x))/v->doc->ppi);
					stk_set_text_entry(view_gridx_entry,str);
					sprintf(str,"%.3f",((double)(v->grid_y))/v->doc->ppi);
					stk_set_text_entry(view_gridy_entry,str);
					if (v->in_mm)
						{
						stk_choice_on(view_units,1);
						stk_choice_off(view_units,2);
						}
					else
						{
						stk_choice_on(view_units,2);
						stk_choice_off(view_units,1);
						};
					if (v->guide_lines)
						stk_choice_on(view_guides,0);
					else
						stk_choice_off(view_guides,0);

					if (v->highlight_objects)
						stk_choice_on(view_highlight,0);
					else
						stk_choice_off(view_highlight,0);

					if (v->show_compounds)
						stk_choice_on(view_compounds,0);
					else
						stk_choice_off(view_compounds,0);

					stk_open_dialog(view_dialog,v);
					}; 
				return;
				break;                          
				 
			case XK_Q:
			case XK_q:
				close_down();
				return;
				break;

			case XK_X:
			case XK_x:
				if (v && v->selected_object)
					{
					Object *ob=v->selected_object->ob;
					send_redraw_object(v,ob);
					cut_object(v,ob);
					v->selected_object = NULL;
					v->highlighted_object = NULL;
					stk_enable_menu_label(emw,2); 
					};
				return;
				break;

			case XK_C:
			case XK_c:
				if (v &&  v->selected_object)
					{ 
					copy_object(v->selected_object->ob);
					stk_enable_menu_label(emw,2); 
					}; 
				return;
				break;

			case XK_V:
			case XK_v:
				if (v!=NULL)
					{
					if (v->selected_object!=NULL)
						{
						Object *ob=v->selected_object->ob;
						v->selected_object = NULL; 
						v->highlighted_object = NULL; 
						send_redraw_object(v,ob);
						}; 
					paste_object(v,XP2D(mouse_x,v),YP2D(mouse_y,v));
					}; 
				return;
				break;

			case XK_Z:
			case XK_z:
				do_undo();
				return; 
				break;

			case XK_R:
			case XK_r:
				do_redo();
				return; 
				break;

			case XK_parenleft: /* (  */  
			case XK_9: 
				if (v && v->selected_object && v->selected_object->ob->type!=TEXT 
					&& v->selected_object->ob->type!=ELLIPSE)
					flip_object_x(v,v->selected_object->ob);
				return; 
				break;

			case XK_parenright: /* (  */  
			case XK_0: 
				if (v && v->selected_object && v->selected_object->ob->type!=TEXT 
					&& v->selected_object->ob->type!=ELLIPSE)
					flip_object_y(v,v->selected_object->ob);
				return; 
				break;
				 
			case XK_braceleft: /* {,[  */ 
			case XK_bracketleft:
				if (v && v->selected_object)
					{
					v->selected_object->ob->depth = v->doc->ob_depth--;
					if (v->selected_object->ob->type==TEXT &&
						 v->selected_object->ob->ob.text.node)
						v->selected_object->ob->ob.text.ellipse->depth = v->selected_object->ob->depth+1;
					send_redraw_object(v, v->selected_object->ob);
					};
				return;
				break;

			case XK_braceright: /* },]  */  
			case XK_bracketright: 
				if (v && v->selected_object) 
					{
					List l2;
					ulong new_depth;

					new_depth = v->selected_object->ob->depth; 
							  
					l  = intersecting_objects(v->doc->o, v->selected_object->ob->bbox, NULL);
					l2 = l; 

					while (l!=NULL)
						{
						if (OB(l)!=v->selected_object->ob) 
							new_depth = OB(l)->depth; 
						else 
							break;
						l=l->next; 
						};

					v->selected_object->ob->depth = ++new_depth;
					if (v->selected_object->ob->type==TEXT &&
						 v->selected_object->ob->ob.text.node)
						v->selected_object->ob->ob.text.ellipse->depth = v->selected_object->ob->depth+1;
					send_redraw_object(v, v->selected_object->ob);
					delete_list(l2); 
					}; 
				return;
				break;
				
			default:
				break;
			};
		};
		
	/* space switches back to pointer mode  */ 	 
	/* with a selected object, it flips between point editing and object editing  */  
	if (keysym==XK_space) /* switch back to object mode  */ 
		{ 
		if (state.current_icon!=POINTERICON)
			{ 
			fake_icon_chosen(POINTERICON, (Window)-1); 
			} 
		else if (v!=NULL && state.current_icon==POINTERICON && v->highlighted_object!=NULL)
			{
			if (v->highlighted_object->ob->type!=POLYGON &&
				 v->highlighted_object->ob->type!=POLYLINE &&
				 v->highlighted_object->ob->type!=SPLINE &&
				 v->highlighted_object->ob->type!=ARC &&
				 v->highlighted_object->ob->type!=RECTANGLE)
				return; /* no point editing for ellipses etc. */ 
				 
			/* enter point editing  */ 
			v->edited_object = v->highlighted_object;
			v->highlighted_object = NULL;
			v->selected_object = NULL; 
			send_redraw_object(v, v->edited_object->ob); 
			}
		else if (v!=NULL && state.current_icon==POINTERICON && v->edited_object!=NULL)
			{
			/* enter object editing  */ 
			v->highlighted_object = v->edited_object;
			v->selected_object = v->edited_object;
			switch_icons(v); 
			send_redraw_object(v, v->edited_object->ob);
			v->edited_object = NULL;
			};
		};

	/* ordinary shortcuts  */  
	/* there are three things that can happen here:
		an icon menu can open, a dialog can open, or the
		main tool is changed */  
	/* to keep the code in handle_icon.c, we fake a button press  */ 
	 
	switch (keysym)
		{
		case XK_A: case XK_a: fake_icon_chosen(ARCICON,(Window)-1); break;
		case XK_B: case XK_b: fake_icon_chosen(BOXELLIPSEICON,(Window)-1); break;
		case XK_C: case XK_c: fake_icon_chosen(COMPOUNDICON,(Window)-1); break;
		case XK_D: case XK_d: fake_icon_chosen(SHOWGRIDICON, NVIW(v)); break; 
		case XK_E: case XK_e: fake_icon_chosen(ELLIPSEICON,(Window)-1); break;
		case XK_F: case XK_f: fake_icon_chosen(ARCELLIPSEICON,(Window)-1); break;
		case XK_G: case XK_g: fake_icon_chosen(POLYGONICON,(Window)-1); break;
		case XK_H: case XK_h: fake_icon_chosen(SETPOLYGONICON, NVIW(v)); break;
		case XK_I: case XK_i: fake_icon_chosen(GRIDICON, NVIW(v)); break;
		case XK_J: case XK_j: fake_icon_chosen(JOINSTYLEICON, NVIW(v)); break;
		case XK_K: case XK_k: fake_icon_chosen(JUSTIFICATIONICON, NVIW(v)); break;
		case XK_L: case XK_l: fake_icon_chosen(POLYLINEICON,(Window)-1); break;
		case XK_M: case XK_m: fake_icon_chosen(ARROWICON, NVIW(v)); break;
		case XK_N: case XK_n: fake_icon_chosen(NODEICON,(Window)-1); break;
		case XK_O: case XK_o: 
			(state.current_icon==SPLINEICON) ? fake_icon_chosen(SETSPLINEICON, NVIW(v))
														: fake_icon_chosen(SETARCELLIPSEICON, NVIW(v));
			break;
		case XK_P: case XK_p: fake_icon_chosen(COLOURICON, NVIW(v)); break;
		case XK_Q: case XK_q: fake_icon_chosen(FILLCOLOURICON, NVIW(v)); break;
		case XK_R: case XK_r: fake_icon_chosen(RECTANGLEICON,(Window)-1); break;
		case XK_S: case XK_s: fake_icon_chosen(SPLINEICON,(Window)-1); break;
		case XK_T: case XK_t: fake_icon_chosen(TEXTICON,(Window)-1); break;
		case XK_U: case XK_u: fake_icon_chosen(FONTICON, NVIW(v)); break;
		case XK_V: case XK_v: fake_icon_chosen(ROUNDBOXICON, NVIW(v)); break;
		case XK_W: case XK_w: fake_icon_chosen(LINEWIDTHICON, NVIW(v)); break;
		case XK_X: case XK_x: fake_icon_chosen(ENDSTYLEICON, NVIW(v)); break;
		case XK_Y: case XK_y: fake_icon_chosen(LINESTYLEICON, NVIW(v)); break;
		case XK_Z: case XK_z: fake_icon_chosen(FILLSTYLEICON, NVIW(v)); break;
		}; 
	
	if (v==NULL)
		return;

	/* everything below here expects a View v  */ 
	 
	switch (keysym)
		{
		case XK_Undo:
			do_undo();
			break;

		case XK_Help:
			start_help();
			break;

		case XK_plus:
		case XK_equal:
			zoom_in(v,FALSE); 
			break;

		case XK_minus:
		case XK_underscore:
			zoom_out(v,FALSE); 
			break; 
		
		case XK_Tab:
			if (v->edited_object)
				break;
				 
			if (v->selected_object)
				{
				List l2; 

				o=v->selected_object->ob;
				l = where_in_list(v->doc->lo,(ulong)v->selected_object->ob);
				if (l->next) 
					l2 = l->next;
				else
					l2 = v->doc->lo; 
				if (l2) 
					{ 
					v->selected_object = get_object_node(v->doc->o, OB(l2)); 
					v->highlighted_object = v->selected_object;
					switch_icons(v); 
					send_redraw_object(v,o);
					if (v->selected_object) 
						send_redraw_object(v,v->selected_object->ob); 
					}; 
				}
			else if (v->doc->lo && state.current_icon==POINTERICON)
				{
				if (v->highlighted_object) 
					send_redraw_object(v,v->highlighted_object->ob); 
				v->selected_object = get_object_node(v->doc->o, OB(v->doc->lo));
				v->highlighted_object = v->selected_object;
				switch_icons(v); 
				if (v->selected_object) 
					send_redraw_object(v,v->selected_object->ob); 
				};
			break;

		case XK_BackSpace:
		case XK_Delete:
			if (v->selected_object)
				{
				o=v->selected_object->ob;
				register_undo(UNDO_CUT,o,v->doc);
				send_redraw_object(v,o);
				v->doc->o = trash_object(v->doc->o, &v->doc->lo, o);
				kill_object(o);
				v->selected_object = NULL;
				v->highlighted_object = NULL;
				};
			break;    
 
 		/* cursors move a selected object, or move around a document  */  
		case XK_Up:
			if (v->selected_object==NULL)
				{
				if (nudge_ruler_y(v->ruler_y_window, v, UP)!=-1)
					redraw_view_window(v); 
				}
			else
				{ 
				Object *ob = v->selected_object->ob; 
				register_undo(UNDO_OB_PROP,ob,v->doc); 
				store_redraw_object(ob); 
				if (report->state & ShiftMask)
					move_object(v,ob,0,P2D(-1,v)); 
				else
					move_object(v,ob,0,P2D(-5,v)); 
				send_stored_redraw_object(v, ob); 
				};
			break;

		case XK_Down:
			if (v->selected_object==NULL)
				{
				if (nudge_ruler_y(v->ruler_y_window, v, DOWN)!=-1)
					redraw_view_window(v); 
				}
			else
				{ 
				Object *ob = v->selected_object->ob; 
				register_undo(UNDO_OB_PROP,ob,v->doc); 
				store_redraw_object(ob); 
				if (report->state & ShiftMask)
					move_object(v,ob,0,P2D(1,v)); 
				else
					move_object(v,ob,0,P2D(5,v)); 
				send_stored_redraw_object(v, ob); 
				};
			break;

		case XK_Left:
			if (v->selected_object==NULL)
				{
				if (nudge_ruler_x(v->ruler_x_window, v, LEFT)!=-1)
					redraw_view_window(v); 
				}
			else
				{ 
				Object *ob = v->selected_object->ob; 
				register_undo(UNDO_OB_PROP,ob,v->doc); 
				store_redraw_object(ob); 
				if (report->state & ShiftMask)
					move_object(v,ob,P2D(-1,v),0); 
				else
					move_object(v,ob,P2D(-5,v),0); 
				send_stored_redraw_object(v, ob); 
				};
			break;

		case XK_Right:
			if (v->selected_object==NULL)
				{
				if (nudge_ruler_x(v->ruler_x_window, v, RIGHT)!=-1)
					redraw_view_window(v); 
				}
			else
				{ 
				Object *ob = v->selected_object->ob; 
				register_undo(UNDO_OB_PROP,ob,v->doc); 
				store_redraw_object(ob); 
				if (report->state & ShiftMask)
					move_object(v,ob,P2D(1,v),0); 
				else
					move_object(v,ob,P2D(5,v),0); 
				send_stored_redraw_object(v, ob); 
				};
			break;

		case XK_Shift_L:
		case XK_Shift_R:
		   if (state.busy_drawing && (state.current_icon==POLYLINEICON ||
               state.current_icon==POLYGONICON || state.current_icon==SPLINEICON ||
               state.current_icon==ARCICON))  
				{
				Object *dob=NULL; 
				long x,y;

				if (get_nearest_point(v,v->doc->o, XP2D(mouse_x,v),YP2D(mouse_y,v),&x,&y,&dob))
					{
					toggle(v,mouse_x,mouse_y); 
					mouse_x = XD2P(x,v);
					mouse_y = YD2P(y,v);
					XWarpPointer(display, None, v->draw_window->win, 0, 0, 1, 1, 
									 mouse_x,mouse_y);
					toggle(v,mouse_x,mouse_y);
					};
				}
			else if (v->edited_object!=NULL)
				{
				Object *dob=NULL; 
				long tx, ty;
				 
				if (get_nearest_point(v,v->doc->o, XP2D(mouse_x,v),YP2D(mouse_y,v),&tx,&ty,&dob))
					{
					mouse_x = XD2P(tx,v);
					mouse_y = YD2P(ty,v);
					XWarpPointer(display, None, v->draw_window->win, 0, 0, 1, 1, 
									 mouse_x,mouse_y);
					};
				};
			break; 
			
		default:
			break;
		}; 
			
}
