/* Function to handle XEvent notifications - must be checked for being an STK window */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: stk_notify.c,v $
 * Revision 1.2  2000/12/06 20:56:06  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:31  moz
 * CVS Import
 *
 * Revision 1.7  2000/02/18 02:44:54  moz
 * Compile fixes.
 *
 * Revision 1.6  2000/01/30 17:23:07  moz
 * Pass back ClientMessage windelete events.
 *
 * Revision 1.5  1999/06/30 13:10:14  moz
 * Fix for changing tooltip legend across window bounds.
 *
 * Revision 1.4  1999/06/16 00:57:10  moz
 * Remove timed tooltip removol.
 * enter/leave_notify should be xcrossing, not xmotion.
 *
 * Revision 1.3  1999/05/19 17:07:03  moz
 * 1.0 Checkin.
 *
 * Revision 1.2  1999/05/04 19:46:34  moz
 * Tooltip redraw fix.
 *
 * Revision 1.1  1999/03/30 00:06:52  moz
 * Initial revision
 *
 */    


#include <sys/time.h> 
#include <stdio.h> 
#include "include/stk_internal.h" 
#include "include/stk_extern.h"
#include "include/stk.h"


extern WindowStruct bar_window;

/* borrowed from client for convenience  */  
extern Atom windelete;
extern Atom winproto;
 
/* stk_notify  */  
/* returns TRUE if the window was an stk window */ 
/* stk_tooltip is usually called to update the tooltip  */  

Boolean 
stk_notify(XEvent *report)
{
	ListEl *tl; 
	
	switch (report->type)
		{
		case DestroyNotify:
			if (!is_in_list(stk_window_list, (ulong)report->xdestroywindow.window))
				return FALSE;
			
			return TRUE;
			break;

		case ButtonPress:
			if (!is_in_list(stk_window_list, (ulong)report->xbutton.window))
				return FALSE;
			
			stk_handle_button_press(report->xbutton.window, report->xbutton.x, 
						report->xbutton.y, report->xbutton.button);

			stk_tooltip(report->xbutton.window,FALSE);
			break;

		case ButtonRelease: 
			if (!is_in_list(stk_window_list, (ulong)report->xbutton.window))
				return FALSE;
				 
			stk_handle_button_release(report->xbutton.window, report->xbutton.time, report->xbutton.x, report->xbutton.y, report->xbutton.button);

			stk_tooltip(report->xbutton.window, FALSE);
			break; 
				
		case KeyPress: 
			if (!is_in_list(stk_window_list, (ulong)report->xkey.window))
				return FALSE;
			
			return stk_keyboard((XKeyPressedEvent *)report);
			break;
					
		case MotionNotify:
			if (!is_in_list(stk_window_list, (ulong)report->xmotion.window))
				return FALSE;
			
			stk_handle_motion(report->xmotion.window, report->xmotion.x, report->xmotion.y); 
			stk_tooltip(report->xmotion.window, FALSE);
			break;

		case EnterNotify: 
			if (!is_in_list(stk_window_list, (ulong)report->xcrossing.window))
				return FALSE;
				
			stk_handle_enter_notify(report->xcrossing.window);
			stk_tooltip(report->xcrossing.window, TRUE);
			break;

		case LeaveNotify:
			if (!is_in_list(stk_window_list, (ulong)report->xcrossing.window))
				return FALSE;
			
			stk_handle_leave_notify(report->xcrossing.window);
			stk_tooltip(report->xcrossing.window, TRUE);
			break;

		case FocusIn:
			if (!is_in_list(stk_window_list, (ulong)report->xfocus.window))
				return FALSE;
			stk_tooltip(report->xfocus.window, FALSE);
			break;

		case FocusOut:
			if (!is_in_list(stk_window_list, (ulong)report->xfocus.window))
				return FALSE;
			stk_tooltip(report->xfocus.window, FALSE);
			break;
	
		case ConfigureNotify:
			if (!is_in_list(stk_window_list, (ulong)report->xconfigure.window))
				return FALSE;

			stk_handle_configure_notify(report->xconfigure.window, report->xconfigure.x,
						report->xconfigure.y, report->xconfigure.width, report->xconfigure.height);
			break; 
			 
		case Expose:
			if (!is_in_list(stk_window_list, (ulong)report->xexpose.window))
				return FALSE;
			
			if (report->xexpose.count != 0)
				break;
				 
			if (bar_window.win!=0 && report->xexpose.window == bar_window.win) /* if menu bar  */ 
				stk_redraw_menu_bar(); 
			else 
				{
				tl = where_in_list(stk_window_list, (ulong)report->xexpose.window);

				switch (tl->type)
					{
					case ICON_TYPE:
					case MENU_ICON_TYPE: 
						stk_redraw_icon((stkInternalIcon *)tl->data);
						break;
						
					case TOOL_WINDOW_TYPE:
						break;
					
					case MENU_TYPE:
						stk_redraw_menu((stkInternalMenu *)tl->data);
						break; 
					
					case DIALOG_TYPE:
						stk_redraw_dialog(DIALOG(tl));
						break;

					case DIALOG_TITLE_TYPE:
 						stk_redraw_dialog_title(DIALOGTITLE(tl));
						break; 
					
					case DIALOG_VSLIDER_TYPE:
						stk_redraw_dialog_slider(((stkInternalDialogVSlider *)tl->data));
						break;

					case DIALOG_TEXT_SLIDER_TYPE:	
						stk_redraw_dialog_text_slider(((stkInternalDialogSlider *)tl->data));
						break; 
					
					case DIALOG_TEXT_LIST_TYPE:
						stk_redraw_dialog_text_list(((stkInternalDialogTextList *)tl->data));
						break; 
					
					case DIALOG_TEXT_ENTRY_TYPE:
						stk_redraw_dialog_text_entry(((stkInternalDialogTextEntry *)tl->data));
						break;

					case DIALOG_CHOICE_TYPE:
						stk_redraw_dialog_choice(((stkInternalDialogChoice *)tl->data));
						break;

					case DIALOG_RADIO_CHOICE_TYPE:
						stk_redraw_dialog_radio_choice(((stkInternalDialogRadioChoice *)tl->data));
						break;

					case DIALOG_TEXT_ENTRY_ENTRY_TYPE:
						stk_redraw_dialog_text_entry_entry(((stkInternalDialogTextEntry *)tl->data));
						break;

					case BUTTON_TYPE:
						stk_redraw_dialog_button(BUTTON(tl));
						break; 
					};
				};
			break;

		case ClientMessage:
			if (!is_in_list(stk_window_list, (ulong)report->xclient.window))
				return FALSE;
			
			if (((Atom)report->xclient.message_type)==winproto) 
				{
				if (((unsigned long)report->xclient.data.l[0])==windelete)
					{
					List l;

					l = where_in_list(stk_window_list,report->xclient.window);
				 
					if (l->type==DIALOG_TYPE)
						{ 
						stk_close_dialog(report->xclient.window);
						/* the main code might be interested if it's a 
						   save/close/cancel dialog */  
						return FALSE;
						};
					};
				}; 
			return FALSE; 
			break;
 
		default:
			return FALSE;
			break; 
		};

	return TRUE;
}	
