/***************************************************************************
 *
 *		File		: main.h
 *
 *		Title		: Flink email checking aplet for GNOME
 *
 *		Description	: see main.h
 *
 *		Author		: Marcus Leyman, 2001
 *
 *		License		: GPL
 *
 *		Date		: 6 May, 2001
 *
 **************************************************************************/
#ifndef MAIN_H
#define MAIN_H

/* create panel button */
void create_panel_applet();
/*create/show applet(left-click) menu */
void show_menu (GtkWidget *widget, gpointer data);
/*decides where to put left-click menu (right beneath a_button) */
void pos(GtkMenu *b_menu, gint *x, gint *y, gpointer data);
/* reads configuration */
void read_conf(GtkWidget *widget, gpointer data);
/* checks all accounts */
void check_all(GtkWidget *widget, gpointer data);
/* checks specified account */
void check_this(GtkWidget *widget, gpointer data);
/* does mail checking */
void check_mail(gpointer data);
/* does pop3 checking */
void check_pop3(gpointer data);
/* does imap4 checking */
void check_imap4(gpointer data);
/* does mbox checking */
void check_mbox(gpointer data);
/* updates the label timely */
int update_label(gpointer data);
/* loads settings window */
void load_config_win();
/* updates clist in settings win */
void add_to_clist(GtkWidget *widget, gpointer data);
/* loads configuration wizard */
void new_account_win();
/* loads dialog for editing existing configuration */
void edit_account_win(GtkWidget *w, gpointer data);
/* saves configuration */
void save_account(GtkWidget *w, gpointer data);
/* deletes account */
void delete_account(GtkWidget *w, gpointer data);
/* hides window */
void hide_widget(GtkWidget *w, gpointer user_data);
/* shows dialog and starts wizard if first time */
void first_time_dia();
/* starts freq. mail checking */
void start_poll_stuff();
/* removes mail-check timeout */
void update_timeout(gint current);
/* callback for starting check from timeout */
int poll_check(gpointer data);
/* show the about dialog */
void load_about_win();
/* updates the layout of panel applet */
void update_layout();
/* adds to theme list */
void add_to_theme_list(GtkWidget *widget, gpointer data);
/* sets the general tab prefs */
void visualize_general_prefs(GtkWidget *w, gpointer data);
/* updates the menu */
void update_menu();
/* runs external program */
void run_program();
/* delete "run program.." item */
void remove_program_item();
/* sets sound-file entry */
void set_entry(gchar *file);
/*saves user defined theme */
void save_user_theme();
/* upgrades config_file */
void config_file_set();
#endif
