/********************************************************************************
*                                                                               *
*             M u l t i p l e   D o c u m e n t   B u t t o n                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998,2001 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: FXMDIButton.cpp,v 1.8 2001/04/27 14:30:34 jeroen Exp $                   *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXSize.h"
#include "FXPoint.h"
#include "FXRectangle.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXSettings.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDC.h"
#include "FXDCWindow.h"
#include "FXFont.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXGIFIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXLabel.h"
#include "FXButton.h"
#include "FXMenuButton.h"
#include "FXComposite.h"
#include "FXShell.h"
#include "FXPopup.h"
#include "FXMenuPane.h"
#include "FXMenuCaption.h"
#include "FXMenuCommand.h"
#include "FXScrollbar.h"
#include "FXScrollArea.h"
#include "FXMDIButton.h"
#include "FXMDIChild.h"
#include "FXMDIClient.h"


#define MENUBUTTONWINDOW_WIDTH  16
#define MENUBUTTONWINDOW_HEIGHT 14

/*******************************************************************************/


/* Generated by reswrap from file winclose.gif */
const unsigned char winclose[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x0f,0x00,0x0e,0x00,0xf0,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x0f,0x00,0x0e,0x00,0x00,0x02,0x1c,0x84,
  0x8f,0xa9,0x9b,0x11,0xfd,0x60,0x04,0x6e,0xa2,0x4a,0x1d,0xcb,0x78,0x73,0xcf,0x69,
  0x0c,0xd6,0x49,0x47,0x79,0x5a,0x19,0xc8,0xb6,0x6c,0x01,0x00,0x3b
  };

/* Generated by reswrap from file winmaximize.gif */
const unsigned char winmaximize[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x0f,0x00,0x0e,0x00,0xf0,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x0f,0x00,0x0e,0x00,0x00,0x02,0x1a,0x84,
  0x8f,0xa9,0x9b,0xe1,0xff,0x14,0x9c,0x72,0x85,0x8a,0xd1,0xcd,0x67,0x37,0xde,0x81,
  0x86,0xd7,0x4d,0x11,0x83,0xa6,0x2a,0x5a,0x00,0x00,0x3b
  };

/* Generated by reswrap from file winminimize.gif */
const unsigned char winminimize[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x0f,0x00,0x0e,0x00,0xf1,0x00,0x00,0xb2,0xc0,0xdc,
  0x50,0x50,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x0f,0x00,
  0x0e,0x00,0x00,0x02,0x14,0x84,0x8f,0xa9,0xcb,0xed,0x0f,0xa3,0x9c,0xd4,0x04,0x81,
  0xb3,0x08,0xea,0x6a,0xcc,0x55,0x22,0x54,0x00,0x00,0x3b
  };

/* Generated by reswrap from file winrestore.gif */
const unsigned char winrestore[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x0f,0x00,0x0e,0x00,0xf0,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x0f,0x00,0x0e,0x00,0x00,0x02,0x1a,0x84,
  0x8f,0xa9,0xbb,0xe1,0x1f,0x18,0x7c,0x32,0x45,0x3b,0xe3,0x45,0x59,0xab,0x6d,0x50,
  0xd6,0xd8,0x90,0x5f,0xc6,0xa4,0xea,0xca,0x16,0x00,0x3b
  };


/*******************************************************************************/


// Map
FXDEFMAP(FXMDIDeleteButton) FXMDIDeleteButtonMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXMDIDeleteButton::onPaint),
  };


// Object implementation
FXIMPLEMENT(FXMDIDeleteButton,FXButton,FXMDIDeleteButtonMap,ARRAYNUMBER(FXMDIDeleteButtonMap))



// Make delete button
FXMDIDeleteButton::FXMDIDeleteButton(FXComposite* p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXButton(p,"\tClose\tClose Window.",NULL,tgt,sel,opts,x,y,w,h,3,3,2,2){
  }


FXint FXMDIDeleteButton::getDefaultWidth(){
  return padleft+padright+8+(border<<1);
  }


FXint FXMDIDeleteButton::getDefaultHeight(){
  return padtop+padbottom+8+(border<<1);
  }


// Handle repaint
long FXMDIDeleteButton::onPaint(FXObject*,FXSelector,void* ptr){
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(this,ev);
  FXint xx,yy;
  dc.setForeground(backColor);
  dc.fillRectangle(ev->rect.x,ev->rect.y,ev->rect.w,ev->rect.h);
  drawFrame(dc,0,0,width,height);
  xx=(width-8)/2;
  yy=(height-8)/2;
  if(state){ ++xx; ++yy; }
  if(isEnabled())
    dc.setForeground(textColor);
  else
    dc.setForeground(shadowColor);
#ifndef WIN32
  dc.drawLine(xx,  yy,  xx+8,yy+8);
  dc.drawLine(xx+1,yy,  xx+8,yy+7);
  dc.drawLine(xx,  yy+1,xx+7,yy+8);
  dc.drawLine(xx+8,yy,  xx,  yy+8);
  dc.drawLine(xx+8,yy+1,xx+1,yy+8);
  dc.drawLine(xx+7,yy,  xx,  yy+7);
#else
  dc.drawLine(xx,  yy,  xx+9,yy+9);
  dc.drawLine(xx+1,yy,  xx+9,yy+8);
  dc.drawLine(xx,  yy+1,xx+8,yy+9);
  dc.drawLine(xx,  yy+8,xx+9,yy-1);
  dc.drawLine(xx+1,yy+8,xx+9,  yy);
  dc.drawLine(xx,  yy+7,xx+8,yy-1);
#endif
  return 1;
  }


/*******************************************************************************/

// Map
FXDEFMAP(FXMDIRestoreButton) FXMDIRestoreButtonMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXMDIRestoreButton::onPaint),
  };


// Object implementation
FXIMPLEMENT(FXMDIRestoreButton,FXButton,FXMDIRestoreButtonMap,ARRAYNUMBER(FXMDIRestoreButtonMap))



// Make restore button
FXMDIRestoreButton::FXMDIRestoreButton(FXComposite* p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXButton(p,"\tRestore\tRestore Window.",NULL,tgt,sel,opts,x,y,w,h,3,3,2,2){
  }


FXint FXMDIRestoreButton::getDefaultWidth(){
  return padleft+padright+8+(border<<1);
  }


FXint FXMDIRestoreButton::getDefaultHeight(){
  return padtop+padbottom+8+(border<<1);
  }


// Handle repaint
long FXMDIRestoreButton::onPaint(FXObject*,FXSelector,void* ptr){
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(this,ev);
  FXint xx,yy;
  dc.setForeground(backColor);
  dc.fillRectangle(ev->rect.x,ev->rect.y,ev->rect.w,ev->rect.h);
  drawFrame(dc,0,0,width,height);
  xx=(width-8)/2;
  yy=(height-8)/2;
  if(state){ ++xx; ++yy; }
  if(isEnabled())
    dc.setForeground(textColor);
  else
    dc.setForeground(shadowColor);
  dc.fillRectangle(xx+3,yy,6,2);
  dc.drawRectangle(xx+3,yy,6,5);
  dc.setForeground(backColor);
  dc.fillRectangle(xx,yy+3,6,5);
  if(isEnabled())
    dc.setForeground(textColor);
  else
    dc.setForeground(shadowColor);
  dc.fillRectangle(xx,yy+3,6,2);
  dc.drawRectangle(xx,yy+3,6,5);
  return 1;
  }


/*******************************************************************************/

// Map
FXDEFMAP(FXMDIMaximizeButton) FXMDIMaximizeButtonMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXMDIMaximizeButton::onPaint),
  };


// Object implementation
FXIMPLEMENT(FXMDIMaximizeButton,FXButton,FXMDIMaximizeButtonMap,ARRAYNUMBER(FXMDIMaximizeButtonMap))



// Make maximize button
FXMDIMaximizeButton::FXMDIMaximizeButton(FXComposite* p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXButton(p,"\tMaximize\tMaximize Window.",NULL,tgt,sel,opts,x,y,w,h,3,3,2,2){
  }

FXint FXMDIMaximizeButton::getDefaultWidth(){
  return padleft+padright+8+(border<<1);
  }


FXint FXMDIMaximizeButton::getDefaultHeight(){
  return padtop+padbottom+8+(border<<1);
  }


// Handle repaint
long FXMDIMaximizeButton::onPaint(FXObject*,FXSelector,void* ptr){
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(this,ev);
  FXint xx,yy;
  dc.setForeground(backColor);
  dc.fillRectangle(ev->rect.x,ev->rect.y,ev->rect.w,ev->rect.h);
  drawFrame(dc,0,0,width,height);
  xx=(width-8)/2;
  yy=(height-8)/2;
  if(state){ ++xx; ++yy; }
  if(isEnabled())
    dc.setForeground(textColor);
  else
    dc.setForeground(shadowColor);
  dc.fillRectangle(xx,yy,8,2);
  dc.drawRectangle(xx,yy,8,8);
  return 1;
  }


/*******************************************************************************/

// Map
FXDEFMAP(FXMDIMinimizeButton) FXMDIMinimizeButtonMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXMDIMinimizeButton::onPaint),
  };


// Object implementation
FXIMPLEMENT(FXMDIMinimizeButton,FXButton,FXMDIMinimizeButtonMap,ARRAYNUMBER(FXMDIMinimizeButtonMap))



// Make minimize button
FXMDIMinimizeButton::FXMDIMinimizeButton(FXComposite* p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXButton(p,"\tMinimize\tMinimize Window.",NULL,tgt,sel,opts,x,y,w,h,3,3,2,2){
  }


FXint FXMDIMinimizeButton::getDefaultWidth(){
  return padleft+padright+8+(border<<1);
  }


FXint FXMDIMinimizeButton::getDefaultHeight(){
  return padtop+padbottom+8+(border<<1);
  }


// Handle repaint
long FXMDIMinimizeButton::onPaint(FXObject*,FXSelector,void* ptr){
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(this,ev);
  FXint xx,yy;
  dc.setForeground(backColor);
  dc.fillRectangle(ev->rect.x,ev->rect.y,ev->rect.w,ev->rect.h);
  drawFrame(dc,0,0,width,height);
  xx=(width-8)/2;
  yy=(height-8)/2;
  if(state){ ++xx; ++yy; }
  if(isEnabled())
    dc.setForeground(textColor);
  else
    dc.setForeground(shadowColor);
  dc.fillRectangle(xx,yy+6,8,2);
  return 1;
  }


/*******************************************************************************/


// Map
FXDEFMAP(FXMDIWindowButton) FXMDIWindowButtonMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXMDIWindowButton::onPaint),
  };


// Object implementation
FXIMPLEMENT(FXMDIWindowButton,FXMenuButton,FXMDIWindowButtonMap,ARRAYNUMBER(FXMDIWindowButtonMap))



// Make window button
FXMDIWindowButton::FXMDIWindowButton(FXComposite* p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXMenuButton(p,NULL,NULL,NULL,opts,x,y,w,h,0,0,0,0){
  tip="Menu";
  target=tgt;
  message=sel;
  }


FXint FXMDIWindowButton::getDefaultWidth(){
  FXint w=icon?icon->getWidth():MENUBUTTONWINDOW_WIDTH;
  return padleft+padright+(border<<1)+w;
  }


FXint FXMDIWindowButton::getDefaultHeight(){
  FXint h=icon?icon->getHeight():MENUBUTTONWINDOW_HEIGHT;
  return padtop+padbottom+(border<<1)+h;
  }


// Handle repaint
long FXMDIWindowButton::onPaint(FXObject*,FXSelector,void* ptr){
  FXEvent *ev=(FXEvent*)ptr;
  FXDCWindow dc(this,ev);
  FXint ix,iy,iw,ih;
  dc.setForeground(backColor);
  dc.fillRectangle(ev->rect.x,ev->rect.y,ev->rect.w,ev->rect.h);
  drawFrame(dc,0,0,width,height);
  if(icon){
    iw=icon->getWidth();
    ih=icon->getHeight();
    }
  else{
    iw=MENUBUTTONWINDOW_WIDTH;
    ih=MENUBUTTONWINDOW_HEIGHT;
    }
  ix=(width-iw)/2;
  iy=(height-ih)/2;
  if(state){ ++ix; ++iy; }
  if(icon){
    dc.drawIcon(icon,ix,iy);
    }
  else{
    dc.setForeground(shadowColor);
    dc.drawLine(ix,iy,MENUBUTTONWINDOW_WIDTH-1,iy);
    dc.drawLine(ix,iy,ix,MENUBUTTONWINDOW_HEIGHT-1);
    dc.drawLine(ix,iy+MENUBUTTONWINDOW_HEIGHT-2,ix+MENUBUTTONWINDOW_WIDTH-2,iy+MENUBUTTONWINDOW_HEIGHT-2);
    dc.drawLine(ix+1,iy+4,ix+MENUBUTTONWINDOW_WIDTH-2,iy+4);
    dc.drawLine(ix+MENUBUTTONWINDOW_WIDTH-2,iy,ix+MENUBUTTONWINDOW_WIDTH-2,iy+MENUBUTTONWINDOW_HEIGHT-2);
    dc.setForeground(baseColor);
    dc.drawLine(ix+1,iy+1,MENUBUTTONWINDOW_WIDTH-3,iy+1);
    dc.drawLine(ix+1,iy+1,ix+1,MENUBUTTONWINDOW_HEIGHT-3);
    dc.setForeground(textColor);
    dc.drawLine(ix,iy+MENUBUTTONWINDOW_HEIGHT-1,ix+MENUBUTTONWINDOW_WIDTH,iy+MENUBUTTONWINDOW_HEIGHT-1);
    dc.drawLine(ix+MENUBUTTONWINDOW_WIDTH-1,iy,ix+MENUBUTTONWINDOW_WIDTH-1,iy+MENUBUTTONWINDOW_HEIGHT-1);
    dc.drawLine(ix+2,iy+2,ix+MENUBUTTONWINDOW_WIDTH-2,iy+2);
    dc.drawLine(ix+2,iy+3,ix+MENUBUTTONWINDOW_WIDTH-2,iy+3);
    dc.setForeground(hiliteColor);
    dc.fillRectangle(ix+2,iy+5,MENUBUTTONWINDOW_WIDTH-4,MENUBUTTONWINDOW_HEIGHT-7);
    dc.drawPoint(ix+MENUBUTTONWINDOW_WIDTH-4,iy+3);
    dc.drawPoint(ix+MENUBUTTONWINDOW_WIDTH-6,iy+3);
    dc.drawPoint(ix+MENUBUTTONWINDOW_WIDTH-8,iy+3);
    }
  return 1;
  }




/*******************************************************************************/


// Object implementation
FXIMPLEMENT(FXMDIMenu,FXMenuPane,NULL,0)


// Convenience constructor
FXMDIMenu::FXMDIMenu(FXWindow *owner,FXObject* tgt):FXMenuPane(owner){
  closeicon=new FXGIFIcon(getApp(),winclose);
  maximizeicon=new FXGIFIcon(getApp(),winmaximize);
  minimizeicon=new FXGIFIcon(getApp(),winminimize);
  restoreicon=new FXGIFIcon(getApp(),winrestore);
  new FXMenuCommand(this,"&Next\t\tNext window.",NULL,tgt,FXWindow::ID_MDI_NEXT,0);
  new FXMenuCommand(this,"&Previous\t\tPrevious window.",NULL,tgt,FXWindow::ID_MDI_PREV,0);
  new FXMenuCommand(this,"&Restore\t\tRestore window.",restoreicon,tgt,FXWindow::ID_MDI_RESTORE,0);
  new FXMenuCommand(this,"&Minimize\t\tMinimize window.",minimizeicon,tgt,FXWindow::ID_MDI_MINIMIZE,0);
  new FXMenuCommand(this,"&Maximize\t\tMaximize window.",maximizeicon,tgt,FXWindow::ID_MDI_MAXIMIZE,0);
  new FXMenuCommand(this,"&Close\t\tClose window.",closeicon,tgt,FXWindow::ID_MDI_CLOSE,0);
  }


// Clean up
FXMDIMenu::~FXMDIMenu(){
  delete closeicon;
  delete maximizeicon;
  delete minimizeicon;
  delete restoreicon;
  closeicon=(FXIcon*)-1;
  maximizeicon=(FXIcon*)-1;
  minimizeicon=(FXIcon*)-1;
  restoreicon=(FXIcon*)-1;
  }

