/*
  Copyright 2005, 2006, 2007 David Cad, Damien Stehl.

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; see the file COPYING.  If not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  This program implements ideas from the paper "Floating-point LLL Revisited", 
  by Phong Nguyen and Damien Stehl, in the Proceedings of Eurocrypt'2005, 
  Springer-Verlag; and was partly inspired by Shoup's NTL library: 
  http://www.shoup.net/ntl/

*/

#ifndef WRAPPER_H
#define WRAPPER_H

#include "nr.h"
#include "matrix.h"

#define TDOUBLE 1
#define TDPE 2
#define TMPFR 3

class wrapper
{
  double eta,delta;
  int max_exp;
  int dim;
  int prec;
  ZZ_mat<mpz_t>*B1;
  ZZ_mat<long int>*B2;
  bool fast_int,heuristic_int,proved_int;
  int fl_use;

  bool little(int kappa,int precision);
  int heuristicLoop(int precision);
  int provedLoop(int precision);
  int LastLLL();

public:
  wrapper(ZZ_mat<mpz_t>*B,int precision=0,double eta=0.51,double delta=0.99);
  int LLL();
  ZZ_mat<mpz_t>*GetBase(){return B1;};
};


#include "wrapper.cpp"

#endif

