#!/usr/bin/perl
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..1\n"; }
END {print "not ok 1\n" unless $loaded;}
use FreeDB;
$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):


my $cd = new FreeDB;

if ($cd->fetch) {
   print "fetch: ok\n";
}
else {
   print "fetch: FAIL\n";
}

print "DB Server is:       " . $cd->cddb_server       . "\n";
print "DB Cache dir is:    " . $cd->cache_directory   . "\n";
print "CDROM Device is:    " . $cd->cdrom_device      . "\n";

print "...\n";

print "Artist is:          " . $cd->artist            . "\n";
print "Title is:           " . $cd->title             . "\n";
print "Discinfo is:        " . $cd->disc_info         . "\n";
print "Discid is:          " . $cd->discid            . "\n";
print "Disc_length is:     " . $cd->disc_length       . "\n";
print "Total tracks are:   " . $cd->total_tracks      . "\n";

print "\n#######################################################\n";

print "Tracks are:\n";
print join("\n", $cd->track_info);

print "\n#######################################################\n";

print "Offsets are:\n";
print join("\n", $cd->offsets);

print "\n#######################################################\n";

print "Extended Tracks are:\n";
print join("\n", $cd->extended_track_info);

print "\n#######################################################\n";

print "Detailed Tracks are:\n";
print join("\n", $cd->detailed_track_info);

print "\n#######################################################\n";

while ($cd->next_track) {
   print $cd->current_track_number_padded, ". ";
   print $cd->current_track_info, " (";
   print $cd->current_track_time_in_minutes, ")\n";
}

#  while ($cd->next_track) {
#     print "TRACK #       :", $cd->current_track_number, "\n";
#     print "TRACK # pad   :", $cd->current_track_number_padded, "\n";
#     print "TRACK info    :", $cd->current_track_info, "\n";
#     print "TRACK ext info:", $cd->current_track_extended_info, "\n";
#     print "TRACK:det info:", $cd->current_track_detailed_info, "\n";
#     print "TRACK:time min:", $cd->current_track_time_in_minutes, "\n";
#     print "TRACK:time sec:", $cd->current_track_time_in_seconds, "\n";
#     print "TRACK:offset  :", $cd->current_track_offset, "\n";
#     print "\n-------------------------------------------------------\n";
#  }


print "\nDone.\n";

