#!/usr/bin/env python
# -*- coding: UTF-8 -*-

#Copyright (C) 2005 Steven Grafton

#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

import pygtk
import gtk
import BitTorrent
import BitTorrent.download
import genericdl
import urllib
import threading
import os
import os.path

class BTDL(genericdl.GenericDL):
	def __init__(self, upt, downt, maxup, lowport,
			highport, address, *args):
		self.upRate = self.downRate = 0
		self.upTotal = self.downTotal = 0
		self.initUp = upt
		self.initDown = downt
		self.maxup = maxup
		self.lowport = lowport
		self.highport = highport
		self.address = address
		genericdl.GenericDL.__init__(self, *args)

	def please_exit(self):
		self.upRate = 0
		self.downRate = 0
		if not self.killflag.isSet():
			self.killflag.set()

	def build_markup(self):
		# progress is taken care of, just display vital stats
		# dest, downspeed, upspeed, totals?
		(h, t) = os.path.split(self.get_fullfile())
		if self.done:
			lowerline = self.status + self.escaped_markup(h) + "\n" + "Download: " + self.format(self.downRate)+ "/sec (" + self.format(self.downTotal + self.initDown) +") Upload: " +self.format(self.upRate)+ "/sec (" + self.format(self.upTotal + self.initUp) + ")"
		else:
			lowerline = self.status + " - " + self.escaped_markup(h) + "\n" + "Download: " + self.format(self.downRate)+ "/sec (" + self.format(self.downTotal + self.initDown) +") Upload: " +self.format(self.upRate)+ "/sec (" + self.format(self.upTotal + self.initUp) + ")"
		return "<b>" + self.escaped_markup(t) + "</b> (" + self.format(self.size_total) + ")\n<small>" + lowerline + "</small>"

	def choose_file(self, default, size, saveas, dir):
		#dir if dl is a directory
		self.size_total = size
		return self.des_file

	def hook(self, dict = {}):
		fractionDone = dict.get('fractionDone', None)
		timeEst = dict.get('timeEst', None)
		downRate = dict.get('downRate', None)
		upRate = dict.get('upRate', None)
		downTotal = dict.get('downTotal', None) #download megs, float
		upTotal = dict.get('upTotal', None) #upload megs, float
		activity = dict.get('activity', None)

		if self.killflag.isSet():
			self.upRate = 0
			self.downRate = 0
			return

		if activity is not None and not self.done:
			self.status = activity
		elif timeEst is not None:
			self.status = 'Downloading'
		if timeEst is not None and not self.done:
			self.time_est = timeEst
		if fractionDone is not None and not self.done:
			self.progress = int(fractionDone * 100)
			self.progress = max(0, min(100, self.progress))
		if downRate is not None:
			self.downRate = downRate
		if upRate is not None:
			self.upRate = upRate
		if upTotal is not None:
			self.upTotal = upTotal * (1024 * 1024)
		if downTotal is not None:
			self.downTotal = downTotal * (1024 * 1024)

		self.update_fields()

	def error(self, errormsg):
		gtk.gdk.threads_enter()
		self.print_log(errormsg, gtk.STOCK_DIALOG_ERROR)
		gtk.gdk.threads_leave()

	def finished(self):
		self.downRate = 0
		self.completed()
		gtk.gdk.threads_enter()
		self.print_log("Completed Torrent: " + self.get_tail(),
				"arrows-up")
		gtk.gdk.threads_leave()

	def run(self):
		args = ()

		if self.address is not None:
			args += ("--ip", self.address)

		if self.lowport is not None:
			args += ("--minport", self.lowport)

		if self.highport is not None:
			args += ("--maxport", self.highport)

		if self.maxup is not None:
			args += ("--max_upload_rate", self.maxup)

		args += ("--saveas", self.des_file, self.src_file)

		gtk.gdk.threads_enter()
		self.print_log("Starting Torrent: " + self.get_tail(),
				"arrows-down-up")
		gtk.gdk.threads_leave()

		try:
			BitTorrent.download.download(	args,
							self.choose_file,
							self.hook,
							self.finished,
							self.error,
							self.killflag,
							20)
		except:
			#there are non fatal exceptions?
			gtk.gdk.threads_enter()
			self.print_log("Error in Torrent thread",
					gtk.STOCK_DIALOG_ERROR)
			gtk.gdk.threads_leave()

		if self.killflag.isSet():
			self.downRate = 0
			self.completed()
			gtk.gdk.threads_enter()
			self.print_log("Stopped Torrent: " + self.get_tail(),
					gtk.STOCK_DIALOG_INFO)
			gtk.gdk.threads_leave()

