#!/usr/bin/env python
# -*- coding: UTF-8 -*-

#Copyright (C) 2005 Steven Grafton

#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

import threading
import pygtk
pygtk.require('2.0')
import gtk
import gtk.gdk
import gnome
import gnome.ui
import os
import os.path
import commands

def format(num):
	num = float(num)
	tail = "bytes"
	if num > 1024:
		tail = "kb"
		num = num / 1024.0
		if num > 1024:
			num = num / 1024.0
			tail = "mb"
			if num > 1024:
				num = num / 1024.0
				tail = "gb"

	return '%.1f %s' % (num, tail)

class GenericDL(threading.Thread):
	def __init__(self, store, row, src, des, final, watch_func, print_func):
		self.size_total = 0
		self.progress = 0
		self.iter = row
		self.store = store
		self.killflag = threading.Event()
		self.des_file = des
		self.src_file = src
		self.watch_func = watch_func
		self.print_log = print_func
		self.completed_ev = threading.Event()
		(head, self.file) = os.path.split(des)
		if final is not None:
			self.final_file = os.path.join(final, self.file)
		else:
			self.final_file = final
		self.done = 0
		self.mime_pb = None
		self.time_est = None
		self.last_update = 0
		self.status = 'Connecting... Saving file to '
	#	self.store.set(self.iter, 0, None)
		self.store.set(self.iter, 1, self.build_markup())
		self.store.set(self.iter, 2, self.progress)
		self.store.set(self.iter, 3, self)
		threading.Thread.__init__(self)

	def get_fullfile(self):
		return self.des_file

	def get_dir(self):
		(ret, tail) = os.path.split(self.get_fullfile())
		return ret

	def get_tail(self):
		(ret, tail) = os.path.split(self.get_fullfile())
		return tail

	def escaped_markup(self, data):
		res = data.replace("&", "&amp;") 
		res = res.replace(">", "&gt;") 
		return res.replace("<", "&lt;")

	def format_time(self):
		if self.time_est < 1:
			if self.progress > 0 and self.progress < 100:
				return str(self.progress) + " %"
			elif self.progress == 100:
				return "Done"
			elif self.time_est == 0:
				return "Done"
			return "???"
		min, sec = divmod(self.time_est, 60)
		hrs, min = divmod(min, 60)
		if hrs > 1000:
			return "???"
		return '%d:%02d:%02d left' % (hrs, min, sec)

	def format(self, num):
		num = float(num)
		tail = "bytes"
		if num > 1024:
			tail = "kb"
			num = num / 1024.0
			if num > 1024:
				num = num / 1024.0
				tail = "mb"
				if num > 1024:
					num = num / 1024.0
					tail = "gb"

		return '%.1f %s' % (num, tail)

	def update_fields(self):
		try:
			gtk.gdk.threads_enter()
			if gtk.main_level() == 0:
				gtk.gdk.threads_leave()
				return
			self.store.set(self.iter, 1, self.build_markup())
			self.store.set(self.iter, 2, max(0, self.progress))
			self.store.set(self.iter, 4, self.format_time())
			gtk.gdk.threads_leave()
		except:
			self.print_log("Problem updating fields! in thread: " + str(self))
			gtk.gdk.threads_leave()

	def completed(self):
		if self.completed_ev.isSet():
			self.update_fields()
			return

		self.completed_ev.set()

		gtk.gdk.threads_enter()
		(width,height) = gtk.icon_size_lookup(gtk.ICON_SIZE_DND)
		gtk.gdk.threads_leave()
		self.done = 1

		if self.killflag.isSet() and self.progress < 100:
			self.status = 'Download aborted in '
			self.time_est = -1
			#self.mime_pb = gtk.gdk.pixbuf_new_from_file_at_size(
			#				"freeloader_error.svg",
			#				width,
			#				height)
		else:
			self.status = 'Download completed in '
			self.progress = 100
			self.time_est = 0

			gtk.gdk.threads_enter()
			theme = gtk.icon_theme_get_default()
			fact = gnome.ui.ThumbnailFactory(
					gnome.ui.THUMBNAIL_SIZE_NORMAL)
			iname = gnome.ui.icon_lookup(theme,	fact,
								self.des_file,
								"")
			#pb = theme.load_icon(iname[0], height, 0)
			gtk.gdk.threads_leave()
			self.mime_pb = iname[0]
				
			if self.final_file:
				try:
				
					# fixme: possible bug with specially
					# formed urls
					cmd = "mv \'" + self.des_file + \
						"\' \'" + self.final_file + \
						"\'"
					res = commands.getstatusoutput(cmd)
				#	os.renames(self.des_file,
				#			self.final_file)
					if res[0] != 0:
						raise
					self.des_file = self.final_file
				except:
					#sec reasons, no move across vols
					gtk.gdk.threads_enter()
					self.print_log('Error moving %s to final %s.' % (self.des_file, self.final_file), gtk.STOCK_DIALOG_ERROR)
					self.print_log(cmd[1])
					gtk.gdk.threads_leave()

		try:
			self.watch_func(self.des_file, self.iter)
		except:
			gtk.gdk.threads_enter()
			self.print_log("Error Watching " + self.des_file,
					gtk.STOCK_DIALOG_ERROR)
			gtk.gdk.threads_leave()
		# disable buttons against self when kill pushed
		# this means one download was highlighted at least
		self.update_fields()

	def please_exit(self):
		return

	def run(self):
		return


