% ACOTD ACOTD Inverse Cotangent Degrees Function
% 
% Usage
% 
% Computes the inverse cotangent of its argument in degrees.  The general
% syntax for its use is
% 
%   y = acotd(x)
% 
% where x is an n-dimensional array of numerical type.


% Copyright (c) 2002-2007 Samit Basu
% Licensed under the GPL

function y = acotd(x)
  if (nargin == 0 || ~isnumeric(x) || ~isreal(x))
    error('acot expects a single, real numeric input');
  end
  y = rad2deg(acot(x));
  
  
