package freenet.fs.dir;

import java.io.IOException;
import java.util.Enumeration;

/**
 * This is an application-level interface to the file-system.
 * @author tavin
 */
public interface Directory {

    /**
     * @return  an Object to synchronize on when doing
     *          multiple directory operations
     */
    Object semaphore();

    /**
     * @return  true, if files have been deleted or
     *          committed.  a flush() must be performed
     *          for this to revert to false.
     */
    boolean dirty();
    
    /**
     * Resyncs the on-disk accounting tables.
     * 
     * @return  0, if the tables were flushed.
     *          FIXME: explain this..
     */
    long flush() throws IOException;

    /**
     * @return  the amount of free bytes left
     */
    long available();

    /**
     * @return  the size of the largest single, intact Fragment
     */
    //long largest();

    /**
     * @param ascending  true for ascending order
     * 
     * @return  an Enumeration of FileNumber keys in order
     */
    Enumeration keys(boolean ascending);

    /**
     * @param fn         the starting point for the enumeration
     * @param inclusive  true to include fn
     * @param ascending  true for ascending order
     * 
     * @return  an Enumeration of FileNumber keys in order
     */
    //Enumeration keys(FileNumber fn, boolean inclusive, boolean ascending);
    Enumeration keys(FilePattern pat);

    /**
     * @param ascending  true for ascending order (oldest first)
     * @return  an Enumeration of FileNumber keys from oldest to newest,
     *          or vice versa
     */
    Enumeration lruKeys(boolean ascending);

    /**
     * Deletes a file.
     * @return  true, if a file was deleted
     */
    boolean delete(FileNumber fn);

    /**
     * @return  true, if the file exists
     */
    boolean contains(FileNumber fn);
    
    /**
     * Accesses a file.
     * @return  a Buffer for that file,
     *          or null if not found
     */
    Buffer fetch(FileNumber fn);

    /**
     * Creates a new file.
     * @param size  the size of the file
     * @param fn    the key
     * @return  the created Buffer, or null
     *          if there was insufficient storage space
     */
    Buffer store(long size, FileNumber fn);

    /**
     * Drop the least-recently-used file.
     * @return  false, if nothing could be deleted
     */
    //boolean drop();
}
    


