package freenet.interfaces.servlet;

import freenet.FieldSet;
import freenet.node.Node;
import freenet.support.Logger;
import freenet.client.ClientFactory;
import freenet.config.*;
import javax.servlet.*;

/**
 * A simple container for running only one servlet on an interface.
 * @author tavin
 */
public class SingleHttpServletContainer extends HttpServletContainer {

    private final Class cls;
    private ServletPool servletPool;
    

    /**
     * In-process.
     */
    public SingleHttpServletContainer(Node node, Class cls) {
        super(node);
        this.cls = cls;
    }

    /**
     * Out-of-process.
     */
    public SingleHttpServletContainer(Logger logger,
                                      ClientFactory factory,
                                      Class cls) {
        super(logger, factory);
        this.cls = cls;
    }


    public final Config getConfig() {
        return new Config();
    }

    public final void init(Params params) {
        ServletContext context = createServletContext(new FieldSet());
        ServletConfig config = createServletConfig(context, cls.getName(), params);
        servletPool = new SimpleServletPool(cls, context, config);
    }

    

    public final String getContextPath(String uripath) {
        return "";
    }
    
    public final String getServletPath(String uripath) {
        return "/";
    }

    public final String getPathInfo(String uripath) {
        return uripath.length() > 1
            ? uripath.substring(1, uripath.length())
            : null;
    }
    

    public final ServletContext getContext(String uripath) {
        return servletPool.getServletContext();
    }
    

    protected final ServletPool getServletPool(String uripath) {
        return servletPool;
    }
}




