package freenet.node.rt;

import freenet.support.StringMap;
import freenet.Key;

class SimpleRTDiagSnapshot implements RTDiagSnapshot {

    private StringMap table = null;
    private StringMap[] refs = null;
    private Key[] keys = null;

    SimpleRTDiagSnapshot(StringMap table,
                         StringMap[] refs,
                         Key[] keys) {
        this.table = table;
        this.refs = refs;
        this.keys = keys;
    }

    public final StringMap tableData() { 
        // const interface, don't need to copy.
        return table; 
    }

    public final StringMap[] refData() { 
        if (refs == null) {
            return new StringMap[0];
        }

        StringMap[] ret = new StringMap[refs.length];
        System.arraycopy(refs, 0, ret, 0, ret.length);
        return ret;
    }

    public final Key[] keys() {
        if (keys == null) {
            return new Key[0];
        }

        Key[] ret = new Key[keys.length];
        System.arraycopy(keys, 0, ret, 0, ret.length);
        return ret;
    }
}












