package freenet.session;

import java.math.BigInteger;
import freenet.crypt.*;
import freenet.crypt.ciphers.Rijndael;
import freenet.*;

import java.io.*;
import freenet.crypt.*;

public interface Link {

    /**
     * Returns the links InputStream.
     */
    public InputStream getInputStream();

    /**
     * Returns the links OutputStream.
     */
    public OutputStream getOutputStream();

    /**
     * Close this link.
     */
    public void close() throws IOException;

    /**
     * Set the timeout on reading from this Link.
     */
    public void setTimeout(int timeout) throws IOException;

    /**
     * Returns the current timeout on reading from this Link.
     */
    public int getTimeout() throws IOException;

    /**
     * Returns the address to the me, with the given ListeningAddress.
     */
    public Address getMyAddress(ListeningAddress lstaddr) 
        throws BadAddressException;

    /**
     * Returns the address to me, with the ListeningAddress this Link
     * was received on (when called on outgoing connections behaviour is
     * unspecified).
     */
    public Address getMyAddress();

    /**
     * Returns the address to the peer, with the given ListeningAddress.
     */
    public Address getPeerAddress(ListeningAddress lstaddr) 
        throws BadAddressException;

    /**
     * Returns the address to the peer, with the ListeningAddress this Link
     * was received on (when called on incoming connections behaviour is
     * unspecified).
     */ 
    public Address getPeerAddress();


    /**
     * Returns ones own identity.
     */
    public Identity getMyIdentity();

    /**
     * Returns the identity of the peer.
     */
    public Identity getPeerIdentity();

    /**
     * Returns the manager of this link
     */
    public LinkManager getManager();

    /**
     * Returns true if the Link is currently ferrying outbound data
     */
    //public boolean sending();

}


