package freenet.thread;

/**
 * This is more convenient than using a ThreadManager for some purposes.
 * It is generally assumed that thread pooling is taking place and that
 * getThread() might return null if the underlying pool is out of threads.
 * @author tavin
 */
public interface ThreadFactory {

    /**
     * @return  the number of available threads at this instant
     *          (may be negative if getThread() was used with force)
     */
    int availableThreads();

    /**
     * @return  the number of currently executing threads
     */
    int activeThreads();

    /**
     * @param r      the job to encapsulate
     * @param force  true to create a new thread if out of threads
     * @return  a thread that when started will run the given Runnable,
     *          or null if !force && availableThreads() <= 0
     *
     * The returned Thread will have an implementation-dependent name,
     * but it can safely be overridden with Thread.setName().
     */
    Thread getThread(Runnable r, boolean force);
}


