/*  Copyright (C) 1999-2004 University of Oxford  */

/*  CCOPYRIGHT */

#include "options.h"

namespace Utilities {

  bool string_to_T(bool &b, const string& s) {
    if(s.length() == 0)
      {
	b = !b;
	return true;
      }
    else if (s == "true")
      {
	b = true;
	return true;
      }
    else if (s == "false")
      {
	b = false;
	return true;
      }
    else
      return false;
  }

  bool string_to_T(string& d, const string& s) {
    d = s;
    return true;
  }

  bool string_to_T(int& i, const string& s) {
    char *endptr = 0; const char *str = s.c_str();
    i = strtol(str, &endptr, 0);
    if(*endptr == str[s.length()])
      return true;
    else
      return false;
  }

  bool string_to_T(float& v, const string& s) {
    char *endptr = 0; const char *str = s.c_str();
    v = strtod(str, &endptr);
    if(*endptr == str[s.length()])
      return true;
    else
      return false;
  }

  bool string_to_T(vector<int>& vi, const string& s) {
    string str(s), delin(",");
    if(str.find(":")!=string::npos)
      delin = ":";
    str=str+delin;
    vi.clear();
    while(str.size()) {
      int v = atoi(str.substr(0,str.find(delin)).c_str());
      vi.push_back(v);
      str = str.substr(str.find(delin)+1,str.length()-str.find(delin)-1);
    }
    return true;
  }

  bool string_to_T(vector<float>& vi, const string& s) {
    string str(s), delin(",");
    if(str.find(":")!=string::npos)
      delin = ":";
    str=str+delin;
    vi.clear();
    while(str.size()) {
      float v = atof(str.substr(0,str.find(delin)).c_str());
      vi.push_back(v);
      str = str.substr(str.find(delin)+1,str.length()-str.find(delin)-1);
    }
    return true;
  }

  bool string_to_T(vector<string>& vi, const string& s) {
    string str(s), delin(",");
    if(str.find(":")!=string::npos)
      delin = ":";
    str=str+delin;
    vi.clear();
    while(str.size()) {
      string v = str.substr(0,str.find(delin));
      vi.push_back(v);
      str = str.substr(str.find(delin)+1,str.length()-str.find(delin)-1);
    }
    return true;
  }

  ostream& operator<<(ostream &os, const BaseOption& o) {
    string test=o.help_text();
    if ((test.length()>=1) && (test[0]=='~')) {
      test[0]=' ';
      return os << "\t" << o.key() << test;
    } else {
      return os << "\t" << o.key() << "\t" << o.help_text();
    }
  }

}
