###############################################################################
#
#       Copyright (C) 1997-2001 Claus Heine.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
# $RCSfile: Rules.make,v $
# $Revision: 1.20 $
# $Date: 2001/08/10 19:08:28 $
#
#     Makefile rules for the QIC-40/80/3010/3020 ftape driver
#
#     This is a modified version of that Rules.make file that is
#     distributed with the LInux kernel, hacked to work with the
#     separate ftape source tree.
#
###############################################################################
#
# This file contains rules which are shared between multiple Makefiles.
#

#
# False targets.
#
.PHONY: dummy

#
# Special variables which should not be exported
#
unexport EXTRA_AFLAGS
unexport EXTRA_CFLAGS
unexport EXTRA_LDFLAGS
unexport EXTRA_ARFLAGS
unexport SUBDIRS
unexport SUB_DIRS
unexport ALL_SUB_DIRS
unexport MOD_SUB_DIRS
unexport O_TARGET
unexport ALL_MOBJS

unexport obj-y
unexport obj-m
unexport obj-n
unexport obj-
unexport export-objs
unexport subdir-y
unexport subdir-m
unexport subdir-n
unexport subdir-

#
# Get things started.
#
first_rule all: sub_dirs modules
	$(MAKE) all_targets

both-m          := $(filter $(mod-subdirs), $(subdir-y))
SUB_DIRS	:= $(subdir-y)
MOD_SUB_DIRS	:= $(sort $(subdir-m) $(both-m))
ALL_SUB_DIRS	:= $(sort $(subdir-y) $(subdir-m) $(subdir-n) $(subdir-))


#
# Common rules
#

%.s: %.c $(TOPDIR)/MCONFIG $(LINUX_LOCATION)/.config \
		$(TOPDIR)/include/linux/autoconf.h \
		$(TOPDIR)/Makefile Makefile
	$(CC) $(CFLAGS) $(EXTRA_CFLAGS) $(CFLAGS_$@) -S $< -o $@

%.i: %.c $(TOPDIR)/MCONFIG $(LINUX_LOCATION)/.config \
		$(TOPDIR)/include/linux/autoconf.h \
		$(TOPDIR)/Makefile Makefile
	$(CPP) $(CFLAGS) $(EXTRA_CFLAGS) $(CFLAGS_$@) $< > $@

%.o: %.c $(TOPDIR)/MCONFIG $(LINUX_LOCATION)/.config \
		$(TOPDIR)/include/linux/autoconf.h \
		$(TOPDIR)/Makefile Makefile
	$(CC) $(CFLAGS) $(EXTRA_CFLAGS) $(CFLAGS_$@) -c -o $@ $<
	@ ( \
	    echo 'ifeq ($(strip $(subst $(comma),:,$(CFLAGS) $(EXTRA_CFLAGS) $(CFLAGS_$@))),$$(strip $$(subst $$(comma),:,$$(CFLAGS) $$(EXTRA_CFLAGS) $$(CFLAGS_$@))))' ; \
	    echo 'FILES_FLAGS_UP_TO_DATE += $@' ; \
	    echo 'endif' \
	) > $(dir $@)/.$(notdir $@).flags

%.o: %.s $(TOPDIR)/MCONFIG $(LINUX_LOCATION)/.config \
		$(TOPDIR)/include/linux/autoconf.h \
		$(TOPDIR)/Makefile Makefile
	$(AS) $(AFLAGS) $(EXTRA_CFLAGS) -o $@ $<

.%.d: %.c $(TOPDIR)/MCONFIG $(LINUX_LOCATION)/.config \
		$(TOPDIR)/include/linux/autoconf.h \
		$(TOPDIR)/Makefile Makefile
	-@set -e ; \
	$(CC) -M $(CPPFLAGS) $< | sed 's/\($*\.o\):/\1 $@:/g' > $@

# Old makefiles define their own rules for compiling .S files,
# but these standard rules are available for any Makefile that
# wants to use them.  Our plan is to incrementally convert all
# the Makefiles to these standard rules.  -- rmk, mec
ifdef USE_STANDARD_AS_RULE

%.s: %.S $(TOPDIR)/MCONFIG $(LINUX_LOCATION)/.config \
		$(TOPDIR)/include/linux/autoconf.h \
		$(TOPDIR)/Makefile Makefile
	$(CPP) $(AFLAGS) $(EXTRA_AFLAGS) $(AFLAGS_$@) $< > $@

%.o: %.S $(TOPDIR)/MCONFIG $(LINUX_LOCATION)/.config \
		$(TOPDIR)/include/linux/autoconf.h \
		$(TOPDIR)/Makefile Makefile
	$(CC) $(AFLAGS) $(EXTRA_AFLAGS) $(AFLAGS_$@) -c -o $@ $<

endif

%.lst: %.c $(TOPDIR)/MCONFIG $(LINUX_LOCATION)/.config \
		$(TOPDIR)/include/linux/autoconf.h \
		$(TOPDIR)/Makefile Makefile
	$(CC) $(CFLAGS) $(EXTRA_CFLAGS) $(CFLAGS_$@) -g -c -o $*.o $<
	$(TOPDIR)/scripts/makelst $* $(TOPDIR) $(OBJDUMP)
#
#
#
all_targets: $(O_TARGET) $(L_TARGET)

#
# Rule to compile a set of .o files into one .o file
#
ifdef O_TARGET
$(O_TARGET): $(obj-y)
	rm -f $@
    ifneq "$(strip $(obj-y))" ""
	$(LD) $(EXTRA_LDFLAGS) -r -o $@ $(filter $(obj-y), $^)
    else
	$(AR) rcs $@
    endif
	@ ( \
	    echo 'ifeq ($(strip $(subst $(comma),:,$(EXTRA_LDFLAGS) $(obj-y))),$$(strip $$(subst $$(comma),:,$$(EXTRA_LDFLAGS) $$(obj-y))))' ; \
	    echo 'FILES_FLAGS_UP_TO_DATE += $@' ; \
	    echo 'endif' \
	) > $(dir $@)/.$(notdir $@).flags
endif # O_TARGET

#
# Rule to compile a set of .o files into one .a file
#
ifdef L_TARGET
$(L_TARGET): $(obj-y)
	rm -f $@
	$(AR) $(EXTRA_ARFLAGS) rcs $@ $(obj-y)
	@ ( \
	    echo 'ifeq ($(strip $(subst $(comma),:,$(EXTRA_ARFLAGS) $(obj-y))),$$(strip $$(subst $$(comma),:,$$(EXTRA_ARFLAGS) $$(obj-y))))' ; \
	    echo 'FILES_FLAGS_UP_TO_DATE += $@' ; \
	    echo 'endif' \
	) > $(dir $@)/.$(notdir $@).flags
endif

#
# A rule to make subdirectories
#
subdir-list = $(sort $(patsubst %,_subdir_%,$(SUB_DIRS)))
sub_dirs: dummy $(subdir-list)

ifdef SUB_DIRS
$(subdir-list) : dummy
	$(MAKE) -C $(patsubst _subdir_%,%,$@)
endif

#
# A rule to do nothing
#
dummy:

#
# A rule to make modules
#
ALL_MOBJS = $(filter-out $(obj-y), $(obj-m))

unexport MOD_DIRS
MOD_DIRS := $(MOD_SUB_DIRS) $(MOD_IN_SUB_DIRS)
ifneq "$(strip $(MOD_DIRS))" ""
.PHONY: $(patsubst %,_modsubdir_%,$(MOD_DIRS))
$(patsubst %,_modsubdir_%,$(MOD_DIRS)) : versions dummy
	$(MAKE) -C $(patsubst _modsubdir_%,%,$@) modules

.PHONY: $(patsubst %,_modinst_%,$(MOD_DIRS))
$(patsubst %,_modinst_%,$(MOD_DIRS)) : dummy
	$(MAKE) -C $(patsubst _modinst_%,%,$@) modules_install
endif

.PHONY: modules versions
modules: $(ALL_MOBJS) dummy \
	 $(patsubst %,_modsubdir_%,$(MOD_DIRS))
ifneq "$(strip $(ALL_MOBJS))" ""
	ln -f $(ALL_MOBJS) $(TOPDIR)/modules/
endif

versions:: $(TOPDIR)/include/linux/modftversions.h $(TOPDIR)/include/linux/autoconf.h
ifdef MOD_SUB_DIRS
	for i in $(MOD_SUB_DIRS); \
	do \
	  $(MAKE) -C $$i NODEP=true versions; \
	done
endif

install:: modules
ifneq "$(strip $(ALL_MOBJS))" ""
	$(INSTALL) -m 0755 -d $(MODULESDIR)
	for i in $(ALL_MOBJS); \
	do \
	  $(INSTALL) -m 0644 $$(pwd)/$$i $(MODULESDIR); \
	done
endif

uninstall::
ifneq "$(strip $(ALL_MOBJS))" ""
	for i in $(ALL_MOBJS); \
	do \
	  rm -f $(MODULESDIR)/$$i; \
	done
endif

install uninstall::
ifdef MOD_SUB_DIRS
	for i in $(MOD_SUB_DIRS); \
	do \
	  $(MAKE) -C $$i NODEP=true $@; \
	done
endif

#
# A rule to do nothing
#
dummy:

#
# This is useful for testing
#
script:
	$(SCRIPT)

#
# This sets version suffixes on exported symbols
# Separate the object into "normal" objects and "exporting" objects
# Exporting objects are: all objects that define symbol tables
#
ifdef CONFIG_MODULES

multi-used	:= $(filter $(list-multi), $(obj-y) $(obj-m))
multi-objs	:= $(foreach m, $(multi-used), $($(basename $(m))-objs))
active-objs	:= $(sort $(multi-objs) $(obj-y) $(obj-m))

ifdef CONFIG_MODVERSIONS
ifneq "$(strip $(export-objs))" ""

MODINCL = $(TOPDIR)/include/linux/modules

# The -w option (enable warnings) for genksyms will return here in 2.1
# So where has it gone?
#
# Added the SMP separator to stop module accidents between uniprocessor
# and SMP Intel boxes - AC - from bits by Michael Chastain
#

ifdef CONFIG_SMP
	genksyms_smp_prefix := -p smp_
else
	genksyms_smp_prefix := 
endif

$(MODINCL)/%.ver: %.c
	@if [ ! -r $(MODINCL)/$*.stamp -o $(MODINCL)/$*.stamp -ot $< ]; then \
		echo '$(CC) $(GKSFLAGS) -E -D__GENKSYMS__ $<'; \
		echo '| $(GENKSYMS) $(genksyms_smp_prefix) -k $(KERNELRELEASE) > $@.tmp'; \
		$(CC) $(GKSFLAGS) -E -D__GENKSYMS__ $< \
		| $(GENKSYMS) $(genksyms_smp_prefix) -k $(KERNELRELEASE) > $@.tmp; \
		if [ -r $@ ] && cmp -s $@ $@.tmp; then echo $@ is unchanged; rm -f $@.tmp; \
		else echo mv $@.tmp $@; mv -f $@.tmp $@; fi; \
	fi; touch $(MODINCL)/$*.stamp

$(addprefix $(MODINCL)/,$(export-objs:.o=.ver)): $(TOPDIR)/MCONFIG $(LINUX_LOCATION)/include/linux/autoconf.h $(TOPDIR)/include/linux/autoconf.h

$(TOPDIR)/include/linux/modftversions.h: $(addprefix $(MODINCL)/,$(export-objs:.o=.ver))
	@echo updating $(TOPDIR)/include/linux/modftversions.h
	@(echo "#ifndef _FTAPE_MODVERSIONS_H"; \
	  echo "#define _FTAPE_MODVERSIONS_H"; \
	  echo "#include <linux/version.h>"; \
	  echo "#if LINUX_VERSION_CODE <= ((1<<16)+(2<<8)+13)"; \
	  echo "#include <linux/config.h>"; \
	  echo "#include <linux/module.h>"; \
	  echo "#endif" ; \
	  cd $(TOPDIR)/include/linux/modules; \
	  for f in *.ver; do \
	    if [ -f $$f ]; then echo "#include <linux/modules/$${f}>"; fi; \
	  done; \
	  echo "#include <linux/modversions.h>"; \
	  echo "#endif"; \
	) > $@

realclean::
	-rm -f $(addprefix $(MODINCL)/,$(export-objs:.o=.ver))
	-rm -f $(addprefix $(MODINCL)/,$(export-objs:.o=.stamp))

else # export-objs

$(TOPDIR)/include/linux/modftversions.h:
	> $@

endif # export-objs 

$(active-objs): $(TOPDIR)/include/linux/modftversions.h

else

$(TOPDIR)/include/linux/modftversions.h:
	> $@

endif # CONFIG_MODVERSIONS

ifneq "$(strip $(export-objs))" ""
$(export-objs): $(export-objs:.o=.c) $(TOPDIR)/include/linux/modftversions.h
	$(CC) $(CFLAGS) $(EXTRA_CFLAGS) $(CFLAGS_$@) -DEXPORT_SYMTAB -c $(@:.o=.c)
	@ ( \
	    echo 'ifeq ($(strip $(subst $(comma),:,$(CFLAGS) $(EXTRA_CFLAGS) $(CFLAGS_$@) -DEXPORT_SYMTAB)),$$(strip $$(subst $$(comma),:,$$(CFLAGS) $$(EXTRA_CFLAGS) $$(CFLAGS_$@) -DEXPORT_SYMTAB)))' ; \
	    echo 'FILES_FLAGS_UP_TO_DATE += $@' ; \
	    echo 'endif' \
	) > $(dir $@)/.$(notdir $@).flags

$(export-objs:%.o=.%.d): $(export-objs:.o=.c) \
			 $(TOPDIR)/include/linux/modftversions.h \
			 $(TOPDIR)/MCONFIG
	-@set -e ; $(CC) -M $(CPPFLAGS) -DEXPORT_SYMTAB $< | \
	sed 's/\($*\.o\):/\1 $@:/g' > $@

endif

endif # CONFIG_MODULES

$(TOPDIR)/include/linux/autoconf.h:	$(TOPDIR)/MCONFIG \
					$(LINUX_LOCATION)/.config
	echo "#ifndef _FTAPE_AUTOCONF_H_" > $@.new
	echo "#define _FTAPE_AUTOCONF_H_" >> $@.new
	echo -e "\n/* automatically created by make -- do NOT edit */\n" >> $@.new
	echo -e "\n#include_next <linux/autoconf.h>\n" >> $@.new
	rm -f $@.tmp.c
	touch $@.tmp.c
	gcc -E -dM $(CONFIG_OPT) $@.tmp.c | \
		 grep -E '(CONFIG_|MAINTAINER|BROKEN_FLOPPY)' | \
		 awk '{ printf("#undef %s\n%s\n", $$2, $$0); }'  >> $@.new
	rm -f $@.tmp.c
	echo "#endif /* _FTAPE_AUTOCONF_H_ */" >> $@.new
	if ! test -f $@ ; then \
		mv $@.new $@ ; \
	else \
		cmp $@.new $@ > /dev/null || mv -f $@.new $@ ; \
	fi

clean-no-recursion:
	- rm -f *.o *.s core $(PROGS)

clean:: clean-no-recursion
ifdef ALL_SUB_DIRS
	set -e; for i in $(ALL_SUB_DIRS); do 	\
	$(MAKE) -C $$i NODEP=true $@ ; 		\
	done
endif

realclean:: clean-no-recursion
	- rm -f .*.d
	- rm -f .*.flags
	- rm -f $(TOPDIR)/include/linux/modftversions.h
ifdef ALL_SUB_DIRS
	set -e; for i in $(ALL_SUB_DIRS); do 	\
	$(MAKE) -C $$i NODEP=true $@ ; 		\
	done
endif

ALL_SRC = $(obj-m:%.o=%.c) $(obj-y:%.o=%.c) $(export-objs:%.o=%.c) 

install uninstall::
ifdef MOD_SUB_DIRS
	for i in $(MOD_SUB_DIRS); \
	do \
	  $(MAKE) -C $$i NODEP=true $@; \
	done
endif

tags: TAGS

tags-recursive:
	list='$(ALL_SUB_DIRS)'; for subdir in $$list; do \
	  (cd $$subdir && $(MAKE) tags); \
	done

TAGS: tags-recursive $(wildcard *.c) $(wildcard *.h)
	tags=; \
	here=`pwd`; \
	list='$(ALL_SUB_DIRS)'; for subdir in $$list; do \
	  test -f $$subdir/TAGS && tags="$$tags -i $$here/$$subdir/TAGS"; \
	done; \
	list='$(wildcard *.c) $(wildcard *.h)'; \
	unique=`for i in $$list; do echo $$i; done | \
	  awk '    { files[$$0] = 1; } \
	       END { for (i in files) print i; }'`; \
	test -z "$(ETAGS_ARGS)$$unique$(LISP)$$tags" \
	  || (cd $$here && etags $(ETAGS_ARGS) $$tags  $$unique $(LISP) -o $$here/TAGS)

ifneq "$(strip $(ALL_SRC))" ""
ifneq ($(NODEP),true)
-include $(ALL_SRC:%.c=.%.d)
endif
endif

