/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: fwcompiler.h,v 1.37 2001/11/24 04:41:03 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Puplic License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _FWCOMPILER_H_
#define _FWCOMPILER_H_

#include <parser.h>
#include <tree.h>

#include <glib.h>

#define FROMXMLCAST(x) ((const char *)x)
#define TOXMLCAST(x) ((xmlChar *)x)

/*
 *   Our standard IDs :
 */
#define    AnyNetworkId    "sysid0"
#define    AnyIPServiceId  "sysid1"
#define    AnyIntervalId   "sysid2"
    		    
#define    ObjectsId       "stdid01"
#define    HostsId         "stdid02"
#define    NetworksId      "stdid03"
#define    ObjectGroupsId  "stdid04"
#define    ServicesId      "stdid05"
#define    IPServicesId    "stdid06"
#define    ICMPServicesId  "stdid07"
#define    UDPServicesId   "stdid08"
#define    TCPServicesId   "stdid09"
#define    ServiceGroupsId "stdid10"
#define    TimeId          "stdid11"
#define    FirewallsId     "stdid12"

#define    SAME            0

#define    MULTIPORT_NONE  0
#define    MULTIPORT_SRC   1
#define    MULTIPORT_DST   2

typedef struct {
    
    char  *p_src;
    char  *p_sprt;
    char  *p_dst;
    char  *p_dprt;
    
    char  *p_mac_src;  /* source MAC address, if specified */
    
    char  *p_proto;
    
    char  *p_icmp_type;
    char  *p_icmp_code;

    int    state_new;
    char  *p_options;

} triplet;


typedef struct {
    int          num;
    int          subrule_no;
    int          final;
    
    xmlNodePtr src;
    xmlNodePtr dst;
    xmlNodePtr srv;

    xmlNodePtr time;
    
    int          src_neg;
    int          dst_neg;
    int          srv_neg;

    const char  *master_group;
    const char  *p_group;
    const char  *p_action;

    const char  *p_direction;
    const char  *p_iface;
    const char  *p_log;
    const char  *p_time;
    
    triplet     *t;

    int          multiport;

}  elementaryRule;


typedef struct {

    int   num;
    int          subrule_no;

    xmlNodePtr osrc;
    xmlNodePtr odst;
    xmlNodePtr osrv;

    int        osrc_neg;
    int        odst_neg;
    int        osrv_neg;
    
    xmlNodePtr tsrc;
    xmlNodePtr tdst;
    xmlNodePtr tsrv;

    int        tsrc_neg;
    int        tdst_neg;
    int        tsrv_neg;

    const char  *p_iface;
    const char  *p_group;
    const char  *p_action;

    triplet     *o;
    triplet     *t;

}  elementaryNatRule;

extern int debug;
extern int verbose;
extern int turn_off_optimisation;

extern xmlNodePtr AnyNetwork;

extern void* fwb_malloc(int size);
extern void* fwb_realloc(void *ptr,int size);
extern void  fwb_free_mem();
extern char* fwb_strdup(const char* str);
extern void  fwb_mem_set_mark();

extern char*  getNewTemporaryChain();

extern elementaryRule*    createElementaryPolicyRule();
extern elementaryNatRule* createElementaryNatRule();

extern void addOptionCode(triplet *tr,const char* opt);

extern int convertAddress(xmlNodePtr node);
extern int convertNetmask(xmlNodePtr node);
extern int getBroadcastAddress(xmlNodePtr iface);

extern int  isTripletEmpty(triplet *t);

extern int  belongsToNet(xmlNodePtr iface, const char* addr);
extern int  cmpAddress(xmlNodePtr node1,xmlNodePtr node2);
extern int  cmpParameter(const char* p1,const char* p2);
extern int  cmpPolicyRules(elementaryRule *r1,elementaryRule *r2);
extern int  cmpNatRules(elementaryNatRule *r1,elementaryNatRule *r2);
extern int  cmpTriplet(triplet *t1,triplet *t2);
extern int  cmpPPolicyRules(elementaryRule *r1,elementaryRule *r2);
extern int  cmpPNatRules(elementaryNatRule *r1,elementaryNatRule *r2);

#define  getXmlNodeContent(node) \
     FROMXMLCAST( xmlNodeGetContent(node) )
/*
extern char*      getXmlAttribute(xmlNodePtr node,const char* attr_name);
extern char*      getXmlNodeContent(xmlNodePtr node);
*/
extern xmlNodePtr  getFirstChildXmlNode(xmlNodePtr node,
				       const char* child_element_name);

extern const char*       getXmlElementName(xmlNodePtr node);

extern int               isElement(xmlNodePtr node,const char* element_name);
extern int               isReference(xmlNodePtr node);
extern int               isGroup(xmlNodePtr node);
extern int               isAny(xmlNodePtr node);
extern int               isAnyNetwork(xmlNodePtr node);
extern int               isAnyService(xmlNodePtr node);
extern int               isAnyInterval(xmlNodePtr node);
extern int               isCustomService(xmlNodePtr node);

extern int               isDynamicInterface(xmlNodePtr iface);
extern int               isExternalInterface(xmlNodePtr iface);

extern const char*       getId(xmlNodePtr node);
extern const char*       getName(xmlNodePtr node);
extern const char*       getComment(xmlNodePtr node);

extern const char*       getRef(xmlNodePtr node);

extern int         getBool(xmlNodePtr node, const char* attribute);
extern int         getInt(xmlNodePtr node, const char* attribute);
extern const char* getStr(xmlNodePtr node, const char* attribute);

extern void        setStr(xmlNodePtr node,
			  const char* attribute,
			  const char* val);

extern xmlNodePtr  getById(const char* id);

extern xmlNodePtr  resolveReference(xmlNodePtr node);

extern const char* getOptionStr(xmlNodePtr option_object,const char* option_name);
extern int getOptionInt(xmlNodePtr option_object,const char* option_name);
extern int getOptionBool(xmlNodePtr option_object,const char* option_name);

extern int cmpObjects(xmlNodePtr obj1,xmlNodePtr obj2);

/* extern void parsePolicyRule(xmlNodePtr rule,elementaryRule *erule); */

extern char* copyStr(const char* str);
extern void copyElementaryPolicyRule(elementaryRule* r1,elementaryRule* r2);
extern void copyElementaryNatRule(elementaryNatRule* r1,elementaryNatRule* r2);
extern void copyTriplet(triplet *t1,triplet *t2);

/************************************************************************
 *  Implement these functions to produce compiler for new firewall
 *  platform.
 */

extern void prologue(xmlNodePtr firewall,xmlNodePtr fw_options);
extern void epilogue(xmlNodePtr firewall,xmlNodePtr fw_options);

extern void processPolicyRule(xmlNodePtr firewall,
			      xmlNodePtr iface,
			      xmlNodePtr rule,
			      const char *comment,
			      GSList    *subrules);

extern void processNATRule(xmlNodePtr firewall,
			   xmlNodePtr rule,
			   const char *comment,
			   GSList    *subrules);


/**************************************************************************/


#endif







