<!--
  Filename: policy-text.xsl
  Author:  Vadim Kurland
  Build date: 04/23/2001
  Revision:   12/20/2001  
  $Id  $

  Description: translates fwbuilder data file into plain text presentation
               suitable for printing


   12/20/2001:  added namespace; made it work with latest DTD
               

-->


<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fwbuilder="http://www.fwbuilder.org/1.0/"
    version="1.0"
>

<xsl:output method="text"/>
<xsl:strip-space elements="*"/>

<xsl:param name="PrintFrom"/>

<xsl:include href="print-policy.xs1"/>
<xsl:include href="print-nat.xs1"/>

<!-- 
*******************************************************************
* This template finds node in the list with maximum number
* of children nodes
*******************************************************************
-->

<xsl:template name="max_children">
  <xsl:param name="list"/>
  <xsl:param name="max_c"/>
  <xsl:param name="max_n" select="0"/>

  <xsl:choose>
    <xsl:when test="count($list) = 0">
      <xsl:value-of select="name($max_c)"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:variable name="n1" select="count($list[1]/*)"/>
      <xsl:choose>
        <xsl:when test="$n1 > $max_n">
          <xsl:call-template name="max_children">
	    <xsl:with-param name="list"  select="$list[position()!=1]"/>
	    <xsl:with-param name="max_c" select="$list[1]"/>
	    <xsl:with-param name="max_n" select="$n1"/>
	  </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
	  <xsl:call-template name="max_children">
	    <xsl:with-param name="list"  select="$list[position()!=1]"/>
            <xsl:with-param name="max_c" select="$max_c"/>
	    <xsl:with-param name="max_n" select="$max_n"/>
	  </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="fwbuilder:Option"></xsl:template>
<xsl:template match="fwbuilder:FirewallOptions"></xsl:template>
<xsl:template match="fwbuilder:PolicyRuleOptions"></xsl:template>

<xsl:template
    match="fwbuilder:ObjectRef|fwbuilder:ServiceRef|fwbuilder:IntervalRef" 
    mode="rule-element">
<xsl:for-each select="id(@ref)">
<xsl:value-of select="@name"/>
</xsl:for-each>
</xsl:template>



<xsl:template match="fwbuilder:Src|fwbuilder:Dst|fwbuilder:Srv" mode="obj">
  <xsl:param name="p"/>
  <xsl:if test="@neg='True'">! </xsl:if>
  <xsl:apply-templates select="fwbuilder:ObjectRef[$p]"   mode="obj"/>
  <xsl:apply-templates select="fwbuilder:ServiceRef[$p]"  mode="obj"/>
  <xsl:apply-templates select="fwbuilder:IntervalRef[$p]" mode="obj"/>
</xsl:template>



<xsl:template
    match="fwbuilder:ObjectRef|fwbuilder:ServiceRef|fwbuilder:IntervalRef" 
    mode="obj">
  <xsl:for-each select="id(@ref)">
    <xsl:value-of select="@name"/>
  </xsl:for-each>
</xsl:template>



<xsl:template match="fwbuilder:Firewall" mode="node">
-----------------------------------------------------------------
  Firewall

Name:     <xsl:value-of select="@name"/>  
Address:  <xsl:value-of select="@address"/>
Platform: <xsl:value-of select="@platform"/>
Comment:  <xsl:value-of select="@comment"/>

<xsl:apply-templates    mode="fw"/>
</xsl:template>

<xsl:template match="fwbuilder:Host" mode="node">
-----------------------------------------------------------------
  Host

Name:     <xsl:value-of select="@name"/>  
Address:  <xsl:value-of select="@address"/>
Comment:  <xsl:value-of select="@comment"/>

<xsl:apply-templates    mode="fw"/>
</xsl:template>

<xsl:template match="fwbuilder:Interface" mode="fw">

  Interface

Name:     <xsl:value-of select="@name"/>  
<xsl:choose>
  <xsl:when test="@dyn='True'">
Address:  Dynamic
  </xsl:when>       
  <xsl:otherwise>   
Address:  <xsl:value-of select="@address"/>
Netmask:  <xsl:value-of select="@netmask"/>
  </xsl:otherwise>  
</xsl:choose>
Comment:  <xsl:value-of select="@comment"/>

<xsl:apply-templates    mode="fw"/>
</xsl:template>


<xsl:template match="fwbuilder:Option" mode="node"></xsl:template>
<xsl:template match="fwbuilder:Option" mode="firewall"></xsl:template>
<xsl:template match="fwbuilder:Option" mode="fw"></xsl:template>
<xsl:template match="fwbuilder:CustomServiceCommand" mode="node"></xsl:template>
<xsl:template match="fwbuilder:CustomServiceCommand" mode="firewall"></xsl:template>
<xsl:template match="fwbuilder:CustomServiceCommand" mode="fw"></xsl:template>


<xsl:template match="/">


  <xsl:choose>
    <xsl:when test="$PrintFrom">
      <xsl:apply-templates select="id($PrintFrom)" mode="node"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates mode="node"/>
    </xsl:otherwise>
  </xsl:choose>

</xsl:template>

</xsl:stylesheet>




