/* 

                          Firewall Builder

                 Copyright (C) 2001 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: InterfaceListWidget.hh,v 1.4 2001/12/22 22:40:05 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef _INTERFACE_LIST_WIDGET_HH_
#define _INTERFACE_LIST_WIDGET_HH_

#include "config.h"

#include <gtk--.h>

#include "fwbuilder/Interface.hh"

class InterfaceListWidget : public Gtk::CList {

    bool show_addr, show_name, show_netmask, show_ext, show_dyn, show_mac, show_label;
    bool show_security_level;

    public:

    InterfaceListWidget();
    
    void set_show_name(bool onoff);
    void set_show_address(bool onoff);
    void set_show_netmask(bool onoff);
    void set_show_ext(bool onoff);
    void set_show_dyn(bool onoff);
    void set_show_label(bool onoff);
    void set_show_mac(bool onoff);

    void set_show_security_level(bool onoff);

    void addInterface(libfwbuilder::Interface *);

    string  getIdByRow(int row);
    string  getSelectedInterfaceId();

    void    clear();
};


#endif
