/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TCPServiceDialog.cc,v 1.12 2001/12/27 06:48:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "TCPServiceDialog.hh"
#include "fwbuilder/FWObject.hh"
#include "MessageDialog.hh"
#include "helpers.hh"
#include "ttips.hh"

using namespace libfwbuilder;

TCPServiceDialog::TCPServiceDialog(FWObject *obj) 
{ 
    object=obj;
    
    ttips->set_tip( *name            , TT_tcp_udp_name, 0);

    ttips->set_tip( *src_range_start , TT_tcp_udp_src_port_range, 0 );
    ttips->set_tip( *src_range_end   , TT_tcp_udp_src_port_range, 0 );
    ttips->set_tip( *dst_range_start , TT_tcp_udp_dst_port_range, 0 );
    ttips->set_tip( *dst_range_end   , TT_tcp_udp_dst_port_range, 0 );

}

void TCPServiceDialog::wrk2dlg()
{
    name->set_text(object->getName());
    dst_range_start->set_value( object->getInt("dst_range_start"));
    dst_range_end->set_value( object->getInt("dst_range_end"));
    src_range_start->set_value( object->getInt("src_range_start"));
    src_range_end->set_value( object->getInt("src_range_end"));
    comment->set_point(0);
    comment->forward_delete( comment->get_length() );
    comment->insert(object->getComment());

    syn_flag->set_active( object->getBool("syn_flag") );
    ack_flag->set_active( object->getBool("ack_flag") );
    fin_flag->set_active( object->getBool("fin_flag") );
    rst_flag->set_active( object->getBool("rst_flag") );

    name->grab_focus();
}

bool TCPServiceDialog::dlg2wrk()
{
/*
 *  check if name is valid
 */
    if ( ! checkObjectName(name->get_text()) ) return(false);

    object->setName( name->get_text() );
    object->setComment( comment->get_chars(0,comment->get_length()) );

    object->setInt( "dst_range_start" , 
		      dst_range_start->get_value_as_int() );
    object->setInt( "dst_range_end" , 
		      dst_range_end->get_value_as_int() );
/*
    if (object->getInt("dst_range_start")==0)
	object->setInt( "dst_range_start" , 
			  object->getInt("dst_range_end"));
*/

    if (object->getInt("dst_range_end")==0)
	object->setInt( "dst_range_end" , 
			  object->getInt("dst_range_start"));

    object->setInt( "src_range_start" ,
		      src_range_start->get_value_as_int() );
    object->setInt( "src_range_end" ,
		      src_range_end->get_value_as_int() );

    object->setBool( "syn_flag" , syn_flag->get_active() );
    object->setBool( "ack_flag" , ack_flag->get_active() );
    object->setBool( "fin_flag" , fin_flag->get_active() );
    object->setBool( "rst_flag" , rst_flag->get_active() );

    return(true);
}


void TCPServiceDialog::on_syn_flag_toggled()
{   
  data_changed_flag(true);
}

void TCPServiceDialog::on_ack_flag_toggled()
{   
  data_changed_flag(true);
}

void TCPServiceDialog::on_rst_flag_toggled()
{   
  data_changed_flag(true);
}

void TCPServiceDialog::on_fin_flag_toggled()
{   
  data_changed_flag(true);
}

void TCPServiceDialog::on_changed()
{
  data_changed_flag(true);
}
