/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: CustomServiceDialog.cpp,v 1.16 2004/12/01 07:44:52 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"
#include "utils.h"

#include "FWBTree.h"
#include "CustomServiceDialog.h"
#include "ObjectManipulator.h"

#include "fwbuilder/Library.h"
#include "fwbuilder/CustomService.h"
#include "fwbuilder/Resources.h"

#include <qlineedit.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>

#include <iostream>

using namespace libfwbuilder;
using namespace std;

void CustomServiceDialog::loadFWObject(FWObject *o)
{
    obj=o;
    CustomService *s = dynamic_cast<CustomService*>(obj);
    assert(s!=NULL);

    init=true;

    fillLibraries(libs,obj);

    obj_name->setText( QString::fromUtf8(s->getName().c_str()) );
    comment->setText( QString::fromUtf8(s->getComment().c_str()) );

/* fill in platform */
    platform->clear();

    int cp=0;
    QMap<QString,QString> platforms = getAllPlatforms();
    QMap<QString,QString>::iterator i;
    for (i=platforms.begin(); i!=platforms.end(); i++,cp++)
    {
//        cerr << "platform: key=" << i.key() << "  data=" << i.data() << endl;

/* here i.key is platform code ( "ipf", "ipfw", "iptables", "pf")
 * while i.data is human readable name ("ipfilter", "PF" )
 */
        platformReverseMap[i.data()]=i.key();

        platform->insertItem( i.data() );
        if (showPlatform=="") showPlatform = i.key();
        if (showPlatform==i.key()) platform->setCurrentItem( cp );
        allCodes[ i.key() ]=s->getCodeForPlatform( i.key().latin1() ).c_str();
    }

    code->setText( QString::fromUtf8(allCodes[showPlatform] ));

    apply->setEnabled( false );

    obj_name->setEnabled(!o->isReadOnly());
    setDisabledPalette(obj_name);

    libs->setEnabled(!o->isReadOnly());
    setDisabledPalette(libs);

    comment->setReadOnly(o->isReadOnly());
    setDisabledPalette(comment);

//    platform->setEnabled(!o->isReadOnly());

    code->setEnabled(!o->isReadOnly());
    setDisabledPalette(code);


    init=false;
}
    
void CustomServiceDialog::changed()
{
    if (!init)
    {
        QString  pl   = platformReverseMap[platform->currentText()];
        allCodes[pl] = code->text().utf8();

        apply->setEnabled( true );
    }
}

void CustomServiceDialog::validate(bool *res)
{
    *res=true;
}

void CustomServiceDialog::isChanged(bool *res)
{
    *res=(!init && apply->isEnabled());
}

void CustomServiceDialog::libChanged()
{
    changed();
}

void CustomServiceDialog::platformChanged()
{
    init=true;
    QString npl = platformReverseMap[platform->currentText()];
    code->setText( QString::fromUtf8(allCodes[ npl ]) );
    showPlatform = npl;
    init=false;
//    changed();
}

void CustomServiceDialog::applyChanges()
{
    if (!isTreeReadWrite(this,obj)) return;
    if (!validateName(this,obj,obj_name->text())) return;

    CustomService *s = dynamic_cast<CustomService*>(obj);
    assert(s!=NULL);

    string oldname=obj->getName();
    obj->setName( string(obj_name->text().utf8()) );
    string commText = string(comment->text().utf8());
    obj->setComment( commText );

    QMap<QString,QString>::iterator i;
    for (i=allCodes.begin(); i!=allCodes.end(); ++i)
    {
        string code = string(i.data().utf8());
        if (fwbdebug)
            qDebug("Storing custom service code %s :: %s",
                   i.key().latin1(),code.c_str());
        s->setCodeForPlatform( i.key().latin1(), code );
    }
    om->updateObjName(obj,QString::fromUtf8(oldname.c_str()));
 
    init=true;

/* move to another lib if we have to */
    if (! FWBTree::isSystem(obj) && libs->currentText() != QString(obj->getLibrary()->getName().c_str()))
        om->moveObject(libs->currentText(), obj);

    init=false;

    apply->setEnabled( false );
}

void CustomServiceDialog::discardChanges()
{
    loadFWObject(obj);
}

/* ObjectEditor class connects its slot to this signal and does all
 * the verification for us, then accepts (or not) the event. So we do
 * nothing here and defer all the processing to ObjectEditor
 */
void CustomServiceDialog::closeEvent(QCloseEvent *e)
{
    emit close_sign(e);

}

