/*
 * cfgmgt.c
 * Thomas Nemeth, le 25.09.1999
 *
 * Gestion de la configuration de gAcc, gestionnaire de comptes
 * banquaires personnels avec GTK+.
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h> 
#include <string.h>
#include <strings.h>
#include <sys/stat.h>
#include <errno.h>
#include "structs.h"
#include "defines.h"
#include "usefull.h"
#include "fileaccess.h"
#include "acclists.h"
#include "cfgmgt.h"
#include "accounts.h"
#include "operations.h"
#include "categories.h"
#include "tiers.h"
#include "oldversions.h"

int config_part (char *config_str) {
    char KEY [KEYLENGTH];
    int  i;

    for (i = 0 ; i < KEYLENGTH ; i++) {
        if (config_str[i] == ':') {
            KEY[i] = 0;
            break;
        } else
            KEY[i] = config_str[i];
    }
    #ifdef DEBUG_GACC
        printf ("Clef lue : %s\n", KEY);
    #endif
    if (strcmp (KEY, "CATFIL") == 0) return CFG_CATFIL;
    if (strcmp (KEY, "ACCFIL") == 0) return CFG_ACCFIL;
    if (strcmp (KEY, "TRSFIL") == 0) return CFG_TRSFIL;
    if (strcmp (KEY, "CURREN") == 0) return CFG_CURREN;
    if (strcmp (KEY, "CURPOS") == 0) return CFG_CURPOS;
    if (strcmp (KEY, "LSTACC") == 0) return CFG_LSTACC;
    if (strcmp (KEY, "USELOA") == 0) return CFG_USELOA;
    if (strcmp (KEY, "AUTSAV") == 0) return CFG_AUTSAV;
    if (strcmp (KEY, "TEAROF") == 0) return CFG_TEAROF;
    if (strcmp (KEY, "DATFOR") == 0) return CFG_DATFOR;
    if (strcmp (KEY, "DATSEP") == 0) return CFG_DATSEP;
    if (strcmp (KEY, "EURVAL") == 0) return CFG_EURVAL;
    if (strcmp (KEY, "ADVANC") == 0) return CFG_ADVANC;
    if (strcmp (KEY, "PSPRNC") == 0) return CFG_PSPRNC;
    if (strcmp (KEY, "PSPRNO") == 0) return CFG_PSPRNO;
    if (strcmp (KEY, "ASPRNC") == 0) return CFG_ASPRNC;
    if (strcmp (KEY, "ASPRNO") == 0) return CFG_ASPRNO;
    if (strcmp (KEY, "HLPPTH") == 0) return CFG_HLPPTH;
    if (strcmp (KEY, "CATPTH") == 0) return CFG_CATPTH;
    if (strcmp (KEY, "DECIPT") == 0) return CFG_DECIPT;
    return CFG_UNKNWN;
}

/* void load_config_from_last_version (FILE *file) {
    config.trs_list_head   = NULL;
    config.cat_list_head   = NULL;
    config.accfilename     = NULL;
    config.catfilename     = NULL;
    config.trsfilename     = NULL;
    config.catfilename     = get_string_from_file (file);
    config.accfilename     = get_string_from_file (file);
    config.trsfilename     = get_string_from_file (file);
    config.Currency        = get_string_from_file (file);
    config.CurrencyPos     = get_int_from_file    (file);
    config.LastOpenedAcc   = get_int_from_file    (file);
    config.UseLastAcc      = get_int_from_file    (file);
    config.AutoSave        = get_int_from_file    (file);
    config.TearOff         = get_int_from_file    (file);
    config.DateFormat      = get_int_from_file    (file);
    config.DateSeparator   = get_char_from_file   (file);
    config.EuroValue       = get_float_from_file  (file);
    config.Advanced        = get_int_from_file    (file);
    config.ps_prn_cmd      = get_string_from_file (file);
    config.ps_prn_opt      = get_string_from_file (file);
    config.asc_prn_cmd     = get_string_from_file (file);
    config.asc_prn_opt     = get_string_from_file (file);
    // ATTENTION : LES 2 LEMENTS SUIVANTS PEUVENT DJ TRE ALLOUS !
    config.help_path       = get_string_from_file (file);
    config.cat_sys_wide    = get_string_from_file (file);
    config.AccDataModified = FAUX;
    config.CatDataModified = FAUX;
    config.TrsDataModified = FAUX;
    config.ConfigModified  = FAUX;
}
*/

void load_config_from_last_version (FILE *file) {
    char  tmpstr [MAXSTRLEN + 1];

    setlocale (LC_NUMERIC, "C");
    config.trs_list_head   = NULL;
    config.cat_list_head   = NULL;
    config.accfilename     = NULL;
    config.catfilename     = NULL;
    config.trsfilename     = NULL;
    while (! feof (file) ) {
        fgets (tmpstr, (int) MAXSTRLEN, file);
        #ifdef DEBUG_GACC
            printf ("Ligne lue : %s", tmpstr);
        #endif
        switch (config_part (tmpstr) ) {
            case CFG_CATFIL :
                get_string_from_line (&config.catfilename,   tmpstr);
                break;
            case CFG_ACCFIL :
                get_string_from_line (&config.accfilename,   tmpstr);
                break;
            case CFG_TRSFIL :
                get_string_from_line (&config.trsfilename,   tmpstr);
                break;
            case CFG_CURREN :
                get_string_from_line (&config.Currency,      tmpstr);
                break;
            case CFG_CURPOS :
                get_int_from_line    (&config.CurrencyPos,   tmpstr);
                break;
            case CFG_LSTACC :
                get_int_from_line    (&config.LastOpenedAcc, tmpstr);
                break;
            case CFG_USELOA :
                get_int_from_line    (&config.UseLastAcc,    tmpstr);
                break;
            case CFG_AUTSAV :
                get_int_from_line    (&config.AutoSave,      tmpstr);
                break;
            case CFG_TEAROF :
                get_int_from_line    (&config.TearOff,       tmpstr);
                break;
            case CFG_DATFOR :
                get_int_from_line    (&config.DateFormat,    tmpstr);
                break;
            case CFG_DATSEP :
                get_char_from_line   (&config.DateSeparator, tmpstr);
                break;
            case CFG_DECIPT :
                get_char_from_line   (&config.DecimalPoint,  tmpstr);
                break;
            case CFG_EURVAL :
                get_float_from_line  (&config.EuroValue,     tmpstr);
                break;
            case CFG_ADVANC :
                get_int_from_line    (&config.Advanced,      tmpstr);
                break;
            case CFG_PSPRNC :
                get_string_from_line (&config.ps_prn_cmd,    tmpstr);
                break;
            case CFG_PSPRNO :
                get_string_from_line (&config.ps_prn_opt,    tmpstr);
                break;
            case CFG_ASPRNC :
                get_string_from_line (&config.asc_prn_cmd,   tmpstr);
                break;
            case CFG_ASPRNO :
                get_string_from_line (&config.asc_prn_opt,   tmpstr);
                break;
            case CFG_HLPPTH :
                get_string_from_line (&config.help_path,     tmpstr);
                break;
            case CFG_CATPTH :
                get_string_from_line (&config.cat_sys_wide,  tmpstr);
                break;
            default : printf (_("Unrecognised config item :\n%s\n"), tmpstr);
        }
    }
    #ifdef DEBUG_GACC
        printf ("lement de config catfilename   = %s\n", config.catfilename);
        printf ("lement de config accfilename   = %s\n", config.accfilename);
        printf ("lement de config trsfilename   = %s\n", config.trsfilename);
        printf ("lement de config Currency      = %s\n", config.Currency);
        printf ("lement de config CurrencyPos   = %d\n", config.CurrencyPos);
        printf ("lement de config LastOpenedAcc = %d\n", config.LastOpenedAcc);
        printf ("lement de config UseLastAcc    = %d\n", config.UseLastAcc);
        printf ("lement de config AutoSave      = %d\n", config.AutoSave);
        printf ("lement de config TearOff       = %d\n", config.TearOff);
        printf ("lement de config DateFormat    = %d\n", config.DateFormat);
        printf ("lement de config DateSeparator = %c\n", config.DateSeparator);
/*        printf ("lement de config DecimalPoint  = %c\n", config.DecimalPoint);*/
        printf ("lement de config EuroValue     = %f\n", config.EuroValue);
        printf ("lement de config Advanced      = %d\n", config.Advanced);
        printf ("lement de config ps_prn_cmd    = %s\n", config.ps_prn_cmd);
        printf ("lement de config ps_prn_opt    = %s\n", config.ps_prn_opt);
        printf ("lement de config asc_prn_cmd   = %s\n", config.asc_prn_cmd);
        printf ("lement de config asc_prn_opt   = %s\n", config.asc_prn_opt);
        printf ("lement de config help_path     = %s\n", config.help_path);
        printf ("lement de config cat_sys_wide  = %s\n", config.cat_sys_wide);
    #endif
    config.AccDataModified = FAUX;
    config.CatDataModified = FAUX;
    config.TrsDataModified = FAUX;
    config.ConfigModified  = FAUX;
    setlocale (LC_NUMERIC, "");
}

void load_global_config () {
    FILE *file;
    char  tmpstr [MAXSTRLEN + 1];

    if ( (file = fopen (GLOBAL_CONF_FILE, "r") ) != NULL) {
        while (! feof (file) ) {
            fgets (tmpstr, (int) MAXSTRLEN, file);
            switch (config_part (tmpstr) ) {
                case CFG_HLPPTH :
                    get_string_from_line (&config.help_path,    tmpstr);
                    break;
                case CFG_CATPTH :
                    get_string_from_line (&config.cat_sys_wide, tmpstr);
                    break;
            }
        }
    }
}

void load_config (char *filename) {
    FILE    *file;
    char    *FileVersion;
    char    *Home;
    char    *configfile;

    config.AccDataModified = FAUX;
    config.CatDataModified = FAUX;
    config.TrsDataModified = FAUX;

    load_global_config ();

    Home = getenv ("HOME");
    MY_ALLOC (configfile, (MAXSTRLEN + 1), char);
    sprintf (configfile, "%s/%s", Home, CONFIGFILE);

    FileVersion = open_file (configfile, &file);
    if (FileVersion == NULL || strlen (FileVersion) < 3) {
        /*
        MY_ALLOC (config.catfilename, (MAXSTRLEN + 1), char);
        sprintf (config.catfilename, "%s/%s", Home, CATEGORIES_DEFAULT_FILENAME);
        */
        MY_ALLOC (config.accfilename, (MAXSTRLEN + 1), char);
        sprintf (config.accfilename, "%s/%s", Home, ACCOUNT_DEFAULT_FILENAME);
        MY_ALLOC (config.trsfilename, (MAXSTRLEN + 1), char);
        sprintf (config.trsfilename, "%s/%s", Home, TIERS_DEFAULT_FILENAME);

        config.trs_list_head = NULL;
        config.cat_list_head = NULL;
        MY_ALLOC (config.Currency, (MAXSTRLEN + 1), char);
        strcpy (config.Currency, DEFAULT_CURRENCY);
        config.CurrencyPos   = DEFAULT_CURRENCYPOS;
        config.LastOpenedAcc = 0;
        config.UseLastAcc    = FAUX;
        config.AutoSave      = VRAI;
        config.TearOff       = FAUX;
        config.DateFormat    = DEFAULT_DATE_FORMAT;
        config.DateSeparator = DEFAULT_DATE_SEPARATOR;
        config.DecimalPoint  = DEFAULT_DECIMAL_POINT;
        config.EuroValue     = DEFAULT_EURO_VALUE;
        MY_ALLOC (config.ps_prn_cmd, (MAXSTRLEN + 1), char);
        strcpy (config.ps_prn_cmd, DEFAULT_PS_CMD);
        MY_ALLOC (config.ps_prn_opt, (MAXSTRLEN + 1), char);
        strcpy (config.ps_prn_opt, DEFAULT_PS_OPT);
        MY_ALLOC (config.asc_prn_cmd, (MAXSTRLEN + 1), char);
        strcpy (config.asc_prn_cmd, DEFAULT_ASC_CMD);
        MY_ALLOC (config.asc_prn_opt, (MAXSTRLEN + 1), char);
        strcpy (config.asc_prn_opt, DEFAULT_ASC_OPT);
        create_directory ();

        config_set_cat_filename (config.cat_sys_wide);
        config.cat_list_head = NULL;
        read_categories_from_file ();
        sprintf(configfile, "%s/%s", Home, CATEGORIES_DEFAULT_FILENAME);
        config_set_cat_filename (configfile);
        write_categories_to_file ();

        write_config ();
    } else {
        if (in_versions ("0.7.2", VERSION, FileVersion) == VRAI)
            load_config_from_last_version (file);
        else if (in_versions ("0.7.0", "0.7.1", FileVersion) == VRAI)
            load_config_from_070_to_071 (file);
        else if (in_versions ("0.6.9", "0.6.9", FileVersion) == VRAI)
            load_config_from_069 (file);
        else if (in_versions ("0.6.8", "0.6.8", FileVersion) == VRAI)
            load_config_from_068 (file);
        else if (in_versions ("0.0.0", "0.6.7", FileVersion) == VRAI)
            load_config_from_000_to_067 (file);
        else {
            printf ("File version : %s -- Program version : %s\n",
                    FileVersion, VERSION);
            fatal_error ( _("Cannot open this file !") );
        }
        free (FileVersion);
        fclose (file);
    }

    config.graph_d0  = NULL;
    config.graph_d1  = NULL;
    config.graph_fnt = NULL;

    if (config.help_path == NULL) {
        MY_ALLOC (config.help_path, strlen (HELP_FILENAME) + 1, char);
        strcpy (config.help_path, HELP_FILENAME);
    }
    if (config.cat_sys_wide == NULL) {
        MY_ALLOC (config.cat_sys_wide, strlen (SYSTEM_WIDE_CATEGORIES_DEF) + 1, char);
        strcpy (config.cat_sys_wide, SYSTEM_WIDE_CATEGORIES_DEF);
    }

    if (config.catfilename != NULL)
        read_categories_from_file ();
/*
    else {
        config_set_cat_filename (config.cat_sys_wide);
        config.cat_list_head = NULL;
        read_categories_from_file ();
        sprintf(configfile, "%s/%s", Home, CATEGORIES_DEFAULT_FILENAME);
        config_set_cat_filename (configfile);
        write_categories_to_file ();
    }
*/

    if (config.trsfilename != NULL)
        read_tiers_from_file ();
    else {
        TIERS *trs;
        ACC_ELT *acc = config.acc_list_head; 
        config.trs_list_head = NULL;
        while (acc != NULL) {
            trs = tiers_new ();
            trs_set_name (trs, acc->account->name);
            trs_set_num  (trs, get_tiers_next_num () );
            trs_set_flag (trs, VRAI);
            add_tiers (trs);
            acc = acc->next;
        }
        sprintf (configfile, "%s/%s", Home, TIERS_DEFAULT_FILENAME);
        config_set_trs_filename (configfile);
        write_tiers_to_file ();
    }

    /* reading last account must be AFTER categories and tiers loading */
    if (filename != NULL) config_set_acc_filename (filename);

    if (config.accfilename != NULL)
        read_accounts_from_file ();
    else
        config.acc_list_head = NULL;

    config.help_history = NULL;
}

void write_config () {
    FILE    *file;
    char    *Home;
    char     configfile[MAXSTRLEN + 1];

    setlocale (LC_NUMERIC, "C");
    Home = getenv ("HOME");
    sprintf (configfile, "%s/%s", Home, CONFIGFILE);

    if ( (file = fopen (configfile, "w") ) == NULL) {
        fatal_error (configfile);
    } else {
        create_file_header (file, "gAcc Configuration file");
        fprintf (file, "CATFIL: %s\n",    config.catfilename ?
                 config.catfilename : "");
        fprintf (file, "ACCFIL: %s\n",    config.accfilename ?
                 config.accfilename : "");
        fprintf (file, "TRSFIL: %s\n",    config.trsfilename ?
                 config.trsfilename : "");
        fprintf (file, "CURREN: %s\n",    config.Currency ? 
                 config.Currency : "");
        fprintf (file, "CURPOS: %d\n",    config.CurrencyPos);
        fprintf (file, "LSTACC: %d\n",    config.LastOpenedAcc);
        fprintf (file, "USELOA: %d\n",    config.UseLastAcc);
        fprintf (file, "AUTSAV: %d\n",    config.AutoSave);
        fprintf (file, "TEAROF: %d\n",    config.TearOff);
        fprintf (file, "DATFOR: %d\n",    config.DateFormat);
        fprintf (file, "DATSEP: %c\n",    config.DateSeparator);
/*        fprintf (file, "DECIPT: %c\n",    config.DecimalPoint);*/
        fprintf (file, "EURVAL: %1.5f\n", config.EuroValue);
        fprintf (file, "ADVANC: %d\n",    config.Advanced);
        fprintf (file, "PSPRNC: %s\n",    config.ps_prn_cmd ?
                 config.ps_prn_cmd : DEFAULT_PS_CMD);
        fprintf (file, "PSPRNO: %s\n",    config.ps_prn_opt ?
                 config.ps_prn_opt : "");
        fprintf (file, "ASPRNC: %s\n",    config.asc_prn_cmd ?
                 config.asc_prn_cmd : DEFAULT_ASC_CMD);
        fprintf (file, "ASPRNO: %s\n",    config.asc_prn_opt ?
                 config.asc_prn_opt : "");
        fprintf (file, "HLPPTH: %s\n",    config.help_path ?
                 config.help_path : "");
        fprintf (file, "CATPTH: %s\n",    config.cat_sys_wide ?
                 config.cat_sys_wide : "");
        fclose (file);
    }
    setlocale (LC_NUMERIC, "");
}

void create_directory () {
    char configdir[MAXSTRLEN + 1];
    int code;
    char    *Home;

    Home = getenv ("HOME");
    sprintf (configdir, "%s/%s", Home, CONFIGDIR);
    code = mkdir (configdir, S_IRUSR | S_IWUSR | S_IXUSR);

    if (code == -1) {
        perror (configdir);
        exit (1);
    }
}


/* Functions to manage configuration elements */

void config_set_cat_filename (const char *cat_filename) {
    if (config.catfilename != NULL) {
        free (config.catfilename);
        config.catfilename = NULL;
    }
    if (cat_filename != NULL) {
        MY_ALLOC (config.catfilename, (strlen (cat_filename) + 1), char);
        strcpy (config.catfilename, cat_filename);
        config.ConfigModified = VRAI;
    }
}

void config_set_acc_filename (const char *acc_filename) {
    if (config.accfilename != NULL) {
        free (config.accfilename);
        config.accfilename = NULL;
    }
    if (acc_filename != NULL) {
        MY_ALLOC (config.accfilename, (strlen (acc_filename) + 1), char);
        strcpy (config.accfilename, acc_filename);
        config.ConfigModified = VRAI;
    }
}

void config_set_trs_filename (const char *trs_filename) {
    if (config.trsfilename != NULL) {
        free (config.trsfilename);
        config.trsfilename = NULL;
    }
    if (trs_filename != NULL) {
        MY_ALLOC (config.trsfilename, (strlen (trs_filename) + 1), char);
        strcpy (config.trsfilename, trs_filename);
        config.ConfigModified = VRAI;
    }
}

void config_set_currency (const char *currency) {
    if (config.Currency != NULL) {
        free (config.Currency);
        config.Currency = NULL;
    }
    if (currency != NULL) {
        MY_ALLOC (config.Currency, (strlen (currency) + 1), char);
        strcpy (config.Currency, currency);
        config.ConfigModified = VRAI;
    }
}

void config_set_currency_pos (int currency_pos) {
    if ( (currency_pos == CURRENCY_BEFORE) ||
         (currency_pos == CURRENCY_AFTER) ) {
        config.CurrencyPos    = currency_pos;
        config.ConfigModified = VRAI;
    }
}

void config_set_last_opened_acc (int last_opened_acc) {
    if (last_opened_acc > -1) {
        config.LastOpenedAcc  = last_opened_acc;
        config.ConfigModified = VRAI;
    }
}

void config_set_use_last_acc (int use_last_acc) {
    if ( (use_last_acc == FAUX) || (use_last_acc == VRAI) ) {
        config.UseLastAcc     = use_last_acc;
        config.ConfigModified = VRAI;
    }
}

void config_set_auto_save (int auto_save) {
    if ( (auto_save == FAUX) || (auto_save == VRAI) ) {
        config.AutoSave       = auto_save;
        config.ConfigModified = VRAI;
    }
}

void config_set_tear_off (int tear_off) {
    if ( (tear_off == FAUX) || (tear_off == VRAI) ) {
        config.TearOff        = tear_off;
        config.ConfigModified = VRAI;
    }
}

void config_set_date_format (int date_format) {
    if ( (date_format == FRENCH_DATE) ||
         (date_format == ENGLISH_DATE) ) {
        config.DateFormat     = date_format;
        config.ConfigModified = VRAI;
    }
}

void config_set_date_separator (const char *date_separator) {
    if ( (date_separator != NULL) && (date_separator[0] != 0) ) {
        config.DateSeparator  = date_separator[0];
        config.ConfigModified = VRAI;
    }
}

void config_set_decimal_point (const char *decimal_point) {
    if ( (decimal_point != NULL) && (decimal_point[0] != 0) ) {
        config.DecimalPoint   = decimal_point[0];
        config.ConfigModified = VRAI;
    }
}

void config_set_euro_value (float euro_value) {
    if (euro_value > 0.0) {
        config.EuroValue  = euro_value;
        config.ConfigModified = VRAI;
    }
}

void config_set_advanced (int advanced) {
    if (advanced >= ADVANCED_BASIC) {
        config.Advanced       = advanced;
        config.ConfigModified = VRAI;
    }
}

void config_set_ps_prn_cmd (const char *ps_cmd) {
    if (config.ps_prn_cmd != NULL) {
        free (config.ps_prn_cmd);
        config.ps_prn_cmd = NULL;
    }
    if (ps_cmd != NULL) {
        MY_ALLOC (config.ps_prn_cmd, (strlen (ps_cmd) + 1), char);
        strcpy (config.ps_prn_cmd, ps_cmd);
        config.ConfigModified = VRAI;
    } else {
        config.ps_prn_cmd = DEFAULT_PS_CMD;
    }
}

void config_set_ps_prn_opt (const char *ps_opt) {
    if (config.ps_prn_opt != NULL) {
        free (config.ps_prn_opt);
        config.ps_prn_opt = NULL;
    }
    if (ps_opt != NULL) {
        MY_ALLOC (config.ps_prn_opt, (strlen (ps_opt) + 1), char);
        strcpy (config.ps_prn_opt, ps_opt);
        config.ConfigModified = VRAI;
    } else {
        config.ps_prn_opt = DEFAULT_PS_OPT;
    }
}

void config_set_asc_prn_cmd (const char *asc_cmd) {
    if (config.asc_prn_cmd != NULL) {
        free (config.asc_prn_cmd);
        config.asc_prn_cmd = NULL;
    }
    if (asc_cmd != NULL) {
        MY_ALLOC (config.asc_prn_cmd, (strlen (asc_cmd) + 1), char);
        strcpy (config.asc_prn_cmd, asc_cmd);
        config.ConfigModified = VRAI;
    } else {
        config.asc_prn_cmd = DEFAULT_ASC_CMD;
    }
}

void config_set_asc_prn_opt (const char *asc_opt) {
    if (config.asc_prn_opt != NULL) {
        free (config.asc_prn_opt);
        config.asc_prn_opt = NULL;
    }
    if (asc_opt != NULL) {
        MY_ALLOC (config.asc_prn_opt, (strlen (asc_opt) + 1), char);
        strcpy (config.asc_prn_opt, asc_opt);
        config.ConfigModified = VRAI;
    } else {
        config.asc_prn_opt = DEFAULT_ASC_OPT;
    }
}

int advanced_contains (int advanced_feature) {
    if ( (config.Advanced & advanced_feature) == advanced_feature) return VRAI;
    return FAUX;
}

void new_wallet () {
    free_accounts ();
    config_set_acc_filename (NULL);
    config.AccDataModified = FAUX;
}
